/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.screens;

import com.anordinarypeople.coordinatemanager.cache.Coordinate;
import com.anordinarypeople.coordinatemanager.cache.WorldCache;
import com.anordinarypeople.coordinatemanager.data.CoordinateData;
import com.anordinarypeople.coordinatemanager.data.ListCoordinate;
import com.anordinarypeople.coordinatemanager.data.ListSelectableCoor;
import com.anordinarypeople.coordinatemanager.data.SelectableCoor;
import com.anordinarypeople.coordinatemanager.enums.SelectConfirmType;
import com.anordinarypeople.coordinatemanager.screens.ManageScreen;
import com.anordinarypeople.coordinatemanager.screens.confirm.ClearAllConfirm;
import com.anordinarypeople.coordinatemanager.screens.confirm.DeleteConfirm;
import com.anordinarypeople.coordinatemanager.screens.confirm.SelectConfirm;
import com.anordinarypeople.coordinatemanager.utils.BaseContainerScreen;
import com.anordinarypeople.coordinatemanager.utils.CopyXYZ;
import com.anordinarypeople.coordinatemanager.utils.DimensionColor;
import com.anordinarypeople.coordinatemanager.utils.Messager;
import com.anordinarypeople.coordinatemanager.widgets.Button;
import com.anordinarypeople.coordinatemanager.widgets.container.ContainerPanel;
import com.anordinarypeople.coordinatemanager.widgets.container.detail.DetailPanel;
import java.io.File;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class HistoryScreen
extends BaseContainerScreen {
    private final ManageScreen parent;
    private final Button button = new Button(0, 0, 0, 20);
    private ArrayList<String> deleteQueue = new ArrayList(Coordinate.INSTANCE.size());
    private class_342 searchWidget;
    private ContainerPanel containerPanel;
    private DetailPanel detailPanel;
    private class_4185 selectedButton;
    public ListSelectableCoor mapData = null;
    public boolean manualUpdate = false;
    public int totalSelected;

    public HistoryScreen(ManageScreen parent) {
        super("history.title");
        this.parent = parent;
    }

    private void initMapData(ListCoordinate data) {
        this.totalSelected = 0;
        if (data == null) {
            data = Coordinate.INSTANCE;
        }
        if (this.mapData == null) {
            this.mapData = new ListSelectableCoor(data.size());
        }
        ListSelectableCoor temp = new ListSelectableCoor(data.size());
        for (CoordinateData obj : data) {
            SelectableCoor map = new SelectableCoor(obj.name, obj.dimension, obj.x, obj.y, obj.z);
            map.uuid = obj.uuid;
            map.imagePath = obj.imagePath;
            map.isPinned = obj.isPinned;
            for (SelectableCoor coor : this.mapData) {
                if (!coor.uuid.equals(obj.uuid)) continue;
                map.isSelected = coor.isSelected;
                if (!coor.isSelected) break;
                ++this.totalSelected;
                break;
            }
            temp.add(map);
        }
        this.mapData = temp;
    }

    private void renderSearch(int width) {
        this.searchWidget = new class_342(this.field_22793, 5, 5, width, 20, (class_2561)class_2561.method_43473());
        this.searchWidget.method_47404((class_2561)class_2561.method_43471((String)"history.search").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.searchWidget.method_1863(text -> this.containerPanel.filter((String)text));
        this.method_37063((class_364)this.searchWidget);
    }

    private void renderContainer(int width) {
        this.containerPanel = new ContainerPanel(this.field_22787, width, this.field_22790 - 20 - 25 - 15 - 2, 5, 32, 30, this.mapData, this, true);
        this.containerPanel.filter("");
        this.method_37063((class_364)this.containerPanel);
    }

    private void renderDetail(int containerPanelWidth) {
        this.detailPanel = new DetailPanel(this, this.field_22793, this.field_22787, containerPanelWidth + 10, 5, (int)((double)this.field_22789 * 0.4 - 10.0 - 2.0), this.field_22790 - 25 - 10 + 2);
        this.method_37063((class_364)this.detailPanel.description);
        this.method_37063((class_364)this.detailPanel.nameField);
        this.method_37063((class_364)this.detailPanel.xField);
        this.method_37063((class_364)this.detailPanel.yField);
        this.method_37063((class_364)this.detailPanel.zField);
        this.method_37063((class_364)this.detailPanel.favoriteButton);
        this.method_37063((class_364)this.detailPanel.copyButton);
        this.method_37063((class_364)this.detailPanel.selectButton);
        this.method_37063((class_364)this.detailPanel.deleteButton);
        this.method_37063((class_364)this.detailPanel.saveButton);
    }

    private void renderOpenSelectedBtn() {
        this.button.x = 5;
        this.selectedButton = this.button.widget("history.set_selected", "history.set_selected.tooltip", b -> this.field_22787.method_1507((class_437)new SelectConfirm(this)));
        this.updateSelectedBtnText();
        this.method_37063((class_364)this.selectedButton);
    }

    private void updateSelectedBtnText() {
        this.selectedButton.field_22763 = this.totalSelected > 0;
        this.selectedButton.method_25355((class_2561)class_2561.method_43469((String)(this.selectedButton.field_22763 ? "history.set_selected.total" : "history.set_selected"), (Object[])new Object[]{this.totalSelected > 99 ? "99+" : Integer.valueOf(this.totalSelected)}));
    }

    private void renderClearUnfavoriteBtn() {
        this.button.x = 10 + this.button.width;
        this.method_37063((class_364)this.button.widget("history.clear_unfavorite", "history.clear_unfavorite.tooltip", b -> this.field_22787.method_1507((class_437)new ClearAllConfirm(this))));
    }

    private void refreshContainerList(ListCoordinate temp, boolean skipInstance) {
        if (!skipInstance) {
            Coordinate.INSTANCE = temp;
        }
        this.initMapData(temp);
        this.updateSelectedBtnText();
        this.containerPanel.list = this.mapData;
        this.containerPanel.filter(this.searchWidget.method_1882());
    }

    private void renderBackBtn() {
        this.button.x = 15 + this.button.width * 2;
        this.method_37063((class_364)this.button.widget("history.back", b -> this.method_25419()));
    }

    private void coordinateUpdater() {
        this.mapData.set(Coordinate.set(this.currentData, false), this.currentData);
        this.containerPanel.list = this.mapData;
        this.containerPanel.filter(this.searchWidget.method_1882());
    }

    @Override
    public void onSelected(SelectableCoor data) {
        this.currentData = data;
        this.detailPanel.updateDetail(data);
    }

    public void onClickPin() {
        if (this.currentData != null) {
            this.currentData.isPinned = !this.currentData.isPinned;
            this.coordinateUpdater();
        }
    }

    public void onClickCopy() {
        if (this.currentData != null) {
            this.method_25419();
            String coordinate = CopyXYZ.copy(this.field_22787, this.currentData.x, this.currentData.y, this.currentData.z);
            class_5250 xyz = class_2561.method_43470((String)coordinate).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(-1));
            class_5250 dimension = class_2561.method_43471((String)this.currentData.dimension).method_10862(class_2583.field_24360.method_36139(DimensionColor.get(this.currentData.dimension)));
            if (this.parent == null) {
                this.field_22787.field_1724.method_7353((class_2561)Messager.info("history.copy.success", xyz, dimension), false);
            } else {
                this.field_22787.method_1566().method_1999((class_368)class_370.method_29047((class_310)this.field_22787, (class_370.class_9037)class_370.class_9037.field_47583, (class_2561)class_2561.method_43471((String)"keybind.category"), (class_2561)class_2561.method_43469((String)"history.copy.success", (Object[])new Object[]{xyz, dimension})));
            }
        }
    }

    public void onClickSelect() {
        if (this.currentData == null) {
            return;
        }
        for (SelectableCoor data : this.mapData) {
            if (!data.uuid.equals(this.currentData.uuid)) continue;
            data.isSelected = !data.isSelected;
            this.totalSelected += data.isSelected ? 1 : -1;
            this.updateSelectedBtnText();
            break;
        }
    }

    public void onClickDelete() {
        if (this.currentData != null && !this.currentData.isPinned) {
            this.field_22787.method_1507((class_437)new DeleteConfirm(this));
        }
    }

    public void onClickSave() {
        if (this.currentData != null) {
            this.currentData.name = this.detailPanel.nameField.method_1882();
            this.currentData.x = Double.parseDouble(this.detailPanel.xField.method_1882());
            this.currentData.y = Double.parseDouble(this.detailPanel.yField.method_1882());
            this.currentData.z = Double.parseDouble(this.detailPanel.zField.method_1882());
            this.coordinateUpdater();
        }
    }

    public void deleteConfirmed() {
        Coordinate.set(this.currentData, true);
        if (this.currentData.imagePath != null) {
            this.deleteQueue.add(this.currentData.imagePath);
        }
        if (this.currentData.isSelected) {
            --this.totalSelected;
        }
        this.currentData = null;
        this.refreshContainerList(null, true);
    }

    public void onSelectedConfirmed(SelectConfirmType confirmType) {
        this.currentData = null;
        ListCoordinate temp = new ListCoordinate(this.mapData.size());
        for (SelectableCoor data : this.mapData) {
            if (confirmType == SelectConfirmType.DELETE) {
                if (!data.isSelected) {
                    data.isSelected = false;
                    temp.add(data);
                }
                if (!data.isSelected || data.imagePath == null) continue;
                this.deleteQueue.add(data.imagePath);
                continue;
            }
            if (data.isSelected) {
                data.isSelected = false;
                data.isPinned = confirmType == SelectConfirmType.FAVORITE;
            }
            temp.add(data);
        }
        this.refreshContainerList(temp, false);
    }

    public void onClearAllConfirmed() {
        ListCoordinate temp = new ListCoordinate(this.mapData.size());
        this.totalSelected = 0;
        this.currentData = null;
        for (SelectableCoor data : this.mapData) {
            if (data.isPinned) {
                if (data.isSelected) {
                    ++this.totalSelected;
                }
                temp.add(data);
            }
            if (data.isPinned || data.imagePath == null) continue;
            this.deleteQueue.add(data.imagePath);
        }
        this.refreshContainerList(temp, false);
        this.updateSelectedBtnText();
    }

    public boolean method_25404(class_11908 keyInput) {
        return super.method_25404(keyInput) || this.searchWidget.method_25404(keyInput) || this.detailPanel.nameField.method_25404(keyInput) || this.detailPanel.xField.method_25404(keyInput) || this.detailPanel.yField.method_25404(keyInput) || this.detailPanel.zField.method_25404(keyInput);
    }

    public boolean method_25400(class_11905 chr) {
        return this.searchWidget.method_25400(chr) || this.detailPanel.nameField.method_25400(chr) || this.detailPanel.xField.method_25400(chr) || this.detailPanel.yField.method_25400(chr) || this.detailPanel.zField.method_25400(chr);
    }

    public void method_25419() {
        Coordinate.save();
        Thread.ofVirtual().start(() -> {
            for (String path : this.deleteQueue) {
                File file = new File(path);
                if (!file.exists()) continue;
                file.delete();
            }
            WorldCache.save();
        });
        if (this.parent != null) {
            this.parent.refreshList();
            this.field_22787.method_1507((class_437)this.parent);
        } else {
            super.method_25419();
        }
    }

    protected void method_25426() {
        int containerPanelWidth = (int)((double)this.field_22789 * 0.6) - 5;
        this.initMapData(null);
        this.renderSearch(containerPanelWidth);
        this.renderContainer(containerPanelWidth);
        this.renderDetail(containerPanelWidth);
        int footerY = this.field_22790 - 25;
        this.button.y = footerY + 2;
        this.button.width = (this.field_22789 - 20) / 3;
        this.renderOpenSelectedBtn();
        this.renderClearUnfavoriteBtn();
        this.renderBackBtn();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.currentData != null) {
            this.detailPanel.renderImage(context, this.currentData);
            if (!this.detailPanel.favoriteButton.field_22764) {
                this.detailPanel.updateDetail(this.currentData);
            }
        } else if (this.currentData == null && this.detailPanel.favoriteButton.field_22764) {
            this.detailPanel.updateDetail(null);
        }
    }
}

