/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.utils;

import com.anordinarypeople.coordinatemanager.utils.Console;
import com.anordinarypeople.coordinatemanager.utils.LoadFileFromLoader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public class Storage<T> {
    private final Console logger = new Console("storage");
    private final Gson gson = new GsonBuilder().serializeNulls().create();
    private final T baseValue;
    private Type generic;
    public File file;

    public Storage(String storageKey, T defaultValue, Type typeOfT) {
        this.baseValue = defaultValue;
        this.file = LoadFileFromLoader.fabric(String.format("coordinatemanager/%s.json", storageKey));
        this.generic = typeOfT;
        if (!this.file.exists()) {
            this.createJson();
        }
    }

    private void createJson() {
        try {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
            try (FileWriter writer = new FileWriter(this.file);){
                this.gson.toJson(this.baseValue, (Appendable)writer);
            }
        }
        catch (IOException e) {
            this.logger.errorFile("write JSON", this.file, e);
        }
    }

    private T getJson() {
        Object data = null;
        try (FileReader reader = new FileReader(this.file);){
            data = this.gson.fromJson((Reader)reader, this.generic);
        }
        catch (IOException e) {
            this.logger.errorFile("read JSON", this.file, e);
        }
        return (T)data;
    }

    public T getAll() {
        return this.getJson();
    }

    public void setAll(T value) {
        try (FileWriter writer = new FileWriter(this.file);){
            this.gson.toJson(value, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.errorFile("write JSON", this.file, e);
        }
    }
}

