/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.widgets.world;

import com.anordinarypeople.coordinatemanager.data.WorldData;
import com.anordinarypeople.coordinatemanager.utils.TextTrim;
import com.anordinarypeople.coordinatemanager.utils.WorldKeyword;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5250;

public class WorldPanelEntry
extends class_4280.class_4281<WorldPanelEntry> {
    public final WorldData data;
    private final class_310 client;
    private final Pattern pattern;
    private class_332 context;

    public WorldPanelEntry(class_310 client, WorldData data, Pattern pattern) {
        this.client = client;
        this.data = data;
        this.pattern = pattern;
    }

    private class_5250 trim(class_2561 text) {
        return TextTrim.trim(this.client.field_1772, text, this.method_73387());
    }

    private class_5250 getTitle() {
        return this.trim((class_2561)class_2561.method_43470((String)this.data.worldName));
    }

    private void renderTitle(int x, int y) {
        this.context.method_51439(this.client.field_1772, (class_2561)this.getTitle(), x + 3, y + 1, -1, true);
    }

    private void renderDescription(int x, int y) {
        boolean hasPattern = this.pattern != null;
        int matched = hasPattern ? WorldKeyword.countMatched(this.data, this.pattern) : 0;
        class_5250 text = class_2561.method_43469((String)(hasPattern ? "management.description_matched" : "management.description"), (Object[])new Object[]{hasPattern ? matched : this.data.keywords.size()});
        if (!this.data.isSingleplayer) {
            text.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43471((String)"management.multiplayer"));
        }
        class_327 class_3272 = this.client.field_1772;
        class_5250 class_52502 = this.trim((class_2561)text);
        Objects.requireNonNull(this.client.field_1772);
        this.context.method_51439(class_3272, (class_2561)class_52502, x + 3, y + 9 + 3, -8355712, true);
    }

    public class_2561 method_37006() {
        return this.getTitle();
    }

    public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean hovered, float delta) {
        int x = this.method_46426();
        int y = this.method_46427();
        this.context = drawContext;
        this.renderTitle(x, y);
        this.renderDescription(x, y);
    }
}

