/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.screens;

import com.anordinarypeople.coordinatemanager.cache.Coordinate;
import com.anordinarypeople.coordinatemanager.cache.WorldCache;
import com.anordinarypeople.coordinatemanager.data.CoordinateData;
import com.anordinarypeople.coordinatemanager.data.EmptyWorld;
import com.anordinarypeople.coordinatemanager.data.SelectableCoor;
import com.anordinarypeople.coordinatemanager.data.WorldData;
import com.anordinarypeople.coordinatemanager.data.WorldSearch;
import com.anordinarypeople.coordinatemanager.screens.ChooseWorldScreen;
import com.anordinarypeople.coordinatemanager.screens.ManageScreen;
import com.anordinarypeople.coordinatemanager.utils.BaseContainerScreen;
import com.anordinarypeople.coordinatemanager.utils.Console;
import com.anordinarypeople.coordinatemanager.utils.LoadFileFromLoader;
import com.anordinarypeople.coordinatemanager.utils.TextTrim;
import com.anordinarypeople.coordinatemanager.widgets.Button;
import com.anordinarypeople.coordinatemanager.widgets.TextField;
import com.anordinarypeople.coordinatemanager.widgets.container.ContainerPanel;
import com.anordinarypeople.coordinatemanager.widgets.empty.EmptyWorldPanel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class WorldNameScreen
extends BaseContainerScreen {
    private final Console logger = new Console("WorldNameScreen");
    private final Button button = new Button(0, 0, 0, 20);
    private final String coordinatePath = "coordinatemanager/coordinates";
    private final class_437 parent;
    private final List<EmptyWorld> data;
    private EmptyWorldPanel leftPanel;
    private ContainerPanel containerPanel;
    private class_4185 selectWidget;
    private class_4185 submit;
    private int totalInputHeight;
    private int leftPanelWidth;
    private int containerWidth;
    private int totalSubmitted = 0;
    private boolean hasRendered = false;
    private boolean chooseWorldInitiated = false;
    private boolean submitRerender = false;
    public ArrayList<String> availableWorlds = new ArrayList();
    public EmptyWorld selected;

    public WorldNameScreen(class_437 parent, List<EmptyWorld> data) {
        super("world_name.title");
        this.parent = parent;
        this.data = data;
    }

    private void initWorlds() {
        if (this.chooseWorldInitiated) {
            return;
        }
        if (this.availableWorlds.size() > 0) {
            this.availableWorlds.removeIf(world -> {
                boolean bool = false;
                for (EmptyWorld empty : this.data) {
                    if (empty.name != world) continue;
                    bool = true;
                    break;
                }
                return bool;
            });
            return;
        }
        Path coordinates = LoadFileFromLoader.getDir().resolve("coordinatemanager/coordinates");
        this.availableWorlds = new ArrayList(WorldCache.INSTANCE.size());
        this.chooseWorldInitiated = true;
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(coordinates);){
            block7: for (Path path : paths) {
                String fileName = path.getFileName().toString().replaceFirst("\\.json$", "");
                boolean matched = false;
                for (WorldData world2 : WorldCache.INSTANCE) {
                    if (!fileName.equals(world2.worldName != null ? Coordinate.sanitize(world2.worldName) : null)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                for (EmptyWorld empty : this.data) {
                    if (empty.name != null) continue;
                    this.availableWorlds.add(fileName);
                    continue block7;
                }
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private void renderTitle() {
        int height = 15;
        TextField desc1 = new TextField(this.field_22793, 5, 5, this.field_22789, height);
        TextField desc2 = new TextField(this.field_22793, 5, 5 + height, this.field_22789, height);
        this.totalInputHeight = height * 2;
        desc1.text = class_2561.method_43471((String)"world_name.description").method_10862(class_2583.field_24360.method_36139(-145664));
        this.method_37063((class_364)desc1.label());
        this.method_37063((class_364)desc2.label("world_name.description_2"));
    }

    private void renderList() {
        this.leftPanel = new EmptyWorldPanel(this.field_22787, this.leftPanelWidth, this.field_22790 - this.totalInputHeight - 25 - 15 - 2, 5, 12 + this.totalInputHeight, 15, this.data, data -> {
            this.selected = data;
            this.selectWidget.method_25355((class_2561)(data.name != null ? this.trim((class_2561)class_2561.method_43470((String)data.name)) : class_2561.method_43471((String)"world_name.select")));
            this.containerPanel.list = data.data;
            this.hasRendered = false;
        }, this);
        this.leftPanel.showEntries();
        this.method_37063((class_364)this.leftPanel);
    }

    private void renderSelect() {
        int x = this.leftPanelWidth + 10;
        int y = 10 + this.totalInputHeight;
        Button button = new Button(x, y, this.containerWidth, 20);
        this.selectWidget = button.widget("world_name.select", b -> this.onSelect());
        this.selectWidget.field_22763 = false;
        this.method_37063((class_364)this.selectWidget);
    }

    private void renderContainer() {
        this.containerPanel = new ContainerPanel(this.field_22787, this.containerWidth, this.field_22790 - this.totalInputHeight - 20 - 25 - 20 - 2, this.leftPanelWidth + 10, 17 + this.totalInputHeight + 20, 30, null, this, false);
        this.containerPanel.filter("");
        this.method_37063((class_364)this.containerPanel);
    }

    private void renderSubmitBtn() {
        this.button.x = 5;
        this.submit = class_4185.method_46430((class_2561)this.submitText(), b -> this.onSubmitWorlds()).method_46434(this.button.x, this.button.y, this.button.width, this.button.height).method_46431();
        this.submit.field_22763 = false;
        this.method_37063((class_364)this.submit);
    }

    private void renderBackBtn() {
        this.button.x = 10 + this.button.width;
        this.method_37063((class_364)this.button.widget("history.back", b -> this.method_25419()));
    }

    private class_5250 trim(class_2561 text) {
        return TextTrim.trim(this.field_22793, text, this.containerWidth - 10);
    }

    private class_5250 submitText() {
        int size = this.data.size();
        if (size != this.totalSubmitted) {
            int temp = size - this.totalSubmitted;
            return class_2561.method_43469((String)"world_name.submit_more", (Object[])new Object[]{temp > 99 ? "99+" : Integer.valueOf(temp)});
        }
        return class_2561.method_43471((String)"world_name.submit");
    }

    private void onSelect() {
        this.initWorlds();
        this.field_22787.method_1507((class_437)new ChooseWorldScreen(this));
    }

    public void onSubmit(String worldName) {
        this.chooseWorldInitiated = false;
        for (EmptyWorld empty : this.data) {
            if (this.selected.index != empty.index) continue;
            empty.name = worldName;
            ++this.totalSubmitted;
            break;
        }
        this.submitRerender = this.totalSubmitted == this.data.size();
        this.submit.method_25355((class_2561)this.submitText());
    }

    private void onSubmitWorlds() {
        Gson gson = new GsonBuilder().serializeNulls().create();
        block14: for (EmptyWorld empty : this.data) {
            File file = LoadFileFromLoader.fabric(String.format("%s/%s.json", "coordinatemanager/coordinates", Coordinate.sanitize(empty.name)));
            if (!file.exists()) {
                ArrayList<CoordinateData> coordinates = new ArrayList<CoordinateData>(empty.data.size());
                for (SelectableCoor coordinate : empty.data) {
                    coordinates.add(new CoordinateData(coordinate.name, "", coordinate.x, coordinate.y, coordinate.z));
                }
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    try (FileWriter writer = new FileWriter(file);){
                        gson.toJson(coordinates, (Appendable)writer);
                    }
                }
                catch (IOException e) {
                    this.logger.errorFile("write JSON", file, e);
                }
            }
            int idx = 0;
            for (WorldData world : WorldCache.INSTANCE) {
                if (idx == empty.index) {
                    ArrayList<WorldSearch> keywords = new ArrayList<WorldSearch>(empty.data.size());
                    world.worldName = empty.name;
                    for (SelectableCoor coordinate : empty.data) {
                        keywords.add(new WorldSearch(coordinate.name, coordinate.x, coordinate.y, coordinate.z));
                    }
                    world.keywords = keywords;
                    continue block14;
                }
                ++idx;
            }
        }
        File file = LoadFileFromLoader.fabric(String.format("%s/%s.json", "coordinatemanager", "worlds"));
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson(WorldCache.INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.errorFile("write JSON", file, e);
        }
        WorldCache.load();
        this.field_22787.method_1507((class_437)new ManageScreen(this.parent));
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        this.leftPanelWidth = (int)((double)this.field_22789 * 0.3) - 5;
        this.containerWidth = (int)((double)this.field_22789 * 0.7) - 10;
        this.renderTitle();
        this.renderContainer();
        this.renderSelect();
        this.renderList();
        int footerY = this.field_22790 - 25;
        this.button.y = footerY + 2;
        this.button.width = (this.field_22789 - 15) / 2;
        this.renderSubmitBtn();
        this.renderBackBtn();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.selected != null && !this.hasRendered) {
            this.hasRendered = true;
            this.selectWidget.field_22763 = true;
            this.containerPanel.filter("");
        }
        if (this.submitRerender) {
            this.submitRerender = false;
            this.submit.field_22763 = true;
        }
    }
}

