/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.widgets.world;

import com.anordinarypeople.coordinatemanager.cache.WorldCache;
import com.anordinarypeople.coordinatemanager.data.WorldData;
import com.anordinarypeople.coordinatemanager.screens.ManageScreen;
import com.anordinarypeople.coordinatemanager.utils.RenderHelper;
import com.anordinarypeople.coordinatemanager.utils.WorldKeyword;
import com.anordinarypeople.coordinatemanager.widgets.world.WorldPanelEntry;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class WorldPanel
extends class_4280<WorldPanelEntry>
implements AutoCloseable {
    private final ManageScreen parent;
    private class_5250 description;
    private Consumer<String> onSelected;
    private class_332 context;

    public WorldPanel(class_310 client, int width, int height, int x, int y, int itemHeight, Consumer<String> onSelected, ManageScreen parent) {
        super(client, width, height, y, itemHeight);
        this.method_46421(x);
        this.onSelected = onSelected;
        this.parent = parent;
    }

    @Nullable
    private WorldPanelEntry getEntry(int index) {
        return this.method_25396().size() > index ? (WorldPanelEntry)((Object)this.method_25396().get(index)) : null;
    }

    private void drawItem(int entryCount, int index, int entryTop, int mouseX, int mouseY, float delta) {
        int entryHeight = this.field_62109 - 5;
        int rowWidth = this.method_25322();
        WorldPanelEntry entry = this.getEntry(index);
        WorldPanelEntry selected = (WorldPanelEntry)this.method_25334();
        if (selected != null && selected.data.worldName.equals(entry.data.worldName)) {
            this.drawSelected(entryTop, entryHeight, this.method_25342() - 2, rowWidth);
        }
        entry.method_25343(this.context, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(entryCount, mouseX, mouseY), (Object)entry), delta);
    }

    private void drawSelected(int entryTop, int entryHeight, int entryLeft, int rowWidth) {
        RenderHelper.drawSelected(this.context, this.method_25342(), rowWidth, entryLeft, entryTop, entryHeight);
    }

    private WorldPanelEntry getEntryAtPos(int entryCount, double x, double y) {
        int entryY = class_3532.method_15357((double)(y - (double)this.method_46427() + (double)((int)this.method_44387()) - 4.0));
        int index = entryY / this.field_62109;
        int rowLeft = this.method_25342();
        return x < (double)this.method_65507() && x >= (double)rowLeft && x <= (double)rowLeft + (double)this.method_31383() && index >= 0 && entryY >= 0 && index < entryCount ? (WorldPanelEntry)((Object)this.method_25396().get(index)) : null;
    }

    private void scrollToTop() {
        int max = Math.max(0, this.method_44395() - this.method_55443() - this.method_46427() - 4);
        if (this.method_44387() > (double)max) {
            this.method_44382(max);
        }
    }

    public void filter(String keyword) {
        if (WorldCache.INSTANCE == null || WorldCache.INSTANCE.size() == 0) {
            this.description = class_2561.method_43471((String)"container.description");
            return;
        }
        String lowered = keyword.toLowerCase();
        Pattern pattern = Pattern.compile(lowered);
        boolean clearDescription = false;
        this.method_25339();
        for (WorldData data : WorldCache.INSTANCE) {
            if (data.keywords.size() == 0 || !lowered.isBlank() && (data.worldName == null || !pattern.matcher(data.worldName.toLowerCase()).find()) && WorldKeyword.countMatched(data, pattern) <= 0) continue;
            clearDescription = true;
            this.method_25321((class_350.class_351)new WorldPanelEntry(this.field_22740, data, lowered.isBlank() ? null : pattern));
        }
        this.description = clearDescription ? null : class_2561.method_43471((String)"container.description_not_found");
        this.scrollToTop();
    }

    @Override
    public void close() {
    }

    public void setSelected(WorldPanelEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.onSelected.accept(entry.data.worldName);
    }

    public int method_25322() {
        return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.method_46426() + 6;
    }

    protected void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.description != null) {
            drawContext.method_51439(this.field_22740.field_1772, (class_2561)this.description, this.parent.padding * 2, this.parent.inputHeight + this.parent.padding * 3 + 2, -1, true);
            return;
        }
        int entryCount = this.method_25340();
        this.context = drawContext;
        for (int i = 0; i < entryCount; ++i) {
            int entryTop = this.method_25337(i) + 2;
            int entryBottom = this.method_25337(i) + this.field_62109 + 2;
            if (entryBottom < this.method_46427() || entryTop > this.method_55443()) continue;
            this.drawItem(entryCount, i, entryTop, mouseX, mouseY, delta);
        }
    }
}

