/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager;

import com.anordinarypeople.coordinatemanager.cache.Coordinate;
import com.anordinarypeople.coordinatemanager.cache.ModConfig;
import com.anordinarypeople.coordinatemanager.cache.WorldCache;
import com.anordinarypeople.coordinatemanager.data.CoordinateData;
import com.anordinarypeople.coordinatemanager.enums.CaptureMode;
import com.anordinarypeople.coordinatemanager.screens.CaptureScreen;
import com.anordinarypeople.coordinatemanager.utils.Console;
import com.anordinarypeople.coordinatemanager.utils.CopyXYZ;
import com.anordinarypeople.coordinatemanager.utils.LoadFileFromLoader;
import com.anordinarypeople.coordinatemanager.utils.Messager;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import net.minecraft.class_5321;

public class CaptureHandler {
    private final Console logger = new Console("capture-handler");
    private class_5321<class_1937> dimension;
    private class_310 client;
    private CaptureScreen screen;
    private String imagePath = null;
    public String name = null;
    public double x;
    public double y;
    public double z;

    private double rounded(double value) {
        return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private String getDimension() {
        if (this.dimension == class_1937.field_25179) {
            return "dimension.overworld";
        }
        if (this.dimension == class_1937.field_25180) {
            return "dimension.nether";
        }
        if (this.dimension == class_1937.field_25181) {
            return "dimension.end";
        }
        return "dimension.unknown";
    }

    private void createImage() {
        class_276 framebuffer = this.client.method_1522();
        File path = LoadFileFromLoader.fabric("coordinatemanager");
        String filename = String.format("%s_%s.png", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()), this.getCoordinate().replaceAll("[XYZ.\\-:, ]+", ""));
        File imageFile = new File(path, "screenshots/" + filename);
        class_318.method_22690((File)path, (String)filename, (class_276)framebuffer, (int)1, successText -> this.virtualProcess(imageFile));
        this.imagePath = imageFile.getAbsolutePath();
    }

    private void virtualProcess(File imageFile) {
        Thread.ofVirtual().start(() -> {
            try {
                BufferedImage original = ImageIO.read(imageFile);
                BufferedImage resized = new BufferedImage(128, 128, 2);
                Graphics2D g = resized.createGraphics();
                g.drawImage(original.getScaledInstance(128, 128, 4), 0, 0, null);
                g.dispose();
                ImageIO.write((RenderedImage)resized, "png", imageFile);
            }
            catch (IOException e) {
                this.logger.errorFile("read/write image", imageFile, e);
            }
        });
    }

    private String getCoordinate() {
        return String.format("X: %.2f, Y: %.2f, Z: %.2f", this.x, this.y, this.z);
    }

    private void message() {
        this.client.field_1724.method_7353((class_2561)Messager.info(ModConfig.INSTANCE.autoCopy ? "capture.success_with_copy" : "capture.success", this.getCoordinate(), class_2561.method_43471((String)this.getDimension())), false);
    }

    public void saveCoordinate() {
        CoordinateData data = new CoordinateData(this.name, this.getDimension(), this.x, this.y, this.z);
        data.imagePath = this.imagePath;
        Coordinate.INSTANCE.addFirst(data);
        Coordinate.save();
        WorldCache.save();
        this.message();
    }

    public void deleteImage() {
        new File(this.imagePath).delete();
    }

    public void store(class_310 mcClient) {
        this.client = mcClient;
        this.dimension = this.client.field_1687.method_27983();
        this.x = this.rounded(this.client.field_1724.method_23317());
        this.y = this.rounded(this.client.field_1724.method_23318());
        this.z = this.rounded(this.client.field_1724.method_23321());
        if (!ModConfig.INSTANCE.isPreciseCoordinate) {
            this.x = (int)this.x;
            this.y = (int)this.y;
            this.z = (int)this.z;
        }
        if (ModConfig.INSTANCE.autoCopy) {
            CopyXYZ.copy(this.client, this.x, this.y, this.z);
        }
        if (ModConfig.INSTANCE.enableImage) {
            this.createImage();
        }
        if (ModConfig.INSTANCE.captureMode == CaptureMode.INSTANT) {
            this.name = null;
            this.saveCoordinate();
        } else {
            this.screen = new CaptureScreen(this);
            this.client.method_1507((class_437)this.screen);
        }
    }
}

