/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.cache;

import com.anordinarypeople.coordinatemanager.cache.Coordinate;
import com.anordinarypeople.coordinatemanager.data.CoordinateData;
import com.anordinarypeople.coordinatemanager.data.WorldData;
import com.anordinarypeople.coordinatemanager.data.WorldSearch;
import com.anordinarypeople.coordinatemanager.utils.Storage;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class WorldCache {
    private static Storage<List<WorldData>> storage = new Storage("worlds", new ArrayList(), new TypeToken<List<WorldData>>(){}.getType());
    public static int IS_SINGLEPLAYER = 2;
    public static List<WorldData> INSTANCE;

    private static List<WorldSearch> createKeywords() {
        ArrayList<WorldSearch> temp = new ArrayList<WorldSearch>(Coordinate.INSTANCE.size());
        for (CoordinateData data : Coordinate.INSTANCE) {
            temp.add(new WorldSearch(data.name, data.x, data.y, data.z));
        }
        return temp;
    }

    private static boolean isSingle(boolean fallback) {
        return IS_SINGLEPLAYER < 2 ? IS_SINGLEPLAYER == 1 : fallback;
    }

    private static void saveWorld(String world) {
        boolean isUpdated = false;
        List<WorldSearch> keywords = WorldCache.createKeywords();
        for (int i = 0; i < INSTANCE.size(); ++i) {
            WorldData data = INSTANCE.get(i);
            if (!world.equals(data.worldName)) continue;
            INSTANCE.set(i, new WorldData(world, WorldCache.isSingle(data.isSingleplayer), keywords));
            isUpdated = true;
            break;
        }
        if (!isUpdated) {
            INSTANCE.add(new WorldData(world, WorldCache.isSingle(true), keywords));
        }
        storage.setAll(INSTANCE);
    }

    public static void save() {
        Thread.ofVirtual().start(() -> WorldCache.saveWorld(Coordinate.CURRENT_WORLD));
    }

    public static void save(String world) {
        WorldCache.saveWorld(world);
    }

    public static void directSave() {
        storage.setAll(INSTANCE);
    }

    public static void load() {
        INSTANCE = storage.getAll();
    }
}

