/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.screens;

import com.anordinarypeople.coordinatemanager.cache.Coordinate;
import com.anordinarypeople.coordinatemanager.cache.WorldCache;
import com.anordinarypeople.coordinatemanager.data.WorldData;
import com.anordinarypeople.coordinatemanager.data.WorldSearch;
import com.anordinarypeople.coordinatemanager.enums.DeleteAllType;
import com.anordinarypeople.coordinatemanager.screens.ConfigScreen;
import com.anordinarypeople.coordinatemanager.screens.HistoryScreen;
import com.anordinarypeople.coordinatemanager.screens.confirm.ManageDelConfirm;
import com.anordinarypeople.coordinatemanager.utils.TextTrim;
import com.anordinarypeople.coordinatemanager.widgets.Button;
import com.anordinarypeople.coordinatemanager.widgets.world.WorldPanel;
import java.io.File;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class ManageScreen
extends class_437 {
    public final int inputHeight = 20;
    public final int padding = 5;
    private final class_437 parent;
    private final int footerHeight = 25;
    private final Button button = new Button(0, 0, 0, 20);
    private WorldPanel worldPanel;
    private class_342 searchWidget;
    private class_4185 deleteButton;
    private class_4185 openWorldButton;
    private String selectedWorld;

    public ManageScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"management.title"));
        this.parent = parent;
    }

    private void renderSearch() {
        this.searchWidget = new class_342(this.field_22793, 5, 5, (int)((double)this.field_22789 * 0.7) - 10, 20, (class_2561)class_2561.method_43473());
        this.searchWidget.method_47404((class_2561)class_2561.method_43471((String)"management.search").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.searchWidget.method_1863(text -> this.worldPanel.filter((String)text));
        this.method_37063((class_364)this.searchWidget);
    }

    private void renderConfigBtn() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"management.config"), b -> this.field_22787.method_1507(ConfigScreen.get(this))).method_46434((int)((double)this.field_22789 * 0.7), 5, (int)((double)this.field_22789 * 0.3) - 5, 20).method_46431());
    }

    private void renderWorld() {
        this.worldPanel = new WorldPanel(this.field_22787, this.field_22789 - 10, this.field_22790 - 20 - 25 - 15 - 2, 5, 32, 30, worldName -> {
            Coordinate.load(worldName);
            this.selectedWorld = worldName;
            this.deleteButton.field_22763 = true;
            this.openWorldButton.field_22763 = true;
            this.openWorldButton.method_25355((class_2561)TextTrim.trim(this.field_22787.field_1772, (class_2561)class_2561.method_43470((String)worldName), this.button.width));
            this.openWorldButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)"management.open_world.tooltip_selected", (Object[])new Object[]{worldName})));
        }, this);
        this.worldPanel.filter("");
        this.method_37063((class_364)this.worldPanel);
    }

    private void renderOpenWorldBtn() {
        this.button.x = 5;
        this.openWorldButton = this.button.widget("management.open_world", "management.open_world.tooltip", b -> this.field_22787.method_1507((class_437)new HistoryScreen(this)));
        this.openWorldButton.field_22763 = false;
        this.method_37063((class_364)this.openWorldButton);
    }

    private void renderDeleteBtn() {
        this.button.x = 10 + this.button.width;
        this.deleteButton = this.button.widget("management.delete", "management.delete.tooltip", b -> this.field_22787.method_1507((class_437)new ManageDelConfirm(this, this.selectedWorld)));
        this.deleteButton.field_22763 = false;
        this.method_37063((class_364)this.deleteButton);
    }

    private void renderBackBtn() {
        this.button.x = 15 + this.button.width * 2;
        this.method_37063((class_364)this.button.widget("history.back", b -> this.method_25419()));
    }

    private void virtualDeleteImages(ArrayList<String> paths) {
        Thread.ofVirtual().start(() -> {
            for (String path : paths) {
                File file = new File(path);
                if (!file.exists()) continue;
                file.delete();
            }
        });
    }

    public void onDeleteConfirmed(DeleteAllType confirmType) {
        int size = Coordinate.INSTANCE.size();
        boolean isUnfavorite = confirmType == DeleteAllType.UNFAVORITE;
        ArrayList<String> paths = new ArrayList<String>(size);
        ArrayList<WorldSearch> keepKeywords = new ArrayList<WorldSearch>(size);
        Coordinate.INSTANCE.removeIf(data -> {
            boolean isDelete = true;
            if (isUnfavorite && data.isPinned) {
                keepKeywords.add(new WorldSearch(data.name != null ? data.name : "", data.x, data.y, data.z));
                isDelete = false;
            }
            if (isDelete && data.imagePath != null) {
                paths.add(data.imagePath);
            }
            return isDelete;
        });
        if (isUnfavorite && Coordinate.INSTANCE.size() > 0) {
            for (WorldData data2 : WorldCache.INSTANCE) {
                if (!data2.worldName.equals(this.selectedWorld)) continue;
                data2.keywords = keepKeywords;
                break;
            }
            Coordinate.save();
        } else {
            WorldCache.INSTANCE.removeIf(data -> data.worldName.equals(this.selectedWorld));
            Coordinate.JSON_FILE.delete();
        }
        WorldCache.directSave();
        this.virtualDeleteImages(paths);
    }

    public void refreshList() {
        this.searchWidget.method_1852("");
        this.worldPanel.filter("");
    }

    public boolean method_25404(class_11908 keyInput) {
        return super.method_25404(keyInput) || this.searchWidget.method_25404(keyInput);
    }

    public boolean method_25400(class_11905 chr) {
        return this.searchWidget.method_25400(chr);
    }

    public void method_25419() {
        String world;
        class_1132 server = class_310.method_1551().method_1576();
        if (server != null && !(world = server.method_27728().method_150()).equals(Coordinate.CURRENT_WORLD)) {
            Coordinate.load(world);
        }
        this.field_22787.method_1507(this.parent);
    }

    protected void method_25426() {
        this.renderSearch();
        this.renderConfigBtn();
        this.renderWorld();
        int footerY = this.field_22790 - 25;
        this.button.y = footerY + 2;
        this.button.width = (this.field_22789 - 20) / 3;
        this.renderOpenWorldBtn();
        this.renderDeleteBtn();
        this.renderBackBtn();
    }
}

