/*
 * Decompiled with CFR 0.152.
 */
package com.anordinarypeople.coordinatemanager.widgets.empty;

import com.anordinarypeople.coordinatemanager.data.EmptyWorld;
import com.anordinarypeople.coordinatemanager.screens.WorldNameScreen;
import com.anordinarypeople.coordinatemanager.utils.RenderHelper;
import com.anordinarypeople.coordinatemanager.widgets.empty.EmptyWorldPanelEntry;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import org.jetbrains.annotations.Nullable;

public class EmptyWorldPanel
extends class_4280<EmptyWorldPanelEntry>
implements AutoCloseable {
    private final WorldNameScreen parent;
    private final List<EmptyWorld> list;
    private Consumer<EmptyWorld> onSelected;
    private class_332 context;

    public EmptyWorldPanel(class_310 client, int width, int height, int x, int y, int itemHeight, List<EmptyWorld> list, Consumer<EmptyWorld> onSelected, WorldNameScreen parent) {
        super(client, width, height, y, itemHeight);
        this.method_46421(x);
        this.onSelected = onSelected;
        this.parent = parent;
        this.list = list;
    }

    @Nullable
    private EmptyWorldPanelEntry getEntry(int index) {
        return this.method_25396().size() > index ? (EmptyWorldPanelEntry)((Object)this.method_25396().get(index)) : null;
    }

    private void drawItem(int entryCount, int index, int entryTop, int mouseX, int mouseY, float delta) {
        int entryHeight = this.field_62109 - 5;
        int rowWidth = this.method_25322();
        EmptyWorldPanelEntry entry = this.getEntry(index);
        if (this.parent.selected != null && this.parent.selected.index == entry.data.index) {
            this.drawSelected(entryTop, entryHeight, this.method_25342() - 2, rowWidth);
        }
        entry.method_25343(this.context, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(entryCount, mouseX, mouseY), (Object)entry), delta);
    }

    private void drawSelected(int entryTop, int entryHeight, int entryLeft, int rowWidth) {
        RenderHelper.drawSelected(this.context, this.method_25342(), rowWidth, entryLeft, entryTop, entryHeight);
    }

    private EmptyWorldPanelEntry getEntryAtPos(int entryCount, double x, double y) {
        int entryY = class_3532.method_15357((double)(y - (double)this.method_46427() + (double)((int)this.method_44387())));
        int index = entryY / this.field_62109;
        int rowLeft = this.method_25342();
        return x < (double)this.method_65507() && x >= (double)rowLeft && x <= (double)rowLeft + (double)this.method_31383() && index >= 0 && entryY >= 0 && index < entryCount ? (EmptyWorldPanelEntry)((Object)this.method_25396().get(index)) : null;
    }

    private void scrollToTop() {
        int max = Math.max(0, this.method_44395() - this.method_55443() - this.method_46427() - 4);
        if (this.method_44387() > (double)max) {
            this.method_44382(max);
        }
    }

    public void showEntries() {
        this.method_25339();
        int position = 0;
        for (EmptyWorld empty : this.list) {
            ++position;
            if (empty.name != null) continue;
            this.method_25321((class_350.class_351)new EmptyWorldPanelEntry(this.field_22740, empty, position));
        }
        this.scrollToTop();
    }

    @Override
    public void close() {
    }

    public void setSelected(EmptyWorldPanelEntry entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.parent.selected == null || this.parent.selected.index != entry.data.index) {
            this.onSelected.accept(entry.data);
        }
    }

    public int method_25322() {
        return this.field_22758 - (Math.max(0, this.method_44395() - (this.method_55443() - this.method_46427() - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.method_46426() + 6;
    }

    protected void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int entryCount = this.method_25340();
        this.context = drawContext;
        for (int i = 0; i < entryCount; ++i) {
            int entryTop = this.method_25337(i) + 2;
            int entryBottom = this.method_25337(i) + this.field_62109 + 2;
            if (entryBottom < this.method_46427() || entryTop > this.method_55443()) continue;
            this.drawItem(entryCount, i, entryTop, mouseX, mouseY, delta);
        }
    }
}

