/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item;

import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IGun {
    @Nullable
    public static IGun getIGunOrNull(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return iGun;
        }
        return null;
    }

    @Deprecated
    public static boolean mainhandHoldGun(LivingEntity livingEntity) {
        return livingEntity.getMainHandItem().getItem() instanceof IGun;
    }

    public static boolean mainHandHoldGun(LivingEntity livingEntity) {
        return livingEntity.getMainHandItem().getItem() instanceof IGun;
    }

    @Deprecated
    public static FireMode getMainhandFireMode(LivingEntity livingEntity) {
        ItemStack mainHandItem = livingEntity.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return iGun.getFireMode(mainHandItem);
        }
        return FireMode.UNKNOWN;
    }

    public static FireMode getMainHandFireMode(LivingEntity livingEntity) {
        ItemStack mainHandItem = livingEntity.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            return iGun.getFireMode(mainHandItem);
        }
        return FireMode.UNKNOWN;
    }

    public float getAimingZoom(ItemStack var1);

    public boolean useDummyAmmo(ItemStack var1);

    public int getDummyAmmoAmount(ItemStack var1);

    public void setDummyAmmoAmount(ItemStack var1, int var2);

    public void addDummyAmmoAmount(ItemStack var1, int var2);

    public boolean hasMaxDummyAmmo(ItemStack var1);

    public int getMaxDummyAmmoAmount(ItemStack var1);

    public void setMaxDummyAmmoAmount(ItemStack var1, int var2);

    public boolean hasAttachmentLock(ItemStack var1);

    public void setAttachmentLock(ItemStack var1, boolean var2);

    @NotNull
    public ResourceLocation getGunId(ItemStack var1);

    public void setGunId(ItemStack var1, @Nullable ResourceLocation var2);

    @NotNull
    public ResourceLocation getGunDisplayId(ItemStack var1);

    public void setGunDisplayId(ItemStack var1, @Nullable ResourceLocation var2);

    public int getLevel(int var1);

    public int getExp(int var1);

    public int getMaxLevel();

    public int getLevel(ItemStack var1);

    public int getExp(ItemStack var1);

    public int getExpToNextLevel(ItemStack var1);

    public int getExpCurrentLevel(ItemStack var1);

    public FireMode getFireMode(ItemStack var1);

    public void setFireMode(ItemStack var1, @Nullable FireMode var2);

    public int getCurrentAmmoCount(ItemStack var1);

    public void setCurrentAmmoCount(ItemStack var1, int var2);

    public void reduceCurrentAmmoCount(ItemStack var1);

    public void dropAllAmmo(Player var1, ItemStack var2);

    @Nonnull
    public ItemStack getAttachment(HolderLookup.Provider var1, ItemStack var2, AttachmentType var3);

    @Nonnull
    public ItemStack getBuiltinAttachment(ItemStack var1, AttachmentType var2);

    @Nullable
    public CompoundTag getAttachmentTag(ItemStack var1, AttachmentType var2);

    public void setAttachmentTag(ItemStack var1, AttachmentType var2, CompoundTag var3);

    @Nonnull
    public ResourceLocation getBuiltInAttachmentId(ItemStack var1, AttachmentType var2);

    @Nonnull
    public ResourceLocation getAttachmentId(ItemStack var1, AttachmentType var2);

    public void installAttachment(HolderLookup.Provider var1, @Nonnull ItemStack var2, @Nonnull ItemStack var3);

    public void unloadAttachment(HolderLookup.Provider var1, @Nonnull ItemStack var2, AttachmentType var3);

    public boolean allowAttachment(ItemStack var1, ItemStack var2);

    public boolean allowAttachmentType(ItemStack var1, AttachmentType var2);

    public boolean hasBulletInBarrel(ItemStack var1);

    public void setBulletInBarrel(ItemStack var1, boolean var2);

    public boolean useInventoryAmmo(ItemStack var1);

    public boolean hasInventoryAmmo(LivingEntity var1, ItemStack var2, boolean var3);

    public int getRPM(ItemStack var1);

    public boolean isCanCrawl(ItemStack var1);

    public boolean hasCustomLaserColor(ItemStack var1);

    public int getLaserColor(ItemStack var1);

    public void setLaserColor(ItemStack var1, int var2);

    public boolean hasHeatData(ItemStack var1);

    public boolean isOverheatLocked(ItemStack var1);

    public void setOverheatLocked(ItemStack var1, boolean var2);

    public void setHeatAmount(ItemStack var1, float var2);

    public float lerpRPM(ItemStack var1);

    public float lerpInaccuracy(ItemStack var1);

    public float getHeatAmount(ItemStack var1);
}

