/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface AmmoBoxItemDataAccessor
extends IAmmoBox {
    public static final String AMMO_ID_TAG = "AmmoId";
    public static final String AMMO_COUNT_TAG = "AmmoCount";
    public static final String CREATIVE_TAG = "Creative";
    public static final String ALL_TYPE_CREATIVE_TAG = "AllTypeCreative";
    public static final String LEVEL_TAG = "Level";

    @Override
    default public ResourceLocation getAmmoId(ItemStack ammoBox) {
        CompoundTag tag = ((CustomData)ammoBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(AMMO_ID_TAG, 8)) {
            return ResourceLocation.parse((String)tag.getString(AMMO_ID_TAG));
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default public void setAmmoId(ItemStack ammoBox, ResourceLocation ammoId) {
        ammoBox.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putString(AMMO_ID_TAG, ammoId.toString())));
    }

    @Override
    default public int getAmmoCount(ItemStack ammoBox) {
        CompoundTag tag = ((CustomData)ammoBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (this.isAllTypeCreative(ammoBox) || this.isCreative(ammoBox)) {
            return Integer.MAX_VALUE;
        }
        if (tag.contains(AMMO_COUNT_TAG, 3)) {
            return tag.getInt(AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setAmmoCount(ItemStack ammoBox, int count) {
        ammoBox.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (this.isCreative(ammoBox)) {
                tag.putInt(AMMO_COUNT_TAG, Integer.MAX_VALUE);
                return;
            }
            tag.putInt(AMMO_COUNT_TAG, count);
        }));
    }

    @Override
    default public boolean isAmmoBoxOfGun(ItemStack gun, ItemStack ammoBox) {
        Item item = gun.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            item = ammoBox.getItem();
            if (item instanceof IAmmoBox) {
                IAmmoBox iAmmoBox = (IAmmoBox)item;
                if (this.isAllTypeCreative(ammoBox)) {
                    return true;
                }
                ResourceLocation ammoId = iAmmoBox.getAmmoId(ammoBox);
                if (ammoId.equals((Object)DefaultAssets.EMPTY_AMMO_ID)) {
                    return false;
                }
                ResourceLocation gunId = iGun.getGunId(gun);
                return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
            }
        }
        return false;
    }

    @Override
    default public ItemStack setAmmoLevel(ItemStack ammoBox, int level) {
        ammoBox.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(LEVEL_TAG, Math.max(level, 0))));
        return ammoBox;
    }

    @Override
    default public int getAmmoLevel(ItemStack ammoBox) {
        CompoundTag tag = ((CustomData)ammoBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(LEVEL_TAG, 3)) {
            return tag.getInt(LEVEL_TAG);
        }
        return 0;
    }

    @Override
    default public boolean isCreative(ItemStack ammoBox) {
        CompoundTag tag = ((CustomData)ammoBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(CREATIVE_TAG, 1)) {
            return tag.getBoolean(CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default public boolean isAllTypeCreative(ItemStack ammoBox) {
        CompoundTag tag = ((CustomData)ammoBox.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ALL_TYPE_CREATIVE_TAG, 1)) {
            return tag.getBoolean(ALL_TYPE_CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default public ItemStack setCreative(ItemStack ammoBox, boolean isAllType) {
        ammoBox.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (isAllType) {
                if (tag.contains(CREATIVE_TAG, 1)) {
                    tag.remove(CREATIVE_TAG);
                }
                tag.putBoolean(ALL_TYPE_CREATIVE_TAG, true);
                return;
            }
            if (tag.contains(ALL_TYPE_CREATIVE_TAG, 1)) {
                tag.remove(ALL_TYPE_CREATIVE_TAG);
            }
            tag.putBoolean(CREATIVE_TAG, true);
        }));
        return ammoBox;
    }
}

