/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.mojang.serialization.DynamicOps;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public interface GunItemDataAccessor
extends IGun {
    public static final String GUN_ID_TAG = "GunId";
    public static final String GUN_FIRE_MODE_TAG = "GunFireMode";
    public static final String GUN_HAS_BULLET_IN_BARREL = "HasBulletInBarrel";
    public static final String GUN_CURRENT_AMMO_COUNT_TAG = "GunCurrentAmmoCount";
    public static final String GUN_ATTACHMENT_BASE = "Attachment";
    public static final String GUN_EXP_TAG = "GunLevelExp";
    public static final String GUN_DUMMY_AMMO = "DummyAmmo";
    public static final String GUN_MAX_DUMMY_AMMO = "MaxDummyAmmo";
    public static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";
    public static final String GUN_DISPLAY_ID_TAG = "GunDisplayId";
    public static final String LASER_COLOR_TAG = "LaserColor";
    public static final String GUN_OVERHEAT_TAG = "HeatAmount";
    public static final String GUN_OVERHEAT_LOCK_TAG = "OverHeated";

    @Override
    default public boolean useDummyAmmo(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return nbt.contains(GUN_DUMMY_AMMO, 3);
    }

    @Override
    default public int getDummyAmmoAmount(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return Math.max(0, nbt.getInt(GUN_DUMMY_AMMO));
    }

    @Override
    default public void setDummyAmmoAmount(ItemStack gun, int amount) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(GUN_DUMMY_AMMO, Math.max(amount, 0))));
    }

    @Override
    default public void addDummyAmmoAmount(ItemStack gun, int amount) {
        if (!this.useDummyAmmo(gun)) {
            return;
        }
        int maxDummyAmmo = Integer.MAX_VALUE;
        if (this.hasMaxDummyAmmo(gun)) {
            maxDummyAmmo = this.getMaxDummyAmmoAmount(gun);
        }
        int dummyAmmo = Math.min(this.getDummyAmmoAmount(gun) + amount, maxDummyAmmo);
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(GUN_DUMMY_AMMO, Math.max(dummyAmmo, 0))));
    }

    @Override
    default public boolean hasMaxDummyAmmo(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return nbt.contains(GUN_MAX_DUMMY_AMMO, 3);
    }

    @Override
    default public int getMaxDummyAmmoAmount(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return Math.max(0, nbt.getInt(GUN_MAX_DUMMY_AMMO));
    }

    @Override
    default public void setMaxDummyAmmoAmount(ItemStack gun, int amount) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(GUN_MAX_DUMMY_AMMO, Math.max(amount, 0))));
    }

    @Override
    default public boolean hasAttachmentLock(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_ATTACHMENT_LOCK, 1)) {
            return nbt.getBoolean(GUN_ATTACHMENT_LOCK);
        }
        return false;
    }

    @Override
    default public void setAttachmentLock(ItemStack gun, boolean lock) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putBoolean(GUN_ATTACHMENT_LOCK, lock)));
    }

    @Override
    @Nonnull
    default public ResourceLocation getGunId(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_ID_TAG, 8)) {
            ResourceLocation gunId = ResourceLocation.tryParse((String)nbt.getString(GUN_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_GUN_ID);
        }
        return DefaultAssets.EMPTY_GUN_ID;
    }

    @Override
    default public void setGunId(ItemStack gun, @Nullable ResourceLocation gunId) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (gunId != null) {
                tag.putString(GUN_ID_TAG, gunId.toString());
            }
        }));
    }

    @Override
    @NotNull
    default public ResourceLocation getGunDisplayId(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_DISPLAY_ID_TAG, 8)) {
            ResourceLocation gunDisplayId = ResourceLocation.tryParse((String)nbt.getString(GUN_DISPLAY_ID_TAG));
            return Objects.requireNonNullElse(gunDisplayId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID);
        }
        return DefaultAssets.DEFAULT_GUN_DISPLAY_ID;
    }

    @Override
    default public void setGunDisplayId(ItemStack gun, ResourceLocation displayId) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (displayId != null) {
                tag.putString(GUN_DISPLAY_ID_TAG, displayId.toString());
            }
        }));
    }

    @Override
    default public int getLevel(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_EXP_TAG, 3)) {
            return this.getLevel(nbt.getInt(GUN_EXP_TAG));
        }
        return 0;
    }

    @Override
    default public int getExp(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_EXP_TAG, 3)) {
            return nbt.getInt(GUN_EXP_TAG);
        }
        return 0;
    }

    @Override
    default public int getExpToNextLevel(ItemStack gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level >= this.getMaxLevel()) {
            return 0;
        }
        int nextLevelExp = this.getExp(level + 1);
        return nextLevelExp - exp;
    }

    @Override
    default public int getExpCurrentLevel(ItemStack gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level <= 0) {
            return exp;
        }
        return exp - this.getExp(level - 1);
    }

    @Override
    default public FireMode getFireMode(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_FIRE_MODE_TAG, 8)) {
            return FireMode.valueOf(nbt.getString(GUN_FIRE_MODE_TAG));
        }
        return FireMode.UNKNOWN;
    }

    @Override
    default public void setFireMode(ItemStack gun, @Nullable FireMode fireMode) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (fireMode != null) {
                tag.putString(GUN_FIRE_MODE_TAG, fireMode.name());
                return;
            }
            tag.putString(GUN_FIRE_MODE_TAG, FireMode.UNKNOWN.name());
        }));
    }

    @Override
    default public int getCurrentAmmoCount(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_CURRENT_AMMO_COUNT_TAG, 3)) {
            return nbt.getInt(GUN_CURRENT_AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setCurrentAmmoCount(ItemStack gun, int ammoCount) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(GUN_CURRENT_AMMO_COUNT_TAG, Math.max(ammoCount, 0))));
    }

    @Override
    default public void reduceCurrentAmmoCount(ItemStack gun) {
        if (!this.useInventoryAmmo(gun)) {
            this.setCurrentAmmoCount(gun, this.getCurrentAmmoCount(gun) - 1);
        }
    }

    @Override
    @Nullable
    default public CompoundTag getAttachmentTag(ItemStack gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return null;
        }
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!nbt.contains(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return null;
        }
        CompoundTag stack = nbt.getCompound(key);
        if (!stack.contains("components", 10)) {
            return null;
        }
        CompoundTag components = stack.getCompound("components");
        if (!components.contains(DataComponents.CUSTOM_DATA.toString())) {
            return null;
        }
        return components.getCompound(DataComponents.CUSTOM_DATA.toString());
    }

    @Override
    default public void setAttachmentTag(ItemStack gun, AttachmentType type, CompoundTag attachmentTag) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            if (!tag.contains(key, 10)) {
                return;
            }
            CompoundTag stack = tag.getCompound(key);
            if (!stack.contains("components", 10)) {
                return;
            }
            CompoundTag components = stack.getCompound("components");
            if (!components.contains(DataComponents.CUSTOM_DATA.toString())) {
                return;
            }
            components.put(DataComponents.CUSTOM_DATA.toString(), (Tag)attachmentTag);
        }));
    }

    @Override
    @NotNull
    default public ItemStack getBuiltinAttachment(ItemStack gun, AttachmentType type) {
        Map<AttachmentType, ResourceLocation> builtin;
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return ItemStack.EMPTY;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null && (builtin = index.getGunData().getBuiltInAttachments()).containsKey((Object)type)) {
            return AttachmentItemBuilder.create().setId(builtin.get((Object)type)).build();
        }
        return ItemStack.EMPTY;
    }

    @Override
    @Nonnull
    default public ItemStack getAttachment(HolderLookup.Provider provider, ItemStack gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return ItemStack.EMPTY;
        }
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return ItemStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.getCompound(key)).result().orElse(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    default public ResourceLocation getBuiltInAttachmentId(ItemStack gun, AttachmentType type) {
        Map<AttachmentType, ResourceLocation> builtin;
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null && (builtin = index.getGunData().getBuiltInAttachments()).containsKey((Object)type)) {
            return builtin.get((Object)type);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    @Nonnull
    default public ResourceLocation getAttachmentId(ItemStack gun, AttachmentType type) {
        CompoundTag attachmentTag = this.getAttachmentTag(gun, type);
        if (attachmentTag != null) {
            return AttachmentItemDataAccessor.getAttachmentIdFromTag(attachmentTag);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    default public void installAttachment(HolderLookup.Provider provider, @Nonnull ItemStack gun, @Nonnull ItemStack attachment) {
        if (!this.allowAttachment(gun, attachment)) {
            return;
        }
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachment);
        if (iAttachment == null) {
            return;
        }
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            String key = GUN_ATTACHMENT_BASE + iAttachment.getType(attachment).name();
            Tag attachmentTag = provider == null ? (Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)attachment).getOrThrow() : attachment.saveOptional(provider);
            tag.put(key, attachmentTag);
        }));
    }

    @Override
    default public void unloadAttachment(HolderLookup.Provider provider, @Nonnull ItemStack gun, AttachmentType type) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            tag.put(key, ItemStack.EMPTY.saveOptional(provider));
        }));
    }

    @Override
    default public float getAimingZoom(ItemStack gunItem) {
        float zoom = 1.0f;
        ResourceLocation scopeId = this.getAttachmentId(gunItem, AttachmentType.SCOPE);
        boolean builtin = false;
        if (scopeId.equals((Object)DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = this.getBuiltInAttachmentId(gunItem, AttachmentType.SCOPE);
            builtin = true;
        }
        if (!DefaultAssets.isEmptyAttachmentId(scopeId)) {
            CompoundTag attachmentTag = this.getAttachmentTag(gunItem, AttachmentType.SCOPE);
            int zoomNumber = builtin ? 0 : AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag);
            float[] zooms = TimelessAPI.getClientAttachmentIndex(scopeId).map(ClientAttachmentIndex::getZoom).orElse(null);
            if (zooms != null) {
                zoom = zooms[zoomNumber % zooms.length];
            }
        } else {
            zoom = TimelessAPI.getGunDisplay(gunItem).map(GunDisplayInstance::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        }
        return zoom;
    }

    @Override
    default public boolean hasBulletInBarrel(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(GUN_HAS_BULLET_IN_BARREL, 1)) {
            return nbt.getBoolean(GUN_HAS_BULLET_IN_BARREL);
        }
        return false;
    }

    @Override
    default public void setBulletInBarrel(ItemStack gun, boolean bulletInBarrel) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putBoolean(GUN_HAS_BULLET_IN_BARREL, bulletInBarrel)));
    }

    @Override
    default public boolean hasCustomLaserColor(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return nbt.contains(LASER_COLOR_TAG, 3);
    }

    @Override
    default public int getLaserColor(ItemStack gun) {
        CompoundTag nbt = ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!this.hasCustomLaserColor(gun)) {
            return 0xFF0000;
        }
        return nbt.getInt(LASER_COLOR_TAG);
    }

    @Override
    default public void setLaserColor(ItemStack gun, int color) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putInt(LASER_COLOR_TAG, color)));
    }

    @Override
    default public boolean hasHeatData(ItemStack gun) {
        return ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().contains(GUN_OVERHEAT_TAG, 5);
    }

    @Override
    default public boolean isOverheatLocked(ItemStack gun) {
        return ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getBoolean(GUN_OVERHEAT_LOCK_TAG);
    }

    @Override
    default public void setOverheatLocked(ItemStack gun, boolean locked) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putBoolean(GUN_OVERHEAT_LOCK_TAG, locked)));
    }

    @Override
    default public float getHeatAmount(ItemStack gun) {
        if (this.hasHeatData(gun)) {
            return ((CustomData)gun.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getFloat(GUN_OVERHEAT_TAG);
        }
        return 0.0f;
    }

    @Override
    default public void setHeatAmount(ItemStack gun, float amount) {
        gun.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> tag.putFloat(GUN_OVERHEAT_TAG, amount >= 0.0f ? amount : 0.0f)));
    }

    @Override
    default public float lerpRPM(ItemStack gun) {
        return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(index -> index.getGunData().getHeatData()).map(heatData -> {
            float heatPercentage = this.getHeatAmount(gun) / heatData.getHeatMax();
            return Float.valueOf(Mth.lerp((float)heatPercentage, (float)heatData.getMinRpmMod(), (float)heatData.getMaxRpmMod()));
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }

    @Override
    default public float lerpInaccuracy(ItemStack gun) {
        return TimelessAPI.getCommonGunIndex(this.getGunId(gun)).map(index -> index.getGunData().getHeatData()).map(heatData -> {
            float heatPercentage = this.getHeatAmount(gun) / heatData.getHeatMax();
            return Float.valueOf(Mth.lerp((float)heatPercentage, (float)heatData.getMinInaccuracy(), (float)heatData.getMaxInaccuracy()));
        }).orElse(Float.valueOf(1.0f)).floatValue();
    }
}

