/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block.entity;

import com.mojang.serialization.DynamicOps;
import com.tacz.guns.block.TargetBlock;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TargetBlockEntity
extends BlockEntity
implements Nameable {
    public static final BlockEntityType<TargetBlockEntity> TYPE = BlockEntityType.Builder.of(TargetBlockEntity::new, (Block[])new Block[]{(Block)ModBlocks.TARGET.get()}).build(null);
    private static final int RESET_TIME = 100;
    private static final String OWNER_TAG = "Owner";
    private static final String CUSTOM_NAME_TAG = "CustomName";
    public float rot = 0.0f;
    public float oRot = 0.0f;
    @Nullable
    private ResolvableProfile owner;
    @Nullable
    private Component name;

    public TargetBlockEntity(BlockPos pos, BlockState blockState) {
        super(TYPE, pos, blockState);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, TargetBlockEntity pBlockEntity) {
        pBlockEntity.oRot = pBlockEntity.rot;
        pBlockEntity.rot = (Boolean)state.getValue((Property)TargetBlock.STAND) != false ? Math.max(pBlockEntity.rot - 18.0f, 0.0f) : Math.min(pBlockEntity.rot + 45.0f, 90.0f);
    }

    @Nullable
    public ResolvableProfile getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable ResolvableProfile owner) {
        this.owner = owner;
        if (this.owner != null) {
            this.owner.resolve().thenAcceptAsync(profile -> {
                this.owner = profile;
                this.refresh();
            }, SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(OWNER_TAG, 10)) {
            this.owner = (ResolvableProfile)DataComponents.PROFILE.codec().parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(OWNER_TAG)).getOrThrow();
        }
        if (tag.contains(CUSTOM_NAME_TAG, 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString(CUSTOM_NAME_TAG), (HolderLookup.Provider)provider);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.put(OWNER_TAG, (Tag)DataComponents.PROFILE.codec().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.owner).getOrThrow());
        }
        if (this.name != null) {
            tag.putString(CUSTOM_NAME_TAG, Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
    }

    public Component getName() {
        return this.name != null ? this.name : Component.empty();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void refresh() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public void hit(Level level, BlockState state, BlockHitResult hit, boolean isUpperBlock) {
        if (this.level != null && ((Boolean)state.getValue((Property)TargetBlock.STAND)).booleanValue()) {
            BlockPos blockPos = hit.getBlockPos();
            if (isUpperBlock) {
                blockPos = blockPos.below();
                state = level.getBlockState(blockPos);
            }
            int redstoneStrength = TargetBlock.getRedstoneStrength(hit, isUpperBlock);
            level.setBlock(blockPos, (BlockState)((BlockState)state.setValue((Property)TargetBlock.STAND, (Comparable)Boolean.valueOf(false))).setValue((Property)TargetBlock.OUTPUT_POWER, (Comparable)Integer.valueOf(redstoneStrength)), 3);
            level.scheduleTick(blockPos, state.getBlock(), 100);
            float volume = (float)((Integer)OtherConfig.TARGET_SOUND_DISTANCE.get()).intValue() / 16.0f;
            volume = Math.max(volume, 0.0f);
            level.playSound(null, blockPos, (SoundEvent)ModSounds.TARGET_HIT.get(), SoundSource.BLOCKS, volume, this.level.random.nextFloat() * 0.1f + 0.9f);
        }
    }
}

