/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public class ItemInHandRendererMixin
implements KeepingItemRenderer {
    @Shadow
    private float mainHandHeight;
    @Shadow
    private float oMainHandHeight;
    @Shadow
    private ItemStack mainHandItem;
    @Unique
    private ItemStack tacz$KeepItem;
    @Unique
    private long tacz$KeepTimeMs;
    @Unique
    private long tacz$KeepTimestamp;

    @Inject(method={"renderHandsWithItems"}, at={@At(value="HEAD")})
    public void beforeHandRender(float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource.BufferSource pBuffer, LocalPlayer pPlayerEntity, int pCombinedLight, CallbackInfo ci) {
        NeoForge.EVENT_BUS.post((Event)new BeforeRenderHandEvent(pMatrixStack));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void cancelEquippedProgress(CallbackInfo ci) {
        long time;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (this.tacz$KeepItem != null && (time = System.currentTimeMillis() - this.tacz$KeepTimestamp) < this.tacz$KeepTimeMs) {
            this.mainHandHeight = 1.0f;
            this.oMainHandHeight = 1.0f;
            this.mainHandItem = this.tacz$KeepItem;
            return;
        }
        ItemStack itemStack = Minecraft.getInstance().player.getMainHandItem();
        IGun iGun = IGun.getIGunOrNull(itemStack);
        if (iGun != null) {
            this.mainHandHeight = 1.0f;
            this.oMainHandHeight = 1.0f;
            this.mainHandItem = itemStack;
        }
    }

    @Override
    @Unique
    public void keep(ItemStack itemStack, long timeMs) {
        long time = System.currentTimeMillis() - this.tacz$KeepTimestamp;
        if (time < this.tacz$KeepTimeMs) {
            return;
        }
        this.tacz$KeepTimeMs = timeMs;
        this.tacz$KeepTimestamp = System.currentTimeMillis();
        this.tacz$KeepItem = itemStack;
        this.mainHandItem = itemStack;
    }

    @Override
    public ItemStack getCurrentItem() {
        if (Minecraft.getInstance().player == null) {
            return this.mainHandItem;
        }
        if (this.tacz$KeepItem != null) {
            long time = System.currentTimeMillis() - this.tacz$KeepTimestamp;
            if (time < this.tacz$KeepTimeMs) {
                return this.tacz$KeepItem;
            }
            this.tacz$KeepItem = null;
        }
        return this.mainHandItem;
    }
}

