/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.model.papi.PapiManager;
import com.tacz.guns.client.resource.pojo.display.gun.Align;
import com.tacz.guns.client.resource.pojo.display.gun.TextShow;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TextShowRender
implements IFunctionalRenderer {
    private final BedrockModel bedrockModel;
    private final TextShow textShow;
    private final ItemStack gunStack;

    public TextShowRender(BedrockModel bedrockModel, TextShow textShow, ItemStack gunStack) {
        this.bedrockModel = bedrockModel;
        this.textShow = textShow;
        this.gunStack = gunStack;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexBuffer, ItemDisplayContext transformType, int light, int overlay) {
        if (!transformType.firstPerson()) {
            return;
        }
        String text = PapiManager.getTextShow(this.textShow.getTextKey(), this.gunStack);
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Matrix3f normal = new Matrix3f((Matrix3fc)poseStack.last().normal());
        Matrix4f pose = new Matrix4f((Matrix4fc)poseStack.last().pose());
        this.bedrockModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
            Font font = Minecraft.getInstance().font;
            boolean shadow = this.textShow.isShadow();
            int color = this.textShow.getColorInt();
            float scale = this.textShow.getScale();
            int packLight = LightTexture.pack((int)this.textShow.getTextLight(), (int)this.textShow.getTextLight());
            int width = font.width(text);
            int xOffset = switch (this.textShow.getAlign()) {
                case Align.CENTER -> width / 2;
                case Align.RIGHT -> width;
                default -> 0;
            };
            PoseStack poseStack2 = new PoseStack();
            poseStack2.last().normal().mul((Matrix3fc)normal);
            poseStack2.last().pose().mul((Matrix4fc)pose);
            poseStack2.scale(0.006666667f * scale, -0.006666667f * scale, -0.006666667f);
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            float f = -xOffset;
            Objects.requireNonNull(font);
            font.drawInBatch(text, f, (float)(-9) / 2.0f, color, shadow, poseStack2.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packLight);
            bufferSource.endBatch();
        });
    }
}

