/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.GunDisplayInstance;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public class AdjustmentYRotModifier
implements Function<String, Optional<AdjustmentModifier.PartModifier>> {
    private final Player player;

    private AdjustmentYRotModifier(Player player) {
        this.player = player;
    }

    @Override
    public Optional<AdjustmentModifier.PartModifier> apply(String partName) {
        Minecraft mc = Minecraft.getInstance();
        if (this.player.equals((Object)mc.player) && mc.screen != null) {
            return Optional.empty();
        }
        if (this.player.getVehicle() != null && "body".equals(partName)) {
            return Optional.empty();
        }
        float partialTick = mc.getTimer().getGameTimeDeltaPartialTick(false);
        float yBodyRot = Mth.rotLerp((float)partialTick, (float)this.player.yBodyRotO, (float)this.player.yBodyRot);
        float yHeadRot = Mth.rotLerp((float)partialTick, (float)this.player.yHeadRotO, (float)this.player.yHeadRot);
        float xRot = Mth.lerp((float)partialTick, (float)this.player.xRotO, (float)this.player.getXRot());
        float yaw = yHeadRot - yBodyRot;
        yaw = Mth.wrapDegrees((float)yaw);
        yaw = Mth.clamp((float)yaw, (float)-85.0f, (float)85.0f);
        float pitch = Mth.wrapDegrees((float)xRot);
        return switch (partName) {
            case "body" -> {
                if (!this.player.isSwimming() && this.player.getPose() == Pose.SWIMMING) {
                    yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, 0.0f, -yaw * ((float)Math.PI / 180)), Vec3f.ZERO));
                }
                yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0.0f, -yaw * ((float)Math.PI / 180), 0.0f), Vec3f.ZERO));
            }
            case "head" -> Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch * ((float)Math.PI / 180), 0.0f, 0.0f), Vec3f.ZERO));
            case "leftArm", "rightArm" -> {
                if (TimelessAPI.getGunDisplay(this.player.getMainHandItem()).map(GunDisplayInstance::is3rdFixedHand).orElse(false).booleanValue()) {
                    yield Optional.empty();
                }
                yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch * ((float)Math.PI / 180), 0.0f, 0.0f), Vec3f.ZERO));
            }
            default -> Optional.empty();
        };
    }

    public static AdjustmentModifier getModifier(Player player) {
        return new AdjustmentModifier((Function)new AdjustmentYRotModifier(player));
    }
}

