/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.client.sound.SoundPlayManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ServerMessageSound
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ServerMessageSound> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"server_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerMessageSound> STREAM_CODEC = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.INT, ServerMessageSound::getEntityId, (StreamCodec)ResourceLocation.STREAM_CODEC, ServerMessageSound::getGunId, (StreamCodec)ResourceLocation.STREAM_CODEC, ServerMessageSound::getGunDisplayId, (StreamCodec)ByteBufCodecs.STRING_UTF8, ServerMessageSound::getSoundName, (StreamCodec)ByteBufCodecs.FLOAT, ServerMessageSound::getVolume, (StreamCodec)ByteBufCodecs.FLOAT, ServerMessageSound::getPitch, (StreamCodec)ByteBufCodecs.INT, ServerMessageSound::getDistance, ServerMessageSound::new);
    private final int entityId;
    private final ResourceLocation gunId;
    private final ResourceLocation gunDisplayId;
    private final String soundName;
    private final float volume;
    private final float pitch;
    private final int distance;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ServerMessageSound(int entityId, ResourceLocation gunId, ResourceLocation gunDisplayId, String soundName, float volume, float pitch, int distance) {
        this.entityId = entityId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.soundName = soundName;
        this.volume = volume;
        this.pitch = pitch;
        this.distance = distance;
    }

    public static void handle(ServerMessageSound message, IPayloadContext context) {
        context.enqueueWork(() -> SoundPlayManager.playMessageSound(message));
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    public ResourceLocation getGunDisplayId() {
        return this.gunDisplayId;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getDistance() {
        return this.distance;
    }
}

