/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.GunIndexPOJO;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;

public class CommonGunIndex {
    private static final Marker MARKER = MarkerManager.getMarker((String)"CommonGunIndex");
    private GunData gunData;
    private String type;
    private GunIndexPOJO pojo;
    private int sort;
    private LuaTable script;
    private LuaTable scriptParam;

    private CommonGunIndex() {
    }

    public static CommonGunIndex getInstance(GunIndexPOJO gunIndexPOJO) throws IllegalArgumentException {
        CommonGunIndex index = new CommonGunIndex();
        index.pojo = gunIndexPOJO;
        CommonGunIndex.checkIndex(gunIndexPOJO, index);
        CommonGunIndex.checkData(gunIndexPOJO, index);
        return index;
    }

    private static void checkIndex(GunIndexPOJO gunIndexPOJO, CommonGunIndex index) {
        Preconditions.checkArgument((gunIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{gunIndexPOJO.getType()}), (Object)"index object missing type field");
        index.type = gunIndexPOJO.getType();
        index.sort = Mth.clamp((int)gunIndexPOJO.getSort(), (int)0, (int)65536);
    }

    private static void checkData(GunIndexPOJO gunIndexPOJO, CommonGunIndex index) {
        ResourceLocation pojoData = gunIndexPOJO.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        GunData data = CommonAssetsManager.get().getGunData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        Preconditions.checkArgument((data.getAmmoId() != null ? 1 : 0) != 0, (Object)"ammo id is empty");
        Preconditions.checkArgument((data.getAmmoAmount() >= 1 ? 1 : 0) != 0, (Object)"ammo count must >= 1");
        int[] extendedMagAmmoAmount = data.getExtendedMagAmmoAmount();
        Preconditions.checkArgument((extendedMagAmmoAmount == null || extendedMagAmmoAmount.length >= 3 ? 1 : 0) != 0, (Object)"extended_mag_ammo_amount size must is 3");
        Preconditions.checkArgument((data.getRoundsPerMinute() >= 1 ? 1 : 0) != 0, (Object)"rpm count must >= 1");
        Preconditions.checkArgument((data.getBolt() != null ? 1 : 0) != 0, (Object)"bolt type is error");
        Preconditions.checkArgument((data.getReloadData().getType() != null ? 1 : 0) != 0, (Object)"reload type is error");
        Preconditions.checkArgument((!data.getFireModeSet().isEmpty() ? 1 : 0) != 0, (Object)"fire mode is empty");
        Preconditions.checkArgument((!data.getFireModeSet().contains(null) && !data.getFireModeSet().contains((Object)FireMode.UNKNOWN) ? 1 : 0) != 0, (Object)"fire mode is error");
        CommonGunIndex.checkInaccuracy(data);
        CommonGunIndex.checkRecoil(data);
        CommonGunIndex.checkScript(data, index);
        index.gunData = data;
    }

    private static void checkInaccuracy(GunData data) {
        Map<InaccuracyType, Float> defaultInaccuracy = InaccuracyType.getDefaultInaccuracy();
        Map<InaccuracyType, Float> readInaccuracy = data.getInaccuracy();
        if (readInaccuracy == null || readInaccuracy.isEmpty()) {
            data.setInaccuracy(defaultInaccuracy);
        } else {
            defaultInaccuracy.forEach(readInaccuracy::putIfAbsent);
        }
    }

    private static void checkRecoil(GunData data) {
        float[] value;
        GunRecoil recoil = data.getRecoil();
        Object[] pitch = recoil.getPitch();
        Object[] yaw = recoil.getYaw();
        if (pitch != null) {
            for (Object keyFrame : pitch) {
                value = ((GunRecoilKeyFrame)keyFrame).getValue();
                Preconditions.checkArgument((value.length == 2 ? 1 : 0) != 0, (Object)"Recoil value's length must be 2");
                Preconditions.checkArgument((value[0] <= value[1] ? 1 : 0) != 0, (Object)"Recoil value's left must be less than right");
                Preconditions.checkArgument((((GunRecoilKeyFrame)keyFrame).getTime() >= 0.0f ? 1 : 0) != 0, (Object)"Recoil time must be more than 0");
            }
            Arrays.sort(pitch);
        }
        if (yaw != null) {
            for (Object keyFrame : yaw) {
                value = ((GunRecoilKeyFrame)keyFrame).getValue();
                Preconditions.checkArgument((value.length == 2 ? 1 : 0) != 0, (Object)"Recoil value's length must be 2");
                Preconditions.checkArgument((value[0] <= value[1] ? 1 : 0) != 0, (Object)"Recoil value's left must be less than right");
                Preconditions.checkArgument((((GunRecoilKeyFrame)keyFrame).getTime() >= 0.0f ? 1 : 0) != 0, (Object)"Recoil time must be more than 0");
            }
            Arrays.sort(yaw);
        }
    }

    private static void checkScript(GunData data, CommonGunIndex index) {
        Map<String, Object> params;
        ResourceLocation scriptId = data.getScript();
        CommonAssetsManager commonAssetsManager = CommonAssetsManager.getInstance();
        if (scriptId != null && commonAssetsManager != null) {
            index.script = commonAssetsManager.getScript(scriptId);
            if (index.script == null) {
                GunMod.LOGGER.warn(MARKER, "script '{}' not found", (Object)scriptId);
            }
        }
        if ((params = data.getScriptParam()) != null) {
            index.scriptParam = new LuaTable();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                index.scriptParam.set(entry.getKey(), CoerceJavaToLua.coerce((Object)entry.getValue()));
            }
        }
    }

    public GunData getGunData() {
        return this.gunData;
    }

    public BulletData getBulletData() {
        return this.gunData.getBulletData();
    }

    public String getType() {
        return this.type;
    }

    public GunIndexPOJO getPojo() {
        return this.pojo;
    }

    public LuaTable getScript() {
        return this.script;
    }

    public LuaTable getScriptParam() {
        return this.scriptParam;
    }

    public int getSort() {
        return this.sort;
    }
}

