/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ExplosionModifier
implements IAttachmentModifier<ExplosionModifierValue, ExplosionData> {
    public static final String ID = GunProperties.EXPLOSION.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<ExplosionModifierValue> readJson(String json) {
        Data data = (Data)CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new ExplosionJsonProperty(data.getExplosion());
    }

    @Override
    public CacheValue<ExplosionData> initCache(ItemStack gunItem, GunData gunData) {
        ExplosionData explosionData = gunData.getBulletData().getExplosionData();
        if (explosionData == null) {
            explosionData = new ExplosionData(false, 0.5f, 2.0f, false, 30.0f, false);
        }
        return new CacheValue<ExplosionData>(explosionData);
    }

    @Override
    public void eval(List<ExplosionModifierValue> modifiedValues, CacheValue<ExplosionData> cache) {
        boolean explode;
        ExplosionData cacheValue = cache.getValue();
        ArrayList explodeValues = Lists.newArrayList();
        explodeValues.add(cacheValue.isExplode());
        ArrayList radiusValues = Lists.newArrayList();
        ArrayList damageValues = Lists.newArrayList();
        ArrayList knockbackValues = Lists.newArrayList();
        knockbackValues.add(cacheValue.isKnockback());
        ArrayList destroyBlockValues = Lists.newArrayList();
        destroyBlockValues.add(cacheValue.isDestroyBlock());
        ArrayList delayValues = Lists.newArrayList();
        modifiedValues.forEach(v -> {
            explodeValues.add(v.explode);
            radiusValues.add(v.radius);
            damageValues.add(v.damage);
            knockbackValues.add(v.knockback);
            destroyBlockValues.add(v.destroyBlock);
            delayValues.add(v.delay);
        });
        boolean bl = explode = cacheValue.isExplode() || AttachmentPropertyManager.eval(explodeValues, false);
        if (!explode) {
            return;
        }
        float radius = (float)AttachmentPropertyManager.eval(radiusValues, (double)cacheValue.getRadius());
        float damage = (float)AttachmentPropertyManager.eval(damageValues, (double)cacheValue.getDamage());
        boolean knockback = AttachmentPropertyManager.eval(knockbackValues, false);
        boolean destroyBlock = AttachmentPropertyManager.eval(destroyBlockValues, false);
        float delay = (float)AttachmentPropertyManager.eval(delayValues, (double)cacheValue.getDelay());
        ExplosionData explosionData = new ExplosionData(true, radius, damage, knockback, delay, destroyBlock);
        cache.setValue(explosionData);
    }

    private static class Data {
        @Nullable
        @SerializedName(value="explosion")
        private ExplosionModifierValue explosion = null;

        private Data() {
        }

        @Nullable
        public ExplosionModifierValue getExplosion() {
            return this.explosion;
        }
    }

    public static class ExplosionJsonProperty
    extends JsonProperty<ExplosionModifierValue> {
        public ExplosionJsonProperty(ExplosionModifierValue value) {
            super(value);
        }

        @Override
        public void initComponents() {
            ExplosionModifierValue modifierValue = (ExplosionModifierValue)this.getValue();
            if (modifierValue != null && modifierValue.explode) {
                this.components.add(Component.translatable((String)"tooltip.tacz.attachment.explosion").withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public static class ExplosionModifierValue {
        @SerializedName(value="explode")
        private boolean explode = false;
        @SerializedName(value="radius")
        private Modifier radius = new Modifier();
        @SerializedName(value="damage")
        private Modifier damage = new Modifier();
        @SerializedName(value="knockback")
        private boolean knockback = false;
        @SerializedName(value="destroy_block")
        private boolean destroyBlock = false;
        @SerializedName(value="delay")
        private Modifier delay = new Modifier();

        public boolean isExplode() {
            return this.explode;
        }
    }
}

