/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tacz.guns.compat.optifine.OptifineCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public final class RenderHelper {
    public static void blit(PoseStack poseStack, float x, float y, float uOffset, float vOffset, float pWidth, float height, float textureWidth, float textureHeight) {
        RenderHelper.blit(poseStack, x, y, pWidth, height, uOffset, vOffset, pWidth, height, textureWidth, textureHeight);
    }

    private static void blit(PoseStack poseStack, float x, float y, float pWidth, float height, float uOffset, float vOffset, float uWidth, float vHeight, float textureWidth, float textureHeight) {
        RenderHelper.innerBlit(poseStack, x, x + pWidth, y, y + height, 0.0f, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void innerBlit(PoseStack poseStack, float x1, float x2, float y1, float y2, float blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, float textureWidth, float textureHeight) {
        RenderHelper.innerBlit(poseStack.last().pose(), x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / textureWidth, (uOffset + uWidth) / textureWidth, (vOffset + 0.0f) / textureHeight, (vOffset + vHeight) / textureHeight);
    }

    private static void innerBlit(Matrix4f matrix, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix, x1, y2, blitOffset).setUv(minU, maxV);
        bufferbuilder.addVertex(matrix, x2, y2, blitOffset).setUv(maxU, maxV);
        bufferbuilder.addVertex(matrix, x2, y1, blitOffset).setUv(maxU, minV);
        bufferbuilder.addVertex(matrix, x1, y1, blitOffset).setUv(minU, minV);
        BufferUploader.draw((MeshData)bufferbuilder.buildOrThrow());
    }

    public static void enableItemEntityStencilTest() {
        RenderSystem.assertOnRenderThread();
        if (OptifineCompat.isOptifineInstalled()) {
            int depthTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049);
            int stencilTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36128, (int)36048);
            if (depthTextureId != 0 && stencilTextureId == 0) {
                GL30.glBindTexture((int)3553, (int)depthTextureId);
                int dataType = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)35862);
                if (dataType == 35863) {
                    int width = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                    int height = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                    GlStateManager._texImage2D((int)3553, (int)0, (int)35056, (int)width, (int)height, (int)0, (int)34041, (int)34042, null);
                    GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)depthTextureId, (int)0);
                }
            }
        } else {
            Minecraft.getInstance().getMainRenderTarget().enableStencil();
        }
        GL11.glEnable((int)2960);
    }

    public static void disableItemEntityStencilTest() {
        RenderSystem.assertOnRenderThread();
        GL11.glDisable((int)2960);
    }

    public static void renderFirstPersonArm(LocalPlayer player, HumanoidArm hand, PoseStack matrixStack, int combinedLight) {
        Minecraft mc = Minecraft.getInstance();
        EntityRenderDispatcher renderManager = mc.getEntityRenderDispatcher();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.getRenderer((Entity)player);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        int oldId = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.getSkin().texture());
        if (hand == HumanoidArm.RIGHT) {
            renderer.renderRightHand(matrixStack, (MultiBufferSource)buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            renderer.renderLeftHand(matrixStack, (MultiBufferSource)buffer, combinedLight, (AbstractClientPlayer)player);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldId);
    }
}

