/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaytimeTop
implements TabExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private LuckPermsManager luckPermsManager = null;
    private final int TOP_MAX = 100;
    private final Pattern pagePattern = Pattern.compile("p\\d+");
    private int page;
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public PlaytimeTop() {
        if (this.plugin.isPermissionsManagerConfigured()) {
            try {
                this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("playtime.top")) {
            String noPermMessage = this.config.getString("no-permission");
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + noPermMessage));
            return false;
        }
        if (args.length > 0) {
            if (!this.pagePattern.matcher(args[0]).matches()) {
                String invalidArgMessage = this.config.getString("playtimetop.messages.invalid-argument");
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + invalidArgMessage));
                return false;
            }
            if (!this.getPages().contains(args[0])) {
                String pageNotExistsMessage = this.config.getString("playtimetop.messages.page-not-exists").replace("%PAGE_NUMBER%", args[0].substring(1));
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + pageNotExistsMessage));
                return false;
            }
            this.page = Integer.parseInt(args[0].substring(1));
        } else {
            this.page = 1;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersManager.updateAllOnlineUsersPlaytime().get();
                List<DBUser> topPlayers = this.dbUsersManager.getTopPlayers();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (topPlayers.isEmpty()) {
                        String noPlayersMessage = this.config.getString("playtimetop.messages.no-players");
                        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + noPlayersMessage));
                        return;
                    }
                    int totalUsers = Math.min(100, topPlayers.size());
                    int totalPages = (int)Math.ceil(Float.parseFloat(String.valueOf(totalUsers)) / 10.0f);
                    if (this.page <= 0 || this.page > totalPages) {
                        String invalidPageMessage = this.config.getString("playtimetop.messages.invalid-page");
                        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + invalidPageMessage));
                        return;
                    }
                    String headerFormat = this.config.getString("playtimetop.header");
                    String header = headerFormat.replace("%PAGE_NUMBER%", String.valueOf(this.page));
                    sender.sendMessage(Utils.parseColors(header));
                    int startIndex = (this.page - 1) * 10;
                    int endIndex = Math.min(this.page * 10, totalUsers);
                    CompletableFuture[] messageFutures = new CompletableFuture[endIndex - startIndex];
                    String format = this.config.getString("playtimetop.leaderboard-format");
                    boolean usePrefixes = format.contains("%PREFIX%") && this.plugin.isPermissionsManagerConfigured();
                    for (int i = startIndex; i < endIndex; ++i) {
                        int rank = i + 1;
                        int arrayIndex = i - startIndex;
                        DBUser user = (DBUser)topPlayers.get(i);
                        HashMap<String, String> placeholders = new HashMap<String, String>();
                        if (usePrefixes) {
                            messageFutures[arrayIndex] = this.luckPermsManager.getPrefixAsync(user.getUuid()).thenApply(prefix -> {
                                placeholders.put("%PLAYER_NAME%", user.getNickname());
                                placeholders.put("%PLAYTIME%", String.valueOf(user.getPlaytime()));
                                placeholders.put("%POSITION%", String.valueOf(rank));
                                placeholders.put("%PREFIX%", prefix != null ? prefix : "");
                                String formattedMessage = Utils.placeholdersReplacer(format, placeholders);
                                return Component.empty().append(Utils.parseColors(formattedMessage));
                            });
                            continue;
                        }
                        placeholders.put("%PLAYER_NAME%", user.getNickname());
                        placeholders.put("%PLAYTIME%", String.valueOf(user.getPlaytime()));
                        placeholders.put("%POSITION%", String.valueOf(rank));
                        placeholders.put("%PREFIX%", "");
                        String formattedMessage = Utils.placeholdersReplacer(format, placeholders);
                        messageFutures[arrayIndex] = CompletableFuture.completedFuture(Component.empty().append(Utils.parseColors(formattedMessage)));
                    }
                    CompletableFuture.allOf(messageFutures).thenRun(() -> {
                        for (CompletableFuture future : messageFutures) {
                            sender.sendMessage((Component)future.join());
                        }
                        TextComponent navigationMessage = Component.empty();
                        if (this.page > 1) {
                            String prevPageText = this.config.getString("playtimetop.footer.previous-page.text-if-page-exists");
                            String prevPageHoverText = this.config.getString("playtimetop.footer.previous-page.over-text");
                            Component previousArrow = Utils.parseColors(prevPageText).clickEvent(ClickEvent.runCommand((String)("/playtimetop p" + (this.page - 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors(prevPageHoverText)));
                            navigationMessage = navigationMessage.append(previousArrow);
                        } else {
                            String prevPageNotExistsText = this.config.getString("playtimetop.footer.previous-page.text-if-page-not-exists");
                            navigationMessage = navigationMessage.append(Utils.parseColors(prevPageNotExistsText));
                        }
                        String middleTextFormat = this.config.getString("playtimetop.footer.middle-text");
                        String middleText = middleTextFormat.replace("%PAGE_NUMBER%", String.valueOf(this.page)).replace("%TOTAL_PAGES%", String.valueOf(totalPages));
                        navigationMessage = navigationMessage.append(Utils.parseColors(" " + middleText + " "));
                        if (this.page < totalPages) {
                            String nextPageText = this.config.getString("playtimetop.footer.next-page.text-if-page-exists");
                            String nextPageHoverText = this.config.getString("playtimetop.footer.next-page.over-text");
                            Component nextArrow = Utils.parseColors(nextPageText).clickEvent(ClickEvent.runCommand((String)("/playtimetop p" + (this.page + 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors(nextPageHoverText)));
                            navigationMessage = navigationMessage.append(nextArrow);
                        } else {
                            String nextPageNotExistsText = this.config.getString("playtimetop.footer.next-page.text-if-page-not-exists");
                            navigationMessage = navigationMessage.append(Utils.parseColors(nextPageNotExistsText));
                        }
                        sender.sendMessage((Component)navigationMessage);
                    });
                });
            }
            catch (InterruptedException | ExecutionException e) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String loadingErrorMessage = this.config.getString("playtimetop.messages.loading-error").replace("%ERROR%", e.getMessage());
                    sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " " + loadingErrorMessage));
                });
                this.plugin.getLogger().severe("Error in PlaytimeTop command: " + e.getMessage());
            }
        });
        return true;
    }

    public List<String> getPages() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((double)i < Math.ceil(Float.parseFloat(String.valueOf(100)) / 10.0f)) {
            result.add("p" + (i + 1));
            ++i;
        }
        return result;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length > 0) {
            List<String> pages = this.getPages();
            StringUtil.copyPartialMatches((String)args[0], pages, completions);
            return completions;
        }
        return null;
    }
}

