/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    private static Configuration instance;
    private final PlayTimeManager plugin;
    private final boolean createIfNotExist;
    private final boolean resource;
    private FileConfiguration config;
    private File file;
    private final File path;
    private final String name;
    private final Map<String, Object> configCache = new ConcurrentHashMap<String, Object>();

    private Configuration(PlayTimeManager plugin, File path, String name, boolean createIfNotExist, boolean resource) {
        this.plugin = plugin;
        this.path = path;
        this.name = name + ".yml";
        this.createIfNotExist = createIfNotExist;
        this.resource = resource;
        this.create();
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance(PlayTimeManager plugin, File path, String name, boolean createIfNotExist, boolean resource) {
        if (instance != null) return instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (instance != null) return instance;
            instance = new Configuration(plugin, path, name, createIfNotExist, resource);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static Configuration getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Configuration must be initialized first with getInstance(File, String, boolean, boolean)");
        }
        return instance;
    }

    private void create() {
        if (this.file == null) {
            this.reloadFile();
        }
        if (!this.createIfNotExist || this.file.exists()) {
            return;
        }
        this.file.getParentFile().mkdirs();
        if (this.resource) {
            this.plugin.saveResource(this.name, false);
        } else {
            try {
                this.file.createNewFile();
            }
            catch (Exception exc) {
                this.plugin.getLogger().severe(String.valueOf(exc));
            }
        }
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exc) {
            this.plugin.getLogger().severe(String.valueOf(exc));
        }
    }

    private void reloadFile() {
        this.file = new File(this.path, this.name);
    }

    private void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void loadCache() {
        if (this.config == null) {
            this.plugin.getLogger().warning("Config is null, cannot load cache");
            return;
        }
        this.configCache.clear();
        for (String key : this.config.getKeys(true)) {
            Object value = this.config.get(key);
            this.configCache.put(key, value);
        }
    }

    public void reload() {
        this.reloadFile();
        this.reloadConfig();
        this.loadCache();
    }

    public Object get(String path) {
        if (this.configCache.containsKey(path)) {
            return this.configCache.get(path);
        }
        Object value = this.config.get(path);
        if (value != null) {
            this.configCache.put(path, value);
        }
        return value;
    }

    public Object get(String path, Object defaultValue) {
        Object value = this.get(path);
        return value != null ? value : defaultValue;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.configCache.put(path, value);
        this.save();
    }

    public List<String> getStringList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        return new ArrayList<String>();
    }

    public String getString(String path) {
        Object value = this.get(path);
        return value != null ? value.toString() : null;
    }

    public Integer getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public Long getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return null;
    }

    public Boolean getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public Double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public void clearCache() {
        this.configCache.clear();
    }

    public Map<String, Object> createConfigBackup() {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        Set keys = this.config.getKeys(true);
        for (String key : keys) {
            Object value = this.config.get(key);
            if (value == null) continue;
            backup.put(key, value);
        }
        return backup;
    }

    public void restoreFromBackup(Map<String, Object> backup) {
        if (backup == null || backup.isEmpty()) {
            this.plugin.getLogger().warning("Backup is null or empty, nothing to restore");
            return;
        }
        for (Map.Entry<String, Object> entry : backup.entrySet()) {
            String key = entry.getKey();
            Object backupValue = entry.getValue();
            if (!this.config.contains(key) || key.equals("config-version") || backupValue instanceof MemorySection) continue;
            Object currentValue = this.config.get(key);
            if (backupValue == null || backupValue.equals(currentValue) || backupValue instanceof String && ((String)backupValue).trim().isEmpty()) continue;
            this.config.set(key, backupValue);
        }
    }

    public void updateConfig(boolean restoreRemovedKeys) {
        try {
            this.fixNullLists();
            Map<String, Object> backup = this.createConfigBackup();
            if (this.file.exists()) {
                this.file.delete();
            }
            this.plugin.saveResource(this.name, true);
            this.reloadFile();
            this.reloadConfig();
            this.configCache.clear();
            this.restoreFromBackup(backup);
            if (restoreRemovedKeys) {
                this.restoreRemovedKeys(backup);
            }
            this.set("config-version", this.plugin.CURRENT_CONFIG_VERSION);
            this.loadCache();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void restoreRemovedKeys(Map<String, Object> backup) {
        if (backup == null || backup.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : backup.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (this.config.contains(key) || key.equals("config-version")) continue;
            this.config.set(key, value);
            this.configCache.put(key, value);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void fixNullLists() {
        this.fixEmptyPlayersHiddenFromLeaderBoard();
    }

    private void fixEmptyPlayersHiddenFromLeaderBoard() {
        if (this.getStringList("placeholders.playtime-leaderboard-blacklist") == null) {
            this.set("placeholders.playtime-leaderboard-blacklist", new ArrayList());
        }
    }
}

