/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Customizations;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUIsConfiguration {
    private static GUIsConfiguration instance;
    private PlayTimeManager plugin;
    private FileConfiguration config;
    private File file;
    private final Map<String, Object> configCache = new ConcurrentHashMap<String, Object>();
    private static final String CONFIG_FILENAME = "GUIs-config.yml";
    private static final String CONFIG_PATH = "Customizations/GUIs/";

    private GUIsConfiguration() {
    }

    public static synchronized GUIsConfiguration getInstance() {
        if (instance == null) {
            instance = new GUIsConfiguration();
        }
        return instance;
    }

    public void initialize(PlayTimeManager plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
            this.create();
            this.reload();
        }
    }

    private void create() {
        if (this.file == null) {
            this.reloadFile();
        }
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource("Customizations/GUIs/GUIs-config.yml", false);
        }
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exc) {
            this.plugin.getLogger().severe(String.valueOf(exc));
        }
    }

    private void reloadFile() {
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin not initialized. Call initialize() first.");
        }
        this.file = new File(this.plugin.getDataFolder(), "Customizations/GUIs/GUIs-config.yml");
    }

    private void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void loadCache() {
        if (this.config == null) {
            this.plugin.getLogger().warning("Config is null, cannot load cache");
            return;
        }
        this.configCache.clear();
        for (String key : this.config.getKeys(true)) {
            Object value = this.config.get(key);
            this.configCache.put(key, value);
        }
    }

    public void reload() {
        this.reloadFile();
        this.reloadConfig();
        this.loadCache();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public Object get(String path) {
        if (this.configCache.containsKey(path)) {
            return this.configCache.get(path);
        }
        Object value = this.config.get(path);
        if (value != null) {
            this.configCache.put(path, value);
        }
        return value;
    }

    public boolean contains(String path) {
        if (this.configCache.containsKey(path)) {
            return true;
        }
        return this.config != null && this.config.contains(path);
    }

    public Object get(String path, Object def) {
        if (this.configCache.containsKey(path)) {
            return this.configCache.get(path);
        }
        Object value = this.config.get(path, def);
        if (value != null) {
            this.configCache.put(path, value);
        }
        return value;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.configCache.put(path, value);
        this.save();
    }

    public Object getOrDefault(String path, Object defaultValue) {
        Object value;
        if (this.configCache.containsKey(path)) {
            return this.configCache.get(path);
        }
        if (this.config.contains(path) && (value = this.config.get(path)) != null) {
            this.configCache.put(path, value);
            return value;
        }
        this.set(path, defaultValue);
        return defaultValue;
    }

    public String getOrDefaultString(String path, String defaultValue) {
        Object value = this.getOrDefault(path, defaultValue);
        return value != null ? value.toString() : defaultValue;
    }

    public Integer getOrDefaultInt(String path, Integer defaultValue) {
        Object value = this.getOrDefault(path, defaultValue);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public Boolean getOrDefaultBoolean(String path, Boolean defaultValue) {
        Object value = this.getOrDefault(path, defaultValue);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public Double getOrDefaultDouble(String path, Double defaultValue) {
        Object value = this.getOrDefault(path, defaultValue);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    public List<String> getOrDefaultStringList(String path, List<String> defaultValue) {
        Object value = this.getOrDefault(path, defaultValue);
        if (value instanceof List) {
            return (List)value;
        }
        return defaultValue;
    }

    public Map<String, Object> createConfigBackup() {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        Set keys = this.config.getKeys(true);
        for (String key : keys) {
            Object value = this.config.get(key);
            if (value == null) continue;
            backup.put(key, value);
        }
        return backup;
    }

    public void restoreFromBackup(Map<String, Object> backup) {
        if (backup == null || backup.isEmpty()) {
            this.plugin.getLogger().warning("Backup is null or empty, nothing to restore");
            return;
        }
        for (Map.Entry<String, Object> entry : backup.entrySet()) {
            String key = entry.getKey();
            Object backupValue = entry.getValue();
            if (!this.config.contains(key) || backupValue instanceof MemorySection) continue;
            Object currentValue = this.config.get(key);
            if (backupValue == null || backupValue.equals(currentValue) || backupValue instanceof String && ((String)backupValue).trim().isEmpty()) continue;
            this.config.set(key, backupValue);
            this.configCache.put(key, backupValue);
        }
    }

    public void updateConfig() {
        try {
            Map<Object, Object> backup = new HashMap();
            if (this.config != null) {
                backup = this.createConfigBackup();
            }
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
            this.plugin.saveResource("Customizations/GUIs/GUIs-config.yml", true);
            this.configCache.clear();
            this.reloadFile();
            this.reloadConfig();
            if (!backup.isEmpty()) {
                this.restoreFromBackup(backup);
            }
            this.save();
            this.loadCache();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ConfigurationSection getConfigurationSection(String path) {
        if (this.config == null) {
            return null;
        }
        return this.config.getConfigurationSection(path);
    }

    public List<String> getStringList(String path) {
        Object value = this.get(path);
        if (value instanceof List) {
            List list = (List)value;
            return list;
        }
        return null;
    }

    public String getString(String path) {
        Object value = this.get(path);
        return value != null ? value.toString() : null;
    }

    public Integer getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public Boolean getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public Double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public void clearCache() {
        this.configCache.clear();
    }
}

