/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Customizations.PlaytimeFormats;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormat;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlaytimeFormatsConfiguration {
    private static PlaytimeFormatsConfiguration instance;
    private PlayTimeManager plugin;
    private static final String CONFIG_PATH = "Customizations/PlaytimeFormats/";
    public ArrayList<PlaytimeFormat> playtimeFormats = new ArrayList();

    private PlaytimeFormatsConfiguration() {
    }

    public static synchronized PlaytimeFormatsConfiguration getInstance() {
        if (instance == null) {
            instance = new PlaytimeFormatsConfiguration();
        }
        return instance;
    }

    public void initialize(PlayTimeManager plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
            this.loadAllFormats();
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    private void loadAllFormats() {
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin not initialized. Call initialize() first.");
        }
        this.playtimeFormats.clear();
        File formatsDirectory = new File(this.plugin.getDataFolder(), CONFIG_PATH);
        if (!formatsDirectory.exists()) {
            formatsDirectory.mkdirs();
        }
        try {
            this.plugin.saveResource("Customizations/PlaytimeFormats/default.yml", true);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to save default playtime format: " + e.getMessage());
        }
        File[] files = formatsDirectory.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files == null || files.length == 0) {
            this.plugin.getLogger().info("No playtime format files found in Customizations/PlaytimeFormats/");
            return;
        }
        for (File file : files) {
            try {
                this.loadFormatFromFile(file);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load playtime format from file: " + file.getName() + " - " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded " + this.playtimeFormats.size() + " playtime format(s)");
    }

    private void loadFormatFromFile(File file) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String formatName = file.getName().replace(".yml", "");
        String yearsSingular = config.getString("years-singular", "y");
        String yearsPlural = config.getString("years-plural", "y");
        String daysSingular = config.getString("days-singular", "d");
        String daysPlural = config.getString("days-plural", "d");
        String hoursSingular = config.getString("hours-singular", "h");
        String hoursPlural = config.getString("hours-plural", "h");
        String minutesSingular = config.getString("minutes-singular", "m");
        String minutesPlural = config.getString("minutes-plural", "m");
        String secondsSingular = config.getString("seconds-singular", "s");
        String secondsPlural = config.getString("seconds-plural", "s");
        String formatting = config.getString("formatting", "%y%{years}, %d%{days}, %h%{hours}, %m%{minutes}, %s%{seconds}");
        boolean distributeRemovedTime = config.getBoolean("distribute-removed-time", false);
        PlaytimeFormat format = new PlaytimeFormat(file, formatName, yearsSingular, yearsPlural, daysSingular, daysPlural, hoursSingular, hoursPlural, minutesSingular, minutesPlural, secondsSingular, secondsPlural, formatting, distributeRemovedTime);
        this.playtimeFormats.add(format);
    }

    public void reload() {
        this.loadAllFormats();
    }

    public PlaytimeFormat getFormat(String name) {
        for (PlaytimeFormat format : this.playtimeFormats) {
            if (!format.getName().equalsIgnoreCase(name)) continue;
            return format;
        }
        return null;
    }

    public void formatsUpdater(Map<String, Object> newFields) {
        HashSet<PlaytimeFormat> formatsClone = new HashSet<PlaytimeFormat>(this.playtimeFormats);
        this.playtimeFormats.clear();
        for (PlaytimeFormat f : formatsClone) {
            File configFile = f.getFormatFile();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            for (Map.Entry<String, Object> entry : newFields.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                config.set(key, value);
            }
            try {
                config.save(configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadAllFormats();
    }
}

