/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Database;

import java.sql.Connection;
import java.sql.SQLException;
import me.thegabro.playtimemanager.Database.DAOs.GoalsDAO;
import me.thegabro.playtimemanager.Database.DAOs.JoinstreakDAO;
import me.thegabro.playtimemanager.Database.DAOs.PlayerDAO;
import me.thegabro.playtimemanager.Database.DAOs.StatisticsDAO;
import me.thegabro.playtimemanager.Database.Database;
import me.thegabro.playtimemanager.Database.DatabaseFactory;

public class DatabaseHandler {
    private static DatabaseHandler instance;
    private final Database database = DatabaseFactory.createDatabase();
    private final PlayerDAO playerDAO = new PlayerDAO(this);
    private final GoalsDAO goalsDAO = new GoalsDAO(this);
    private final JoinstreakDAO streakDAO = new JoinstreakDAO(this);
    private final StatisticsDAO statisticsDAO = new StatisticsDAO(this);

    public static synchronized DatabaseHandler getInstance() {
        if (instance == null) {
            instance = new DatabaseHandler();
        }
        return instance;
    }

    private DatabaseHandler() {
    }

    public Connection getConnection() throws SQLException {
        return this.database.getConnection();
    }

    public void close() {
        this.database.close();
    }

    public PlayerDAO getPlayerDAO() {
        return this.playerDAO;
    }

    public GoalsDAO getGoalsDAO() {
        return this.goalsDAO;
    }

    public JoinstreakDAO getStreakDAO() {
        return this.streakDAO;
    }

    public StatisticsDAO getStatisticsDAO() {
        return this.statisticsDAO;
    }

    public String getDatabaseType() {
        return this.database.getDatabaseType();
    }
}

