/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport.EssentialsX;

import me.thegabro.playtimemanager.ExternalPluginSupport.AFKSyncManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import net.ess3.api.IUser;
import net.ess3.api.events.AfkStatusChangeEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class EssentialsAFKHook
implements Listener {
    private static EssentialsAFKHook instance;
    private final AFKSyncManager afkSyncManager = AFKSyncManager.getInstance();

    private EssentialsAFKHook() {
    }

    public static EssentialsAFKHook getInstance() {
        if (instance == null) {
            instance = new EssentialsAFKHook();
        }
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onAfkStatusChange(AfkStatusChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        IUser user = event.getAffected();
        Player player = user.getBase();
        if (player == null) {
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        boolean isNowAFK = event.getValue();
        String playerUUID = player.getUniqueId().toString();
        OnlineUser onlineUser = OnlineUsersManager.getInstance().getOnlineUserByUUID(playerUUID);
        if (onlineUser == null) {
            return;
        }
        if (isNowAFK) {
            this.afkSyncManager.handleAFKGo(onlineUser);
        } else {
            this.afkSyncManager.handleAFKReturn(onlineUser);
        }
    }
}

