/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import me.thegabro.playtimemanager.GUIs.CustomGUI;
import me.thegabro.playtimemanager.GUIs.InventoryListener;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public abstract class BaseCustomGUI
implements CustomGUI {
    protected final PlayTimeManager plugin = PlayTimeManager.getInstance();
    protected final Player sender;
    protected final String sessionToken;
    protected Inventory inv;

    public BaseCustomGUI(Player sender, String sessionToken) {
        this.sender = sender;
        this.sessionToken = sessionToken;
    }

    public void openInventory() {
        InventoryListener.getInstance().registerGUI(this.sender.getUniqueId(), this);
        this.sender.openInventory(this.inv);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public boolean isOwner(Player player) {
        return player.getUniqueId().equals(this.sender.getUniqueId());
    }

    public Inventory getInventory() {
        return this.inv;
    }

    protected boolean validateSession() {
        return this.plugin.getSessionManager().validateSession(this.sender.getUniqueId(), this.sessionToken);
    }

    protected void handleInvalidSession() {
        this.plugin.getLogger().warning("Player " + this.sender.getName() + " attempted GUI action with invalid session token!");
        this.sender.closeInventory();
    }
}

