/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Goals;

import java.util.ArrayList;
import java.util.List;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders.PlaceholderConditionEvaluator;
import me.thegabro.playtimemanager.GUIs.Goals.GoalSettingsGui;
import me.thegabro.playtimemanager.GUIs.Misc.ConfirmationGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GoalRequirementsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 54;
    private static final int ITEMS_PER_PAGE = 45;
    private Inventory inventory;
    private Goal goal;
    private GoalSettingsGui parentGui;
    private int currentPage;
    private final ChatEventManager chatEventManager = ChatEventManager.getInstance();
    private final PlaceholderConditionEvaluator placeholderConditionEvaluator = PlaceholderConditionEvaluator.getInstance();

    public GoalRequirementsGui() {
    }

    public GoalRequirementsGui(Goal goal, GoalSettingsGui parentGui) {
        this.goal = goal;
        this.parentGui = parentGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors("&6Requirements Editor"));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    private void initializeItems() {
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        this.updateRequirementsPage();
        this.addControlButtons();
    }

    private ItemStack createBackgroundItem() {
        return this.parentGui.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors("&f"), new Component[0]);
    }

    private void updateRequirementsPage() {
        List<String> permissions = this.goal.getRequirements().getPermissions();
        List<String> placeholders = this.goal.getRequirements().getPlaceholderConditions();
        ArrayList<String> combined = new ArrayList<String>();
        combined.addAll(permissions);
        combined.addAll(placeholders);
        for (int i = 0; i < 45; ++i) {
            boolean isPermission;
            int index = this.currentPage * 45 + i;
            if (index >= combined.size()) {
                this.inventory.setItem(i, this.createBackgroundItem());
                continue;
            }
            String item = (String)combined.get(index);
            boolean bl = isPermission = index < permissions.size();
            Material icon = isPermission ? (item.startsWith("group.") ? Material.BOOK : Material.NAME_TAG) : Material.ARMOR_STAND;
            ArrayList<Component> lore = new ArrayList<Component>(List.of(Utils.parseColors("&7Click to edit"), Utils.parseColors("&cShift-Right Click to remove")));
            if (isPermission && item.startsWith("group.")) {
                boolean exists;
                String group = item.substring(6);
                boolean bl2 = exists = PlayTimeManager.getInstance().isPermissionsManagerConfigured() && PlayTimeManager.getInstance().getLuckPermsApi() != null && LuckPermsManager.getInstance(PlayTimeManager.getInstance()).groupExists(group);
                if (!exists) {
                    lore.addAll(List.of(Utils.parseColors(""), Utils.parseColors("&c\u26a0 Group '" + group + "' does not exist!"), Utils.parseColors("&cCheck LuckPerms or remove this.")));
                }
            }
            this.inventory.setItem(i, this.parentGui.createGuiItem(icon, Utils.parseColors((isPermission ? "&e" : "&b") + item), (Component[])lore.toArray(Component[]::new)));
        }
        this.addControlButtons();
    }

    private void addControlButtons() {
        int total;
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.parentGui.createGuiItem(Material.ARROW, Utils.parseColors("&ePrevious Page"), new Component[0]));
        }
        if ((this.currentPage + 1) * 45 < (total = this.goal.getRequirements().getPermissions().size() + this.goal.getRequirements().getPlaceholderConditions().size())) {
            this.inventory.setItem(53, this.parentGui.createGuiItem(Material.ARROW, Utils.parseColors("&eNext Page"), new Component[0]));
        }
        this.inventory.setItem(46, this.parentGui.createGuiItem(Material.CLOCK, Utils.parseColors("&6&lRequired Time: &r" + (String)(this.goal.getRequirements().getTime() == Long.MAX_VALUE ? "&e-" : "&e" + Utils.ticksToFormattedPlaytime(this.goal.getRequirements().getTime()))), new Component[]{Component.text((String)"\u00a77Click to modify the required playtime")}));
        this.inventory.setItem(47, this.parentGui.createGuiItem(Material.CLOCK, Utils.parseColors("&e&lC"), Utils.parseColors("&7Click to add a new permission/group requirement")));
        this.inventory.setItem(47, this.parentGui.createGuiItem(Material.NAME_TAG, Utils.parseColors("&e&lAdd Permission"), Utils.parseColors("&7Click to add a new permission/group requirement")));
        if (PlayTimeManager.getInstance().isPlaceholdersAPIConfigured()) {
            this.inventory.setItem(48, this.parentGui.createGuiItem(Material.ARMOR_STAND, Utils.parseColors("&b&lAdd Placeholder condition"), Utils.parseColors("&7Click to add a new placeholder condition")));
        } else {
            this.inventory.setItem(48, this.parentGui.createGuiItem(Material.ARMOR_STAND, Utils.parseColors("&c&lAdd Placeholder condition"), new Component[]{Utils.parseColors("&7Click to add a new placeholder condition"), Component.text((String)""), Utils.parseColors("&c\u26a0 PlaceholderAPI is not loaded!"), Utils.parseColors("&cThis feature requires PlaceholderAPI to work.")}));
        }
        this.inventory.setItem(50, this.parentGui.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Utils.parseColors("&6&lBack"), new Component[0]));
        this.inventory.setItem(51, this.parentGui.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete All"), Utils.parseColors("&7Removes all requirements")));
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, InventoryAction action, InventoryClickEvent event) {
        if (clickedItem == null || clickedItem.getType() == Material.AIR || clickedItem.getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 45: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.updateRequirementsPage();
                break;
            }
            case 53: {
                int total = this.goal.getRequirements().getPermissions().size() + this.goal.getRequirements().getPlaceholderConditions().size();
                if ((this.currentPage + 1) * 45 >= total) break;
                ++this.currentPage;
                this.updateRequirementsPage();
                break;
            }
            case 46: {
                this.openTimeEditor(whoClicked);
                break;
            }
            case 47: {
                this.openAddPermissionDialog(whoClicked);
                break;
            }
            case 48: {
                if (PlayTimeManager.getInstance().isPlaceholdersAPIConfigured()) {
                    this.openAddPlaceholderDialog(whoClicked);
                    break;
                }
                whoClicked.sendMessage(Utils.parseColors("&cPlaceholderAPI is not loaded! This feature requires PlaceholderAPI to work."));
                break;
            }
            case 50: {
                whoClicked.closeInventory();
                this.parentGui.openInventory(whoClicked);
                break;
            }
            case 51: {
                this.handleDeleteAll(whoClicked);
                break;
            }
            default: {
                boolean isPermission;
                if (slot >= 45 || clickedItem.getItemMeta() == null) break;
                String display = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName());
                int index = this.currentPage * 45 + slot;
                boolean bl = isPermission = index < this.goal.getRequirements().getPermissions().size();
                if (event.isShiftClick() && event.isRightClick()) {
                    if (isPermission) {
                        this.goal.removeRequirementPermission(display);
                    } else {
                        this.goal.removePlaceholderCondition(display);
                    }
                    this.updateRequirementsPage();
                    break;
                }
                if (event.getClick().isCreativeAction()) break;
                whoClicked.closeInventory();
                if (isPermission) {
                    this.openEditPermissionDialog(whoClicked, display);
                    break;
                }
                this.openEditPlaceholderDialog(whoClicked, display);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (inventoryHolder instanceof GoalRequirementsGui) {
            GoalRequirementsGui gui = (GoalRequirementsGui)inventoryHolder;
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction(), e);
            } else if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                e.setCancelled(true);
            }
        }
    }

    private void openTimeEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Time Editor: &e" + this.goal.getName());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the new time requirement for this goal.\n&7\u2022 Format: &e1y,2d,3h,4m,5s\n&7\u2022 Current value: &e" + (this.goal.getRequirements().getTime() != Long.MAX_VALUE ? Utils.ticksToFormattedPlaytime(this.goal.getRequirements().getTime()) : "-") + "\n&7\u2022 Type &d&onone&r&7 to remove this requirement\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    if (message.equalsIgnoreCase("none")) {
                        this.goal.setTime(Long.MAX_VALUE);
                        player.sendMessage(Utils.parseColors("&aGoal time requirement has been removed!"));
                    } else {
                        long time = Utils.formattedPlaytimeToTicks(message);
                        if (time != -1L) {
                            this.goal.setTime(time);
                            player.sendMessage(Utils.parseColors("&aGoal time requirement updated successfully!"));
                        } else {
                            player.sendMessage(Utils.parseColors("&cInvalid time format! Please use format: 1y,2d,3h,4m,5s"));
                        }
                    }
                } else {
                    player.sendMessage(Utils.parseColors("&cInvalid time format! Please use format: 1y,2d,3h,4m,5s"));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cGoal time edit cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openAddPermissionDialog(Player player) {
        Component header = Utils.parseColors("&e&l\u2795 Add Permission");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a new permission node:\n&7\u2022 Standard permission or 'group.groupname'\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    this.goal.addRequirementPermission((String)message);
                    player.sendMessage(Utils.parseColors("&aPermission added: &f" + message));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cPermission addition cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openAddPlaceholderDialog(Player player) {
        Component header = Utils.parseColors("&b&l\u2795 Add Placeholder");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a new placeholder condition:\n&7\u2022 Must be a boolean expression\n&7\u2022 Only expressions with 2 operands are accepted\n&7\u2022 Available custom placeholder: PLAYER_NAME\n&7\u2022 Examples:\n&7  \u2022 &f%PTM_joinstreak% >= 2\n&7  \u2022 &f%PTM_nickname_top_1% == PLAYER_NAME\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    if (this.placeholderConditionEvaluator.isValid(player, (String)message)) {
                        this.goal.addPlaceholderCondition((String)message);
                        player.sendMessage(Utils.parseColors("&aPlaceholder condition added: &f" + message));
                    } else {
                        player.sendMessage(Utils.parseColors("&cThis placeholder condition is not valid"));
                    }
                }
            } else {
                player.sendMessage(Utils.parseColors("&cPlaceholder addition cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openEditPermissionDialog(Player player, String oldPermission) {
        Component header = Utils.parseColors("&6&l\u270e Edit Permission");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fCurrent Permission: &7" + oldPermission + "\n&7Enter a new permission node:\n&7\u2022 Type the new permission\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    this.goal.removeRequirementPermission(oldPermission);
                    this.goal.addRequirementPermission((String)message);
                }
                player.sendMessage(Utils.parseColors("&aPermission updated from &f" + oldPermission + " &ato &f" + message));
            } else {
                player.sendMessage(Utils.parseColors("&cPermission edit cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openEditPlaceholderDialog(Player player, String oldPlaceholder) {
        Component header = Utils.parseColors("&6&l\u270e Edit Placeholder");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fCurrent Placeholder: &7" + oldPlaceholder + "\n&7Enter a new placeholder condition:\n&7\u2022 Must be a boolean expression \n&7\u2022 Only expressions with 2 operands are accepted\n&7\u2022 Available custom placeholder: PLAYER_NAME\n&7\u2022 Examples:\n&7  \u2022 &f%PTM_joinstreak% >= 2\n&7  \u2022 &f%PTM_nickname_top_1% == PLAYER_NAME\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    if (this.placeholderConditionEvaluator.isValid(player, (String)message)) {
                        this.goal.removePlaceholderCondition(oldPlaceholder);
                        this.goal.addPlaceholderCondition((String)message);
                        player.sendMessage(Utils.parseColors("&aPlaceholder updated from &f" + oldPlaceholder + " &ato &f" + message));
                    } else {
                        player.sendMessage(Utils.parseColors("&cThis placeholder condition is not valid"));
                    }
                }
            } else {
                player.sendMessage(Utils.parseColors("&cPlaceholder edit cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void handleDeleteAll(Player player) {
        ItemStack warning = this.parentGui.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete All Requirements"), Utils.parseColors("&7Removes all permissions and placeholders"));
        new ConfirmationGui(warning, confirmed -> {
            if (confirmed.booleanValue()) {
                this.goal.clearPlaceholderConditions();
                this.goal.clearRequirementPermissions();
                this.goal.setTime(Long.MAX_VALUE);
            }
            player.closeInventory();
            this.openInventory(player);
        }).openInventory(player);
    }

    private static final class Slots {
        static final int PREV_PAGE = 45;
        static final int TIME_SETTING = 46;
        static final int NEXT_PAGE = 53;
        static final int ADD_PERMISSION = 47;
        static final int ADD_PLACEHOLDER = 48;
        static final int BACK = 50;
        static final int DELETE_ALL = 51;

        private Slots() {
        }
    }
}

