/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.thegabro.playtimemanager.GUIs.CustomGUI;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private static InventoryListener instance;
    private static boolean isRegistered;
    private final Map<UUID, CustomGUI> activeGuis = new HashMap<UUID, CustomGUI>();

    private InventoryListener() {
    }

    public static InventoryListener getInstance() {
        if (instance == null) {
            instance = new InventoryListener();
        }
        if (!isRegistered) {
            Bukkit.getPluginManager().registerEvents((Listener)instance, (Plugin)PlayTimeManager.getInstance());
            isRegistered = true;
        }
        return instance;
    }

    public void registerGUI(UUID playerUuid, CustomGUI gui) {
        this.activeGuis.put(playerUuid, gui);
    }

    public void unregisterGUI(UUID playerUuid) {
        this.activeGuis.remove(playerUuid);
    }

    public boolean hasActiveGUI(UUID playerUuid) {
        return this.activeGuis.containsKey(playerUuid);
    }

    public CustomGUI getActiveGUI(UUID playerUuid) {
        return this.activeGuis.get(playerUuid);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity;
        InventoryHolder holder = e.getInventory().getHolder();
        if (holder instanceof CustomGUI && (humanEntity = e.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            e.setCancelled(true);
            CustomGUI gui = this.activeGuis.get(player.getUniqueId());
            if (gui != null && gui == holder) {
                gui.onGUIClick(player, e.getRawSlot(), e.getCurrentItem(), e.getAction(), e);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        UUID playerId;
        CustomGUI gui;
        HumanEntity humanEntity;
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof CustomGUI && (humanEntity = event.getPlayer()) instanceof Player && (gui = this.activeGuis.get(playerId = (player = (Player)humanEntity).getUniqueId())) != null && gui == holder) {
            gui.onGUIClose(player);
            this.unregisterGUI(playerId);
            PlayTimeManager.getInstance().getSessionManager().endSession(playerId);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        CustomGUI gui = this.activeGuis.get(playerId);
        if (gui != null) {
            gui.onPlayerQuit(event.getPlayer());
            this.unregisterGUI(playerId);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent e) {
        if (e.getInventory().getHolder() instanceof CustomGUI) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        if (this.hasActiveGUI(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSwap(PlayerSwapHandItemsEvent e) {
        Player player = e.getPlayer();
        if (this.hasActiveGUI(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent e) {
        if (e.getPlugin().equals((Object)PlayTimeManager.getInstance())) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof CustomGUI)) continue;
                player.closeInventory();
            }
            this.activeGuis.clear();
        }
    }

    static {
        isRegistered = false;
    }
}

