/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.Goals.GoalRewardRequirement;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import me.thegabro.playtimemanager.libs.cronutils.descriptor.CronDescriptor;
import me.thegabro.playtimemanager.libs.cronutils.model.Cron;
import me.thegabro.playtimemanager.libs.cronutils.model.CronType;
import me.thegabro.playtimemanager.libs.cronutils.model.definition.CronDefinitionBuilder;
import me.thegabro.playtimemanager.libs.cronutils.parser.CronParser;
import me.thegabro.playtimemanager.libs.quartz.CronExpression;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Goal {
    private final PlayTimeManager plugin;
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private String name;
    private final File goalFile;
    private final GoalRewardRequirement requirements;
    private ArrayList<String> rewardPermissions = new ArrayList();
    private ArrayList<String> rewardCommands = new ArrayList();
    private String goalMessage;
    private String goalSound;
    private boolean active;
    private boolean isRepeatable;
    private String completionCheckInterval;
    private String checkTimeTimezone;
    private boolean verbose;
    private CronExpression cronExpression;
    private String checkTimeToText;
    private TimeZone timezone;
    private final DatabaseHandler db = DatabaseHandler.getInstance();
    private BukkitTask completionCheckTask;
    private Date nextIntervalCheckCron;
    private final Map<String, String> goalMessageReplacements;
    private Date nextIntervalCheck;
    private boolean offlineRewards;
    private boolean useCronExpression = true;
    private long intervalSeconds = 900L;

    public Goal(PlayTimeManager plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.goalFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Goals" + File.separator + name + ".yml");
        this.requirements = new GoalRewardRequirement();
        this.goalMessageReplacements = new HashMap<String, String>();
        this.loadFromFile();
        this.validateConfiguration();
    }

    public Goal(PlayTimeManager plugin, String name, boolean active) {
        this.plugin = plugin;
        this.name = name;
        this.goalFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Goals" + File.separator + name + ".yml");
        this.requirements = new GoalRewardRequirement();
        this.goalMessageReplacements = new HashMap<String, String>();
        this.active = active;
        this.loadFromFile();
        this.validateConfiguration();
        this.saveToFile();
    }

    public void loadPlayersJoinedDuringTimeWindow(Consumer<List<DBUser>> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block5: {
                try {
                    Instant since;
                    if (this.useCronExpression) {
                        Date now = new Date();
                        Date firstTrigger = this.cronExpression.getNextValidTimeAfter(now);
                        Date secondTrigger = this.cronExpression.getNextValidTimeAfter(firstTrigger);
                        long intervalMillis = secondTrigger.getTime() - firstTrigger.getTime();
                        long exactIntervalSeconds = intervalMillis / 1000L;
                        since = Instant.now().minusSeconds(exactIntervalSeconds);
                    } else {
                        since = Instant.now().minusSeconds(this.intervalSeconds);
                    }
                    ArrayList<String> playersUuids = this.db.getPlayerDAO().getPlayersSeenSince(since);
                    ArrayList<DBUser> loadedUsers = new ArrayList<DBUser>();
                    for (String uuid : playersUuids) {
                        DBUser user = this.dbUsersManager.getUserFromUUIDSync(uuid);
                        if (user == null || user.isOnline()) continue;
                        loadedUsers.add(user);
                    }
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        if (callback != null) {
                            callback.accept(Collections.unmodifiableList(loadedUsers));
                        }
                    });
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Error while loading players joined during time window: " + e.getMessage());
                    e.printStackTrace();
                    if (callback == null) break block5;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(Collections.emptyList()));
                }
            }
        });
    }

    private void validateConfiguration() {
        try {
            this.parseCheckTimeInterval(this.completionCheckInterval);
            this.timezone = "utc".equalsIgnoreCase(this.checkTimeTimezone) ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
            if (this.useCronExpression && this.cronExpression != null) {
                this.cronExpression.setTimeZone(this.timezone);
            }
            this.saveToFile();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Invalid check-time-interval configuration in goal " + this.name + "! Setting the goal as inactive: " + e.getMessage());
            this.setActivation(false);
        }
    }

    private void parseCheckTimeInterval(String interval) throws Exception {
        if (interval == null || interval.trim().isEmpty()) {
            interval = "900";
        }
        try {
            long seconds = Long.parseLong(interval.trim());
            if (seconds <= 0L) {
                throw new IllegalArgumentException("Interval in seconds must be positive");
            }
            this.intervalSeconds = seconds;
            this.useCronExpression = false;
            this.cronExpression = null;
        }
        catch (NumberFormatException e) {
            this.cronExpression = new CronExpression(interval);
            this.useCronExpression = true;
        }
        this.translateCheckTimeToText();
        if (this.verbose) {
            if (this.active) {
                this.plugin.getLogger().info("Goal " + this.name + " completion check will occur " + this.checkTimeToText);
            } else {
                this.plugin.getLogger().info("Goal " + this.name + " completion set to occur " + this.checkTimeToText + " when the goal will be reactivated");
            }
        }
    }

    protected void loadFromFile() {
        if (this.goalFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.goalFile);
            this.requirements.setTime(config.getLong("requirements.time", Long.MAX_VALUE));
            this.requirements.setPermissions(new ArrayList<String>(config.getStringList("requirements.permissions")));
            this.requirements.setPlaceholderConditions(new ArrayList<String>(config.getStringList("requirements.placeholders")));
            this.goalMessage = config.getString("goal-message", this.getDefaultGoalMessage());
            this.goalSound = config.getString("goal-sound", this.getDefaultGoalSound());
            this.rewardPermissions = new ArrayList(config.getStringList("rewards.permissions"));
            this.rewardCommands = new ArrayList(config.getStringList("rewards.commands"));
            this.active = config.getBoolean("active", false);
            this.isRepeatable = config.getBoolean("repeatable", false);
            this.offlineRewards = config.getBoolean("offline-rewards", false);
            this.completionCheckInterval = config.getString("check-time-interval", "900");
            this.checkTimeTimezone = config.getString("check-time-timezone", "server");
            this.verbose = config.getBoolean("verbose", false);
        } else {
            this.goalMessage = this.getDefaultGoalMessage();
            this.goalSound = this.getDefaultGoalSound();
            this.rewardPermissions = new ArrayList();
            this.rewardCommands = new ArrayList();
            this.isRepeatable = false;
            this.offlineRewards = false;
            this.completionCheckInterval = "900";
            this.checkTimeTimezone = "server";
            this.verbose = false;
        }
    }

    protected void saveToFile() {
        try {
            if (!this.goalFile.exists()) {
                this.goalFile.getParentFile().mkdirs();
                this.goalFile.createNewFile();
            }
            YamlConfiguration config = new YamlConfiguration();
            config.options().setHeader(Arrays.asList("active:", "  - Determines whether this goal is enabled and tracked by the plugin.", "  - Set to 'true' to enable the goal and track player progress.", "  - Set to 'false' (default) to disable the goal without deleting it.", "", "repeatable:", "  - Determines whether the goal can be completed multiple times by a player.", "  - Set to 'true' if players should be able to complete it again after finishing.", "  - Set to 'false' if it should only be completed once.", "", "offline-rewards:", "  - If true, players who are offline when completing the goal will receive rewards when they next log in.", "  - Note: Currently, only players who were online during the last completion check interval are eligible.", "    For example, if the goal is checked daily and a player does not join within that day, they will not receive the reward.", "", "check-time-interval:", "  - Defines the completion check time rate for the goal.", "  - Can be set in two formats:", "", "  FORMAT 1 - SECONDS (number only):", "    - Enter a number representing seconds (e.g., 900 for 15 minutes)", "    - The check will start immediately after server reload/restart", "    - Subsequent checks will occur every X seconds from the first check", "    - Examples: 300 (5 minutes), 900 (15 minutes), 3600 (1 hour)", "", "  FORMAT 2 - CRON EXPRESSION:", "    - Format: <seconds> <minute> <hour> <day-of-month> <month> <day-of-week>", "    - Checks occur at fixed times regardless of server restarts", "    - I suggest using this website: https://www.freeformatter.com/cron-expression-generator-quartz.html", "    - ChatGPT is also helpful - use the keyword 'quartz cron format'", "    - Examples:", "      '0 */15 * * * ?' - Every 15 minutes at fixed times (e.g., :00, :15, :30, :45)", "      '0 0 0 * * ?' - Daily at midnight (00:00)", "      '0 0 0 ? * MON' - Weekly on Monday at midnight", "      '0 0 0 1 * ?' - Monthly on the 1st at midnight", "", "check-time-timezone:", "  - Whether to use server timezone or UTC for cron scheduling", "  - Values: 'server' or 'utc'", "  - Only applies to cron expressions, not seconds format", "", "verbose:", "  - Enable or disable debug logging in the console for this goal", "", "goal-sound:", "  - The sound played when a player reaches this goal.", "  - A list of available sounds can be found here:", "    https://jd.papermc.io/paper/<VERSION>/org/bukkit/Sound.html", "  - Replace '<VERSION>' with your server's Minecraft version.", "  - N.B. If your current version doesn\u2019t work, use the latest patch of the same major version. ", "    E.g. '1.19' doesn't work, use '1.19.4'.", "", "goal-message:", "  - The message shown to the player when they complete this goal.", "  - Available placeholders:", "    %TIME_REQUIRED% \u2192 The time needed to complete the goal.", "    %PLAYER_NAME%   \u2192 The player's name.", "    %GOAL_NAME%     \u2192 The name of the goal.", "", "requirements.time:", "  - Required playtime (in seconds) for the goal to be completed.", "  - If not set, it defaults to a very large number (intended behavior).", "", "requirements.permissions:", "  - A list of permissions the player must have to complete this goal.", "", "requirements.placeholders:", "  - A list of placeholder conditions that must be met to complete this goal.", "", "rewards.permissions:", "  - Permissions that will be granted to the player when they complete the goal.", "", "rewards.commands:", "  - Commands that will be executed when the player completes the goal.", "  - Available placeholders in commands:", "    PLAYER_NAME \u2192 The player's name.", ""));
            config.set("active", (Object)this.active);
            config.set("repeatable", (Object)this.isRepeatable);
            config.set("offline-rewards", (Object)this.offlineRewards);
            config.set("check-time-interval", (Object)this.completionCheckInterval);
            config.set("check-time-timezone", (Object)this.checkTimeTimezone);
            config.set("verbose", (Object)this.verbose);
            config.set("goal-sound", (Object)this.goalSound);
            config.set("goal-message", (Object)this.goalMessage);
            config.set("requirements.time", (Object)this.requirements.getTime());
            config.set("requirements.permissions", this.requirements.getPermissions());
            config.set("requirements.placeholders", this.requirements.getPlaceholderConditions());
            config.set("rewards.permissions", this.rewardPermissions);
            config.set("rewards.commands", this.rewardCommands);
            config.save(this.goalFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save goal file for " + this.name + ": " + e.getMessage());
        }
    }

    public void deleteFile() {
        if (this.goalFile.exists() && !this.goalFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete goal file for " + this.name);
        }
    }

    public void cancelCheckTask() {
        if (this.completionCheckTask != null && !this.completionCheckTask.isCancelled()) {
            this.completionCheckTask.cancel();
        }
        this.completionCheckTask = null;
    }

    public void restartCompletionCheckTask() {
        this.cancelCheckTask();
        if (this.useCronExpression) {
            this.startCronCompletionCheck();
        } else {
            this.startSecondsCompletionCheck();
        }
    }

    private void startSecondsCompletionCheck() {
        long delayInTicks = this.intervalSeconds * 20L;
        this.nextIntervalCheck = new Date(System.currentTimeMillis() + this.intervalSeconds * 1000L);
        this.completionCheckTask = new BukkitRunnable(){

            public void run() {
                if (!Goal.this.offlineRewards) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        OnlineUser onlineUser = Goal.this.onlineUsersManager.getOnlineUser(player.getName());
                        if (onlineUser == null) continue;
                        Goal.this.checkCompletion(onlineUser);
                    }
                    Goal.this.nextIntervalCheck = new Date(System.currentTimeMillis() + Goal.this.intervalSeconds * 1000L);
                    if (Goal.this.verbose) {
                        Map<String, Object> scheduleInfo = Goal.this.getNextSchedule();
                        Goal.this.plugin.getLogger().info(String.format("Goal %s check completed, next check will occur in %s on %s", Goal.this.name, scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
                    }
                } else {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        OnlineUser onlineUser = Goal.this.onlineUsersManager.getOnlineUser(player.getName());
                        if (onlineUser == null) continue;
                        Goal.this.checkCompletion(onlineUser);
                    }
                    Goal.this.loadPlayersJoinedDuringTimeWindow(users -> Bukkit.getScheduler().runTask((Plugin)Goal.this.plugin, () -> {
                        for (DBUser user : users) {
                            Goal.this.checkCompletion(user);
                        }
                        Goal.this.nextIntervalCheck = new Date(System.currentTimeMillis() + Goal.this.intervalSeconds * 1000L);
                        if (Goal.this.verbose) {
                            Map<String, Object> scheduleInfo = Goal.this.getNextSchedule();
                            Goal.this.plugin.getLogger().info(String.format("Goal %s check completed for %d players, next check in %s on %s", Goal.this.name, users.size(), scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
                        }
                    }));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, delayInTicks, delayInTicks);
    }

    private void startCronCompletionCheck() {
        Date oldSchedule = Objects.requireNonNullElseGet(this.nextIntervalCheckCron, Date::new);
        this.nextIntervalCheckCron = this.cronExpression.getNextValidTimeAfter(oldSchedule);
        long delayInMillis = this.nextIntervalCheckCron.getTime() - oldSchedule.getTime();
        long delayInTicks = Math.max(20L, delayInMillis / 50L);
        this.completionCheckTask = new BukkitRunnable(){

            public void run() {
                if (!Goal.this.offlineRewards) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        OnlineUser onlineUser = Goal.this.onlineUsersManager.getOnlineUser(player.getName());
                        if (onlineUser == null) continue;
                        Goal.this.checkCompletion(onlineUser);
                    }
                    Goal.this.restartCompletionCheckTask();
                    if (Goal.this.verbose) {
                        Map<String, Object> scheduleInfo = Goal.this.getNextSchedule();
                        Goal.this.plugin.getLogger().info(String.format("Goal %s check completed, next check will occur in %s on %s", Goal.this.name, scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
                    }
                } else {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        OnlineUser onlineUser = Goal.this.onlineUsersManager.getOnlineUser(player.getName());
                        if (onlineUser == null) continue;
                        Goal.this.checkCompletion(onlineUser);
                    }
                    Goal.this.loadPlayersJoinedDuringTimeWindow(users -> Bukkit.getScheduler().runTask((Plugin)Goal.this.plugin, () -> {
                        for (DBUser user : users) {
                            Goal.this.checkCompletion(user);
                        }
                        Goal.this.restartCompletionCheckTask();
                        if (Goal.this.verbose) {
                            Map<String, Object> scheduleInfo = Goal.this.getNextSchedule();
                            Goal.this.plugin.getLogger().info(String.format("Goal %s check completed for %d players, next check in %s on %s", Goal.this.name, users.size(), scheduleInfo.get("timeRemaining"), scheduleInfo.get("nextCheck")));
                        }
                    }));
                }
            }
        }.runTaskLater((Plugin)this.plugin, delayInTicks);
    }

    public void checkCompletion(DBUser user) {
        if (user.hasCompletedGoal(this.name) && !this.isRepeatable) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (user.isOnline()) {
                Player player = Bukkit.getPlayer((UUID)UUID.fromString(user.getUuid()));
                if (player == null) {
                    return;
                }
                long playerTime = user.getPlaytime();
                if (this.getRequirements().checkRequirements(player, playerTime)) {
                    user.markGoalAsCompletedAsync(this.name, true, () -> {
                        if (this.verbose) {
                            this.plugin.getLogger().info(String.format("User %s has reached the goal %s", user.getNickname(), this.name));
                        }
                        this.processCompletedGoal(user, player);
                    });
                }
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(user.getUuid()));
                if (!offlinePlayer.hasPlayedBefore()) {
                    return;
                }
                long playerTime = user.getPlaytime();
                ((CompletableFuture)this.getRequirements().checkRequirementsOffline(offlinePlayer, playerTime).thenAcceptAsync(requirementsMet -> {
                    if (requirementsMet.booleanValue()) {
                        user.markGoalAsCompletedAsync(this.name, false, () -> {
                            if (this.verbose) {
                                this.plugin.getLogger().info(String.format("Offline user %s has reached the goal %s", user.getNickname(), this.name));
                            }
                        });
                    }
                })).exceptionally(ex -> {
                    this.plugin.getLogger().warning("Error checking offline goal completion for " + offlinePlayer.getName() + ": " + ex.getMessage());
                    return null;
                });
            }
        });
    }

    protected void processCompletedGoal(DBUser onlineUser, Player player) {
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.assignPermissionsForGoal(onlineUser);
        }
        this.executeCommands(player);
        this.sendGoalMessage(player);
        this.playGoalSound(player);
    }

    private void assignPermissionsForGoal(DBUser onlineUser) {
        ArrayList<String> permissions = this.rewardPermissions;
        if (permissions != null && !permissions.isEmpty()) {
            try {
                LuckPermsManager.getInstance(this.plugin).assignGoalPermissions(onlineUser.getUuid(), this);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to assign permissions for goal %s to player %s: %s", this.name, onlineUser.getNickname(), e.getMessage()));
            }
        }
    }

    private void executeCommands(Player player) {
        ArrayList<String> commands = this.rewardCommands;
        if (commands != null && !commands.isEmpty()) {
            commands.forEach(command -> {
                try {
                    String formattedCommand = this.formatCommand((String)command, player);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand));
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to execute command for goal %s: %s", this.name, e.getMessage()));
                }
            });
        }
    }

    private String formatCommand(String command, Player player) {
        this.goalMessageReplacements.put("PLAYER_NAME", player.getName());
        return this.replacePlaceholders(command).replaceFirst("/", "");
    }

    private void playGoalSound(Player player) {
        try {
            Sound sound = null;
            try {
                sound = (Sound)Sound.class.getField(this.goalSound).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for goal '%s'", this.goalSound, this.name));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", this.goalSound, this.name, e.getMessage()));
        }
    }

    private void sendGoalMessage(Player player) {
        this.goalMessageReplacements.put("%PLAYER_NAME%", player.getName());
        this.goalMessageReplacements.put("%TIME_REQUIRED%", this.getRequirements().getTime() != Long.MAX_VALUE ? Utils.ticksToFormattedPlaytime(this.requirements.getTime()) : "-");
        this.goalMessageReplacements.put("%GOAL_NAME%", this.name);
        player.sendMessage(Utils.parseColors(this.replacePlaceholders(this.goalMessage)));
    }

    private String replacePlaceholders(String input) {
        String result = input;
        for (Map.Entry<String, String> entry : this.goalMessageReplacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        this.goalMessageReplacements.clear();
        return result;
    }

    public void translateCheckTimeToText() {
        if (this.useCronExpression) {
            try {
                CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ));
                Cron cron = parser.parse(this.cronExpression.toString());
                cron.validate();
                CronDescriptor descriptor = CronDescriptor.instance(Locale.ENGLISH);
                this.checkTimeToText = descriptor.describe(cron);
            }
            catch (Exception e) {
                this.checkTimeToText = "Invalid Quartz cron expression";
            }
        } else {
            this.checkTimeToText = "every " + Utils.ticksToFormattedPlaytime(this.intervalSeconds * 20L);
        }
    }

    public void rename(String newName) {
        File oldFile = this.goalFile;
        this.name = newName;
        File newFile = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "Goals" + File.separator + newName + ".yml");
        try {
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)oldFile);
                config.save(newFile);
                oldFile.delete();
            }
            this.saveToFile();
            this.db.getGoalsDAO().updateGoalName(oldFile.getName().replace(".yml", ""), newName);
            oldFile.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not rename goal file from " + oldFile.getName() + " to " + newFile.getName() + ": " + e.getMessage());
        }
    }

    private String getDefaultGoalSound() {
        return "ENTITY_PLAYER_LEVELUP";
    }

    private String getDefaultGoalMessage() {
        return "[&6PlayTime&eManager&f]&7 Congratulations &e%PLAYER_NAME%&7 you have completed a new goal!";
    }

    public String getName() {
        return this.name;
    }

    public GoalRewardRequirement getRequirements() {
        return this.requirements;
    }

    public String getGoalMessage() {
        return this.goalMessage;
    }

    public String getGoalSound() {
        return this.goalSound;
    }

    public boolean areOfflineRewardsEnabled() {
        return this.offlineRewards;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    public ArrayList<String> getRewardCommands() {
        return this.rewardCommands;
    }

    public ArrayList<String> getRewardPermissions() {
        return this.rewardPermissions;
    }

    public Map<String, Object> getNextSchedule() {
        Date nextCheck;
        HashMap<String, Object> scheduleInfo = new HashMap<String, Object>();
        Date date = nextCheck = this.useCronExpression ? this.nextIntervalCheckCron : this.nextIntervalCheck;
        if (this.active && nextCheck != null) {
            Date now = new Date();
            long delayInMillis = nextCheck.getTime() - now.getTime();
            long delayInTicks = Math.max(20L, delayInMillis / 50L);
            scheduleInfo.put("nextCheck", nextCheck);
            scheduleInfo.put("timeRemaining", Utils.ticksToFormattedPlaytime(delayInTicks));
        } else {
            scheduleInfo.put("nextCheck", "-");
            scheduleInfo.put("timeRemaining", "-");
        }
        scheduleInfo.put("timeCheckToText", this.checkTimeToText);
        return scheduleInfo;
    }

    public File getGoalFile() {
        return this.goalFile;
    }

    public void setTime(long time) {
        this.requirements.setTime(time);
        this.saveToFile();
    }

    public void setGoalMessage(String goalMessage) {
        this.goalMessage = goalMessage;
        this.saveToFile();
    }

    public void setGoalSound(String goalSound) {
        this.goalSound = goalSound;
        this.saveToFile();
    }

    public void setActivation(boolean activation) {
        this.active = activation;
        if (activation) {
            this.restartCompletionCheckTask();
            if (this.verbose) {
                this.plugin.getLogger().info("Goal " + this.name + " has been activated");
            }
        } else {
            this.cancelCheckTask();
            if (this.verbose) {
                this.plugin.getLogger().info("Goal " + this.name + " has been deactivated");
            }
        }
        this.saveToFile();
    }

    public void setRepeatable(boolean repeatable) {
        this.isRepeatable = repeatable;
        this.saveToFile();
    }

    public void setOfflineRewardEnabling(boolean activation) {
        this.offlineRewards = activation;
        this.saveToFile();
    }

    public boolean setCheckTime(String checkTime) {
        try {
            this.parseCheckTimeInterval(checkTime);
            this.timezone = "utc".equalsIgnoreCase(this.checkTimeTimezone) ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
            if (this.useCronExpression && this.cronExpression != null) {
                this.cronExpression.setTimeZone(this.timezone);
            }
            this.completionCheckInterval = checkTime;
            this.saveToFile();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addCommand(String command) {
        this.rewardCommands.add(command);
        this.saveToFile();
    }

    public void removeCommand(String command) {
        this.rewardCommands.remove(command);
        this.saveToFile();
    }

    public void addPermission(String permission) {
        this.rewardPermissions.add(permission);
        this.saveToFile();
    }

    public void removePermission(String permission) {
        this.rewardPermissions.remove(permission);
        this.saveToFile();
    }

    public void addRequirementPermission(String permission) {
        this.requirements.addPermission(permission);
        this.saveToFile();
    }

    public void removeRequirementPermission(String permission) {
        this.requirements.removePermission(permission);
        this.saveToFile();
    }

    public void addPlaceholderCondition(String condition) {
        this.requirements.addPlaceholderCondition(condition);
        this.saveToFile();
    }

    public void removePlaceholderCondition(String condition) {
        this.requirements.removePlaceholderCondition(condition);
        this.saveToFile();
    }

    public void clearPlaceholderConditions() {
        this.getRequirements().getPlaceholderConditions().clear();
        this.saveToFile();
    }

    public void clearRequirementPermissions() {
        this.getRequirements().getPermissions().clear();
        this.saveToFile();
    }

    public void kill(boolean update) {
        this.goalsManager.removeGoal(this);
        this.cancelCheckTask();
        this.deleteFile();
        if (!update) {
            DBUsersManager.getInstance().removeGoalFromAllUsers(this.name);
        }
    }

    public boolean isUsingCronExpression() {
        return this.useCronExpression;
    }

    public long getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public String getCompletionCheckInterval() {
        return this.completionCheckInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Goal goal = (Goal)o;
        return Objects.equals(this.name, goal.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Goal{name='" + this.name + "', time=" + this.requirements.getTime() + ", active=" + this.active + ", requirementPermissions=" + this.requirements.getPermissions().size() + ", placeholderConditions=" + this.requirements.getPlaceholderConditions().size() + ", rewardPermissions=" + this.rewardPermissions.size() + ", commands=" + this.rewardCommands.size() + ", message='" + this.goalMessage + "', sound='" + this.goalSound + "', checkMode=" + (this.useCronExpression ? "cron" : "interval") + ", checkValue=" + (String)(this.useCronExpression ? this.completionCheckInterval : this.intervalSeconds + "s") + "}";
    }
}

