/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.util.Map;
import java.util.Set;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.CycleScheduler;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardExecutor;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardMessageService;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardProcessor;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardRegistry;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.StreakTracker;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class JoinStreaksManager {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DatabaseHandler db = DatabaseHandler.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();
    private RewardRegistry rewardRegistry;
    private StreakTracker streakTracker;
    private CycleScheduler cycleScheduler;
    private RewardProcessor rewardProcessor;
    private RewardExecutor rewardExecutor;
    private RewardMessageService messageService;

    private JoinStreaksManager() {
    }

    public static JoinStreaksManager getInstance() {
        return InstanceHolder.instance;
    }

    public void initialize() {
        this.rewardRegistry = new RewardRegistry();
        this.cycleScheduler = new CycleScheduler();
        this.streakTracker = new StreakTracker();
        this.rewardExecutor = new RewardExecutor();
        this.messageService = new RewardMessageService();
        this.rewardProcessor = new RewardProcessor(this.rewardRegistry, this.streakTracker, this.rewardExecutor, this.messageService);
        this.rewardRegistry.createRewardsDirectory();
        this.rewardRegistry.loadRewards();
        this.cycleScheduler.initialize();
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            this.cycleScheduler.getNextSchedule();
        }
    }

    public void processPlayerLogin(OnlineUser onlineUser) {
        if (this.cycleScheduler.isEligibleForStreak(onlineUser)) {
            this.streakTracker.incrementAbsoluteStreak(onlineUser);
            this.cycleScheduler.markPlayerJoinedInCurrentCycle(onlineUser.getUuid());
            if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue() && !this.rewardRegistry.isEmpty()) {
                this.streakTracker.incrementRelativeStreak(onlineUser);
                this.rewardProcessor.processEligibleRewards(onlineUser);
            }
        }
    }

    public void resetMissingPlayerStreaksAsync() {
        if (!this.plugin.getConfiguration().getBoolean("reset-joinstreak.enabled").booleanValue()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Set<String> playersWithStreaks = this.db.getStreakDAO().getPlayersWithActiveStreaks();
            this.streakTracker.resetInactivePlayerStreaksAsync(playersWithStreaks, this.cycleScheduler.getIntervalSeconds(), this.plugin.getConfiguration().getInt("reset-joinstreak.missed-joins"), playersReset -> {
                if (this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
                    this.plugin.getLogger().info(String.format("Streak reset for %d players", playersReset));
                }
            });
        });
        this.onlineUsersManager.getOnlineUsersByUUID().values().forEach(this::processOnlineUserForCycleReset);
    }

    private void processOnlineUserForCycleReset(OnlineUser onlineUser) {
        this.streakTracker.incrementAbsoluteStreak(onlineUser);
        this.cycleScheduler.markPlayerJoinedInCurrentCycle(onlineUser.getUuid());
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue() && !this.rewardRegistry.isEmpty()) {
            this.streakTracker.incrementRelativeStreak(onlineUser);
            Player player = onlineUser.getPlayerInstance();
            if (player != null) {
                this.rewardProcessor.processEligibleRewards(onlineUser);
            }
        }
    }

    public boolean toggleJoinStreakCheckSchedule(CommandSender sender) {
        boolean currentState = this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation");
        this.plugin.getConfiguration().set("rewards-check-schedule-activation", !currentState);
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            if (this.rewardRegistry.isEmpty()) {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " No active rewards found. Join streak check schedule not started."));
                this.plugin.getConfiguration().set("rewards-check-schedule-activation", false);
                return false;
            }
            this.cycleScheduler.getNextSchedule();
            this.messageService.sendScheduleActivationMessage(sender, true);
            Map<String, Object> scheduleInfo = this.cycleScheduler.getNextSchedule();
            this.messageService.sendNextResetMessage(sender, scheduleInfo);
        } else {
            this.cycleScheduler.cancelIntervalTask();
            this.messageService.sendScheduleActivationMessage(sender, false);
            this.plugin.getLogger().info("The join streak check schedule has been deactivated from GUI button");
        }
        return true;
    }

    public Map<String, Object> getNextSchedule() {
        return this.cycleScheduler.getNextSchedule();
    }

    public void onServerReload() {
        this.cycleScheduler.updateOnReload();
    }

    public void cleanUp() {
        this.cycleScheduler.cleanUp();
        this.rewardRegistry.cleanUp();
        InstanceHolder.instance = null;
    }

    public RewardRegistry getRewardRegistry() {
        return this.rewardRegistry;
    }

    public StreakTracker getStreakTracker() {
        return this.streakTracker;
    }

    public RewardExecutor getRewardExecutor() {
        return this.rewardExecutor;
    }

    public CycleScheduler getCycleScheduler() {
        return this.cycleScheduler;
    }

    public RewardProcessor getRewardProcessor() {
        return this.rewardProcessor;
    }

    private static final class InstanceHolder {
        private static JoinStreaksManager instance = new JoinStreaksManager();

        private InstanceHolder() {
        }
    }
}

