/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.RewardMessageService;
import me.thegabro.playtimemanager.JoinStreaks.Models.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RewardExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final RewardMessageService messageService = new RewardMessageService();

    public void processCompletedReward(Player player, RewardSubInstance subInstance) {
        OnlineUser onlineUser = OnlineUsersManager.getInstance().getOnlineUser(player.getName());
        JoinStreakReward reward = JoinStreaksManager.getInstance().getRewardRegistry().getReward(subInstance.mainInstanceID());
        if (onlineUser.isExpired(subInstance)) {
            onlineUser.unclaimReward(subInstance);
            try {
                if (onlineUser.getRelativeJoinStreak() >= subInstance.requiredJoins()) {
                    onlineUser.addReceivedReward(subInstance);
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {}
        } else {
            onlineUser.unclaimReward(subInstance);
            onlineUser.addReceivedReward(subInstance);
        }
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.assignPermissionsForReward(onlineUser, reward);
        }
        this.executeRewardCommands(reward, player);
        this.messageService.sendRewardRelatedMessage(onlineUser, subInstance, reward.getRewardMessage(), 1);
        this.playRewardSound(player, reward);
    }

    private void assignPermissionsForReward(OnlineUser onlineUser, JoinStreakReward reward) {
        ArrayList<String> permissions = reward.getPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            try {
                LuckPermsManager.getInstance(this.plugin).assignRewardPermissions(onlineUser.getUuid(), reward);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to assign permissions for join streak reward %d to player %s: %s", reward.getId(), onlineUser.getNickname(), e.getMessage()));
            }
        }
    }

    private void executeRewardCommands(JoinStreakReward reward, Player player) {
        ArrayList<String> commands = reward.getCommands();
        if (commands != null && !commands.isEmpty()) {
            commands.forEach(command -> {
                try {
                    String formattedCommand = this.formatRewardCommand((String)command, player, reward);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand));
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to execute command for join streak reward %d: %s", reward.getId(), e.getMessage()));
                }
            });
        }
    }

    private String formatRewardCommand(String command, Player player, JoinStreakReward reward) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("PLAYER_NAME", player.getName());
        return this.replacePlaceholders(command, replacements).replaceFirst("/", "");
    }

    private void playRewardSound(Player player, JoinStreakReward reward) {
        try {
            Sound sound;
            String soundName;
            block6: {
                soundName = reward.getRewardSound();
                sound = null;
                try {
                    sound = (Sound)Sound.class.getField(soundName).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    if (!this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) break block6;
                    this.plugin.getLogger().info("Could not find sound directly, attempting fallback: " + e.getMessage());
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for reward '%s'", soundName, reward.getId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", reward.getRewardSound(), reward.getId(), e.getMessage()));
        }
    }

    private String replacePlaceholders(String input, Map<String, String> replacements) {
        String result = input;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

