/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import me.thegabro.playtimemanager.JoinStreaks.Models.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;

public class RewardRegistry {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final Set<JoinStreakReward> rewards = new HashSet<JoinStreakReward>();
    private final ArrayList<RewardSubInstance> joinRewardsInstances = new ArrayList();
    private JoinStreakReward lastRewardByJoins;

    public void createRewardsDirectory() {
        File rewardsFolder = new File(this.plugin.getDataFolder(), "Rewards");
        if (!rewardsFolder.exists()) {
            rewardsFolder.mkdirs();
        }
        this.createWarningFile(rewardsFolder);
    }

    private void createWarningFile(File rewardsFolder) {
        File warningFile = new File(rewardsFolder, "NEVER RENAME FILES IN THIS FOLDER.txt");
        if (!warningFile.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(warningFile));){
                writer.write("NEVER RENAME FILES IN THIS FOLDER\n");
                writer.write("--------------------------------------------------\n");
                writer.write("WARNING: The files in this folder are named according to their ID.\n");
                writer.write("Changing the names of these files will cause the configuration files to be missing in the database.\n");
                writer.write("This could result in failures as IDs are used by the plugin, and modifying the file names will break the mapping.\n");
                writer.write("ID values should never be changed by the user.\n");
                writer.write("--------------------------------------------------");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadRewards() {
        File[] rewardFiles;
        this.rewards.clear();
        this.joinRewardsInstances.clear();
        File rewardsFolder = new File(this.plugin.getDataFolder(), "Rewards");
        if (rewardsFolder.exists() && rewardsFolder.isDirectory() && (rewardFiles = rewardsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : rewardFiles) {
                String rewardID = file.getName().replace(".yml", "");
                try {
                    JoinStreakReward reward = new JoinStreakReward(Integer.parseInt(rewardID), -1);
                    this.addReward(reward);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid reward file name: " + file.getName());
                }
            }
        }
    }

    public void addReward(JoinStreakReward reward) {
        this.rewards.add(reward);
        this.updateJoinRewardsMap(reward);
        this.updateEndLoopReward();
    }

    public void removeReward(JoinStreakReward reward) {
        this.rewards.remove(reward);
        if (this.rewards.isEmpty()) {
            this.plugin.getConfiguration().set("rewards-check-schedule-activation", false);
        }
        this.joinRewardsInstances.removeIf(r -> r.mainInstanceID().intValue() == reward.getId());
        this.updateEndLoopReward();
    }

    public void updateJoinRewardsMap(JoinStreakReward reward) {
        int minJoins = reward.getMinRequiredJoins();
        int maxJoins = reward.getMaxRequiredJoins();
        if (minJoins == -1) {
            return;
        }
        if (minJoins == maxJoins) {
            this.joinRewardsInstances.add(new RewardSubInstance(reward.getId(), minJoins, false));
        } else {
            for (int joinCount = minJoins; joinCount <= maxJoins; ++joinCount) {
                this.joinRewardsInstances.add(new RewardSubInstance(reward.getId(), joinCount, false));
            }
        }
    }

    public void updateEndLoopReward() {
        this.lastRewardByJoins = this.rewards.stream().filter(reward -> reward.getMinRequiredJoins() != -1).max(Comparator.comparingInt(JoinStreakReward::getMaxRequiredJoins)).orElse(null);
    }

    public ArrayList<RewardSubInstance> getRewardIdsForJoinCount(int joinCount, OnlineUser onlineUser) {
        ArrayList<RewardSubInstance> rewardIds = new ArrayList<RewardSubInstance>();
        for (RewardSubInstance subInstance : this.joinRewardsInstances) {
            JoinStreakReward reward2 = this.getReward(subInstance.mainInstanceID());
            if (reward2 == null || joinCount < subInstance.requiredJoins() || subInstance.requiredJoins() == -1) continue;
            rewardIds.add(subInstance);
        }
        ArrayList<RewardSubInstance> receivedRewards = onlineUser.getReceivedRewards();
        rewardIds.removeIf(reward -> receivedRewards.stream().anyMatch(receivedReward -> receivedReward.mainInstanceID().equals(reward.mainInstanceID()) && receivedReward.requiredJoins().equals(reward.requiredJoins())));
        ArrayList<RewardSubInstance> unclaimedRewards = onlineUser.getRewardsToBeClaimed();
        rewardIds.removeIf(reward -> unclaimedRewards.stream().anyMatch(unclaimedReward -> unclaimedReward.mainInstanceID().equals(reward.mainInstanceID()) && unclaimedReward.requiredJoins().equals(reward.requiredJoins())) && reward.requiredJoins() != joinCount);
        return rewardIds;
    }

    public JoinStreakReward getReward(int id) {
        return this.rewards.stream().filter(g -> g.getId() == id).findFirst().orElse(null);
    }

    public RewardSubInstance getSubInstance(Integer mainInstanceID, Integer requiredJoins) {
        for (RewardSubInstance subInstance : this.joinRewardsInstances) {
            if (!subInstance.mainInstanceID().equals(mainInstanceID) || !subInstance.requiredJoins().equals(requiredJoins)) continue;
            return subInstance;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.rewards.isEmpty();
    }

    public Set<JoinStreakReward> getRewards() {
        return new HashSet<JoinStreakReward>(this.rewards);
    }

    public void clearRewards() {
        this.rewards.clear();
        this.joinRewardsInstances.clear();
        this.lastRewardByJoins = null;
    }

    public int getNextRewardId() {
        return this.rewards.stream().mapToInt(JoinStreakReward::getId).max().orElse(0) + 1;
    }

    public JoinStreakReward getLastRewardByJoins() {
        return this.lastRewardByJoins;
    }

    public void cleanUp() {
        this.clearRewards();
    }

    public ArrayList<RewardSubInstance> getJoinRewardsMap() {
        return this.joinRewardsInstances;
    }
}

