/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormatsConfiguration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version354to36Updater {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DatabaseHandler database = DatabaseHandler.getInstance();
    private final GUIsConfiguration guIsConfiguration = GUIsConfiguration.getInstance();
    private final CommandsConfiguration commandsConfiguration = CommandsConfiguration.getInstance();
    private long goals_old_check_schedule;

    public void performUpgrade() {
        this.recreateConfigFile();
        this.migrateRewardData();
        this.migrateGoalData();
        this.removeOldColumns();
        this.updateGoalData();
        this.migrateTimestampsToInstant();
    }

    private void recreateConfigFile() {
        Configuration config = Configuration.getInstance();
        this.goals_old_check_schedule = config.getLong("goal-check-rate");
        String prefix = config.getString("prefix");
        if (prefix == null) {
            prefix = "[&6PlayTime&eManager&f]&7 ";
        }
        config.updateConfig(false);
        this.commandsConfiguration.initialize(this.plugin);
        String playtime_self = this.commandsConfiguration.getString("playtime-self-message");
        String playtime_others = this.commandsConfiguration.getString("playtime-others-message");
        this.commandsConfiguration.updateConfig();
        this.guIsConfiguration.initialize(this.plugin);
        this.guIsConfiguration.updateConfig();
        this.commandsConfiguration.set("prefix", prefix);
        this.commandsConfiguration.set("playtime.self-message", playtime_self.replace("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 ", "&7").replace("\u00a7", "&"));
        this.commandsConfiguration.set("playtime.others-message", playtime_others.replace("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 ", "&7").replace("\u00a7", "&"));
        this.guIsConfiguration.set("player-stats-gui.goals-settings.list-format", "&7\u2022 &e%GOAL% &7(&e%GOAL_COMPLETED_TIMES%)");
    }

    private void migrateRewardData() {
        this.plugin.getLogger().info("Starting reward data migration from version 3.5.4 to 3.6...");
        try (Connection connection = this.database.getConnection();){
            if (!this.columnsExist(connection)) {
                this.plugin.getLogger().info("Old reward columns not found, migration not needed.");
                return;
            }
            String selectQuery = "SELECT uuid, nickname, received_rewards, rewards_to_be_claimed FROM play_time WHERE (received_rewards IS NOT NULL AND received_rewards != '') OR (rewards_to_be_claimed IS NOT NULL AND rewards_to_be_claimed != '')";
            PreparedStatement selectStmt = connection.prepareStatement(selectQuery);
            ResultSet rs = selectStmt.executeQuery();
            int migratedPlayers = 0;
            int totalReceivedRewards = 0;
            int totalClaimableRewards = 0;
            while (rs.next()) {
                List<String> rewardValues;
                String uuid = rs.getString("uuid");
                String nickname = rs.getString("nickname");
                String receivedRewards = rs.getString("received_rewards");
                String rewardsToBeClaimedStr = rs.getString("rewards_to_be_claimed");
                if (receivedRewards != null && !receivedRewards.trim().isEmpty()) {
                    rewardValues = this.parseRewardString(receivedRewards);
                    totalReceivedRewards += this.insertReceivedRewards(connection, uuid, nickname, rewardValues);
                }
                if (rewardsToBeClaimedStr != null && !rewardsToBeClaimedStr.trim().isEmpty()) {
                    rewardValues = this.parseRewardString(rewardsToBeClaimedStr);
                    totalClaimableRewards += this.insertRewardsToBeClaimed(connection, uuid, nickname, rewardValues);
                }
                ++migratedPlayers;
            }
            rs.close();
            selectStmt.close();
            if (migratedPlayers > 0) {
                this.plugin.getLogger().info(String.format("Migration completed successfully! Migrated %d players, %d received rewards, %d claimable rewards", migratedPlayers, totalReceivedRewards, totalClaimableRewards));
            } else {
                this.plugin.getLogger().info("No reward data found to migrate.");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error during reward data migration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void migrateGoalData() {
        this.plugin.getLogger().info("Starting goal data migration from version 3.5.4 to 3.6...");
        try (Connection connection = this.database.getConnection();){
            String selectQuery = "SELECT uuid, nickname, completed_goals FROM play_time WHERE completed_goals IS NOT NULL AND completed_goals != ''";
            PreparedStatement selectStmt = connection.prepareStatement(selectQuery);
            ResultSet rs = selectStmt.executeQuery();
            int migratedPlayers = 0;
            int totalGoals = 0;
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String nickname = rs.getString("nickname");
                String completedGoals = rs.getString("completed_goals");
                if (completedGoals == null || completedGoals.trim().isEmpty()) continue;
                List<String> goalNames = this.parseGoalString(completedGoals);
                int insertedGoals = this.insertCompletedGoals(connection, uuid, nickname, goalNames);
                totalGoals += insertedGoals;
                if (insertedGoals <= 0) continue;
                ++migratedPlayers;
            }
            rs.close();
            selectStmt.close();
            this.plugin.getLogger().info(String.format("Goal migration completed! Migrated %d players with %d total completed goals", migratedPlayers, totalGoals));
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error during goal data migration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean columnsExist(Connection connection) {
        try {
            PreparedStatement stmt = connection.prepareStatement("SELECT received_rewards, rewards_to_be_claimed FROM play_time LIMIT 1");
            stmt.executeQuery();
            stmt.close();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private List<String> parseRewardString(String rewardStr) {
        if (rewardStr == null || rewardStr.trim().isEmpty()) {
            return List.of();
        }
        return Arrays.stream(rewardStr.split(",")).map(String::trim).filter(reward -> !reward.isEmpty()).collect(Collectors.toList());
    }

    private List<String> parseGoalString(String goalStr) {
        if (goalStr == null || goalStr.trim().isEmpty()) {
            return List.of();
        }
        return Arrays.stream(goalStr.split(",")).map(String::trim).filter(goal -> !goal.isEmpty()).collect(Collectors.toList());
    }

    private int insertReceivedRewards(Connection connection, String uuid, String nickname, List<String> rewardValues) {
        if (rewardValues.isEmpty()) {
            return 0;
        }
        try {
            String insertQuery = "INSERT INTO received_rewards (user_uuid, nickname, main_instance_ID, required_joins, received_at) VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP)";
            PreparedStatement stmt = connection.prepareStatement(insertQuery);
            for (String rewardValue : rewardValues) {
                int requiredJoins;
                int mainInstanceId;
                String[] parts = rewardValue.split("\\.");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("Invalid reward format for UUID " + uuid + ": " + rewardValue);
                    continue;
                }
                try {
                    mainInstanceId = Integer.parseInt(parts[0]);
                    requiredJoins = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid numeric values in reward for UUID " + uuid + ": " + rewardValue);
                    continue;
                }
                stmt.setString(1, uuid);
                stmt.setString(2, nickname);
                stmt.setInt(3, mainInstanceId);
                stmt.setInt(4, requiredJoins);
                stmt.addBatch();
            }
            int[] results = stmt.executeBatch();
            stmt.close();
            return results.length;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error inserting received rewards for UUID " + uuid + ": " + e.getMessage());
            return 0;
        }
    }

    private int insertRewardsToBeClaimed(Connection connection, String uuid, String nickname, List<String> rewardValues) {
        if (rewardValues.isEmpty()) {
            return 0;
        }
        try {
            String insertQuery = "INSERT INTO rewards_to_be_claimed (user_uuid, nickname, main_instance_ID, required_joins, created_at, expired) VALUES (?, ?, ?, ?, CURRENT_TIMESTAMP, ?)";
            PreparedStatement stmt = connection.prepareStatement(insertQuery);
            for (String rewardValue : rewardValues) {
                int requiredJoins;
                int mainInstanceId;
                String[] parts;
                boolean notClaimedInTime = false;
                if (rewardValue.endsWith(".R")) {
                    rewardValue = rewardValue.substring(0, rewardValue.length() - 2);
                    notClaimedInTime = true;
                }
                if ((parts = rewardValue.split("\\.")).length != 2) {
                    this.plugin.getLogger().warning("Invalid reward format for UUID " + uuid + ": " + rewardValue);
                    continue;
                }
                try {
                    mainInstanceId = Integer.parseInt(parts[0]);
                    requiredJoins = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid numeric values in reward for UUID " + uuid + ": " + rewardValue);
                    continue;
                }
                stmt.setString(1, uuid);
                stmt.setString(2, nickname);
                stmt.setInt(3, mainInstanceId);
                stmt.setInt(4, requiredJoins);
                stmt.setBoolean(5, notClaimedInTime);
                stmt.addBatch();
            }
            int[] results = stmt.executeBatch();
            stmt.close();
            return results.length;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error inserting claimable rewards for UUID " + uuid + ": " + e.getMessage());
            return 0;
        }
    }

    private int insertCompletedGoals(Connection connection, String uuid, String nickname, List<String> goalNames) {
        if (goalNames.isEmpty()) {
            return 0;
        }
        try {
            String insertQuery = "INSERT INTO completed_goals (goal_name, user_uuid, nickname, completed_at, received, received_at) VALUES (?, ?, ?, CURRENT_TIMESTAMP, 1, CURRENT_TIMESTAMP)";
            PreparedStatement stmt = connection.prepareStatement(insertQuery);
            for (String goalName : goalNames) {
                stmt.setString(1, goalName);
                stmt.setString(2, uuid);
                stmt.setString(3, nickname);
                stmt.addBatch();
            }
            int[] results = stmt.executeBatch();
            stmt.close();
            return results.length;
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error inserting completed goals for UUID " + uuid + ": " + e.getMessage());
            return 0;
        }
    }

    private void removeOldColumns() {
        try {
            Connection connection = this.database.getConnection();
            PreparedStatement dropNewIfExists = connection.prepareStatement("DROP TABLE IF EXISTS play_time_new");
            dropNewIfExists.executeUpdate();
            dropNewIfExists.close();
            String createNewTableQuery = "CREATE TABLE play_time_new (uuid VARCHAR(32) NOT NULL UNIQUE,nickname VARCHAR(32) NOT NULL UNIQUE,playtime BIGINT NOT NULL,artificial_playtime BIGINT NOT NULL,afk_playtime BIGINT NOT NULL,last_seen DATETIME DEFAULT NULL,first_join DATETIME DEFAULT NULL,relative_join_streak INT DEFAULT 0,absolute_join_streak INT DEFAULT 0,PRIMARY KEY (uuid));";
            PreparedStatement createStmt = connection.prepareStatement(createNewTableQuery);
            createStmt.executeUpdate();
            createStmt.close();
            String copyDataQuery = "INSERT INTO play_time_new (uuid, nickname, playtime, artificial_playtime, afk_playtime, last_seen, first_join, relative_join_streak, absolute_join_streak) SELECT uuid, nickname, playtime, artificial_playtime, afk_playtime, last_seen, first_join, relative_join_streak, absolute_join_streak FROM play_time";
            PreparedStatement copyStmt = connection.prepareStatement(copyDataQuery);
            copyStmt.executeUpdate();
            copyStmt.close();
            PreparedStatement dropStmt = connection.prepareStatement("DROP TABLE play_time");
            dropStmt.executeUpdate();
            dropStmt.close();
            PreparedStatement renameStmt = connection.prepareStatement("ALTER TABLE play_time_new RENAME TO play_time");
            renameStmt.executeUpdate();
            renameStmt.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error removing old columns / adding new column: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void updateGoalData() {
        PlaytimeFormatsConfiguration playtimeFormatsConfiguration = PlaytimeFormatsConfiguration.getInstance();
        playtimeFormatsConfiguration.initialize(this.plugin);
        this.updatePlaytimeFormatsData(playtimeFormatsConfiguration);
        GoalsManager goalsManager = GoalsManager.getInstance();
        goalsManager.initialize(this.plugin);
        goalsManager.goalsUpdater();
        goalsManager.clearGoals();
        goalsManager.loadGoals();
        for (Goal g : goalsManager.getGoals()) {
            g.setCheckTime(String.valueOf(this.goals_old_check_schedule));
        }
    }

    public void updatePlaytimeFormatsData(PlaytimeFormatsConfiguration playtimeFormatsConfiguration) {
        HashMap<String, Object> newFields = new HashMap<String, Object>();
        newFields.put("distribute-removed-time", false);
        playtimeFormatsConfiguration.formatsUpdater(newFields);
    }

    private void migrateTimestampsToInstant() {
        this.plugin.getLogger().info("Starting timestamp migration to Instant format (DATETIME -> BIGINT)...");
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try {
                this.plugin.getLogger().info("Creating new table with BIGINT timestamp columns...");
                PreparedStatement createNewTableStmt = connection.prepareStatement("CREATE TABLE play_time_migrated (uuid VARCHAR(32) NOT NULL UNIQUE, nickname VARCHAR(32) NOT NULL UNIQUE, playtime BIGINT NOT NULL, artificial_playtime BIGINT NOT NULL, afk_playtime BIGINT NOT NULL, last_seen BIGINT DEFAULT NULL, first_join BIGINT DEFAULT NULL, relative_join_streak INT DEFAULT 0, absolute_join_streak INT DEFAULT 0, PRIMARY KEY (uuid))");
                createNewTableStmt.executeUpdate();
                createNewTableStmt.close();
                this.plugin.getLogger().info("Converting and copying timestamp data with timezone consideration...");
                PreparedStatement selectStmt = connection.prepareStatement("SELECT uuid, nickname, playtime, artificial_playtime, afk_playtime, last_seen, first_join, relative_join_streak, absolute_join_streak FROM play_time");
                PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO play_time_migrated (uuid, nickname, playtime, artificial_playtime, afk_playtime, last_seen, first_join, relative_join_streak, absolute_join_streak) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                ResultSet rs = selectStmt.executeQuery();
                int rowsCopied = 0;
                while (rs.next()) {
                    insertStmt.setString(1, rs.getString("uuid"));
                    insertStmt.setString(2, rs.getString("nickname"));
                    insertStmt.setLong(3, rs.getLong("playtime"));
                    insertStmt.setLong(4, rs.getLong("artificial_playtime"));
                    insertStmt.setLong(5, rs.getLong("afk_playtime"));
                    Timestamp lastSeenTs = rs.getTimestamp("last_seen");
                    if (lastSeenTs != null && !rs.wasNull()) {
                        insertStmt.setLong(6, lastSeenTs.getTime());
                    } else {
                        insertStmt.setNull(6, -5);
                    }
                    Timestamp firstJoinTs = rs.getTimestamp("first_join");
                    if (firstJoinTs != null && !rs.wasNull()) {
                        insertStmt.setLong(7, firstJoinTs.getTime());
                    } else {
                        insertStmt.setNull(7, -5);
                    }
                    insertStmt.setInt(8, rs.getInt("relative_join_streak"));
                    insertStmt.setInt(9, rs.getInt("absolute_join_streak"));
                    insertStmt.executeUpdate();
                    ++rowsCopied;
                }
                rs.close();
                selectStmt.close();
                insertStmt.close();
                this.plugin.getLogger().info("Removing old table...");
                PreparedStatement dropOldTableStmt = connection.prepareStatement("DROP TABLE play_time");
                dropOldTableStmt.executeUpdate();
                dropOldTableStmt.close();
                this.plugin.getLogger().info("Finalizing migration...");
                PreparedStatement renameTableStmt = connection.prepareStatement("ALTER TABLE play_time_migrated RENAME TO play_time");
                renameTableStmt.executeUpdate();
                renameTableStmt.close();
                connection.commit();
                this.plugin.getLogger().info(String.format("Timestamp migration completed successfully! Migrated %d player records to BIGINT format", rowsCopied));
            }
            catch (SQLException e) {
                connection.rollback();
                this.plugin.getLogger().severe("Error during timestamp migration, rolled back changes: " + e.getMessage());
                e.printStackTrace();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Fatal error during timestamp migration: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

