/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DBUsersManager {
    private final DatabaseHandler db = DatabaseHandler.getInstance();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private static volatile DBUsersManager instance;
    private final List<DBUser> topPlayers;
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final CommandsConfiguration commandsConfiguration = CommandsConfiguration.getInstance();
    private final Configuration configuration = Configuration.getInstance();
    private final GUIsConfiguration guIsConfiguration = GUIsConfiguration.getInstance();
    private static final int TOP_PLAYERS_LIMIT = 100;
    private final BiMap<String, String> nicknameUuidCache;
    private final Map<String, DBUser> userCache;
    private final Set<String> nonExistentUsers = ConcurrentHashMap.newKeySet();
    private List<String> playersHiddenFromLeaderBoard;

    private DBUsersManager() {
        this.topPlayers = Collections.synchronizedList(new ArrayList());
        this.userCache = new ConcurrentHashMap<String, DBUser>();
        this.nicknameUuidCache = Maps.synchronizedBiMap((BiMap)HashBiMap.create());
        this.playersHiddenFromLeaderBoard = new ArrayList<String>();
        this.startCacheMaintenanceTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBUsersManager getInstance() {
        if (instance != null) return instance;
        Class<DBUsersManager> clazz = DBUsersManager.class;
        synchronized (DBUsersManager.class) {
            if (instance != null) return instance;
            instance = new DBUsersManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void startCacheMaintenanceTask() {
        long clearInterval = 432000L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            this.updateTopPlayersFromDB();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, this::clearCaches);
        }, clearInterval, clearInterval);
    }

    public void getUserFromNicknameAsync(String nickname, Consumer<DBUser> callback) {
        if (this.nonExistentUsers.contains(nickname.toLowerCase())) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String uuid = this.db.getPlayerDAO().getUUIDFromNickname(nickname);
            if (uuid == null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
                return;
            }
            this.getUserFromUUIDAsync(uuid, callback);
        });
    }

    public void getUserFromNicknameAsyncWithContext(String nickname, String context, Consumer<DBUser> callback) {
        if (this.nonExistentUsers.contains(nickname.toLowerCase())) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String uuid = this.db.getPlayerDAO().getUUIDFromNickname(nickname);
            if (uuid == null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
                return;
            }
            this.getUserFromUUIDAsyncWithContext(uuid, context, callback);
        });
    }

    public DBUser getUserFromUUIDSync(String uuid) {
        CompletableFuture future = new CompletableFuture();
        this.getUserFromUUIDAsync(uuid, future::complete);
        try {
            return (DBUser)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getUserFromUUIDAsync(String uuid, Consumer<DBUser> callback) {
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUserByUUID(uuid);
        if (onlineUser != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(onlineUser));
            return;
        }
        DBUser cached = this.userCache.get(uuid);
        if (cached != null) {
            Objects.requireNonNull(this.plugin);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(cached));
            return;
        }
        Objects.requireNonNull(this.plugin);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!this.db.getPlayerDAO().playerExists(uuid)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
                return;
            }
            Objects.requireNonNull(this.plugin);
            DBUser.fromUUIDAsync(uuid, user -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (user != null) {
                    this.userCache.put(uuid, (DBUser)user);
                    this.nicknameUuidCache.put((Object)user.getNickname().toLowerCase(), (Object)uuid);
                    Objects.requireNonNull(this.plugin);
                }
                callback.accept((DBUser)user);
            }));
        });
    }

    public void getUserFromUUIDAsyncWithContext(String uuid, String context, Consumer<DBUser> callback) {
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUserByUUID(uuid);
        if (onlineUser != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(onlineUser));
            return;
        }
        DBUser cached = this.userCache.get(uuid);
        if (cached != null) {
            Objects.requireNonNull(this.plugin);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(cached));
            return;
        }
        Objects.requireNonNull(this.plugin);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!this.db.getPlayerDAO().playerExists(uuid)) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.accept(null));
                return;
            }
            Objects.requireNonNull(this.plugin);
            DBUser.fromUUIDAsync(uuid, user -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                if (user != null) {
                    this.userCache.put(uuid, (DBUser)user);
                    this.nicknameUuidCache.put((Object)user.getNickname().toLowerCase(), (Object)uuid);
                    Objects.requireNonNull(this.plugin);
                }
                callback.accept((DBUser)user);
            }));
        });
    }

    public DBUser getUserFromCacheSync(String nickname) {
        String lowerNickname = nickname.toLowerCase();
        if (this.nonExistentUsers.contains(lowerNickname)) {
            return null;
        }
        OnlineUser onlineUser = this.onlineUsersManager.getOnlineUser(nickname);
        if (onlineUser != null) {
            return onlineUser;
        }
        String uuid = (String)this.nicknameUuidCache.get((Object)nickname.toLowerCase());
        if (uuid == null) {
            return null;
        }
        return this.userCache.get(uuid);
    }

    public boolean isKnownNonExistent(String nickname) {
        return this.nonExistentUsers.contains(nickname.toLowerCase());
    }

    public void markAsNonExistent(String nickname) {
        this.nonExistentUsers.add(nickname.toLowerCase());
    }

    public void markAsExistent(String nickname) {
        this.nonExistentUsers.remove(nickname.toLowerCase());
    }

    public void updateTopPlayersFromDB() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersManager.updateAllOnlineUsersPlaytime().get();
                this.playersHiddenFromLeaderBoard = this.plugin.getConfiguration().getStringList("placeholders.playtime-leaderboard-blacklist");
                Map<String, String> dbTopPlayers = this.db.getStatisticsDAO().getTopPlayersByPlaytime(100 + this.playersHiddenFromLeaderBoard.size());
                List<CompletableFuture> futures = dbTopPlayers.keySet().stream().map(uuid -> {
                    CompletableFuture future = new CompletableFuture();
                    this.getUserFromUUIDAsyncWithContext((String)uuid, "leaderboard-update", future::complete);
                    return future;
                }).toList();
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRunAsync(() -> {
                    List<DBUser> validTopPlayers = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).filter(user -> !this.playersHiddenFromLeaderBoard.contains(user.getNickname())).limit(100L).toList();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        List<DBUser> list = this.topPlayers;
                        synchronized (list) {
                            this.topPlayers.clear();
                            this.topPlayers.addAll(validTopPlayers);
                        }
                    });
                });
            }
            catch (InterruptedException | ExecutionException e) {
                this.plugin.getLogger().severe("Error updating top players: " + e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCachedTopPlayers(OnlineUser onlineUser) {
        if (this.playersHiddenFromLeaderBoard.contains(onlineUser.getNickname())) {
            return;
        }
        String uuid = onlineUser.getUuid();
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            boolean alreadyPresent = this.topPlayers.stream().anyMatch(player -> player.getUuid().equals(uuid));
        }
        this.getUserFromUUIDAsyncWithContext(uuid, "cached leaderboard update", user -> {
            if (user == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                List<DBUser> list = this.topPlayers;
                synchronized (list) {
                    boolean exists = this.topPlayers.stream().anyMatch(p -> p.getUuid().equals(uuid));
                    if (!exists && this.topPlayers.size() < 100) {
                        this.topPlayers.add((DBUser)user);
                    } else if (exists) {
                        for (int i = 0; i < this.topPlayers.size(); ++i) {
                            if (!this.topPlayers.get(i).getUuid().equals(uuid)) continue;
                            this.topPlayers.set(i, (DBUser)user);
                            break;
                        }
                    }
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBUser getTopPlayerAtPosition(int position) {
        if (position < 1 || position > this.topPlayers.size()) {
            return null;
        }
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            List<DBUser> sortedPlayers = this.topPlayers.stream().sorted(Comparator.comparing(DBUser::getPlaytime).reversed()).toList();
            return sortedPlayers.get(position - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBUser> getTopPlayers() {
        List<DBUser> list = this.topPlayers;
        synchronized (list) {
            return this.topPlayers.stream().sorted(Comparator.comparing(DBUser::getPlaytime).reversed()).collect(Collectors.toList());
        }
    }

    public void removeGoalFromAllUsers(String goalName) {
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.unmarkGoalAsCompleted(goalName);
        }
        this.db.getGoalsDAO().removeGoalFromAllUsers(goalName);
    }

    public void removeRewardFromAllUsers(Integer mainInstanceID) {
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.wipeReceivedRewards(mainInstanceID);
            user.wipeRewardsToBeClaimed(mainInstanceID);
        }
        this.db.getStreakDAO().removeRewardFromAllUsers(mainInstanceID);
    }

    public void updateNicknameInCache(String uuid, String oldNickname, String newNickname) {
        DBUser cachedUser;
        if (oldNickname != null) {
            this.nicknameUuidCache.remove((Object)oldNickname.toLowerCase());
        }
        if ((cachedUser = this.userCache.get(uuid)) != null) {
            this.nicknameUuidCache.put((Object)newNickname.toLowerCase(), (Object)uuid);
        }
        Objects.requireNonNull(this.plugin);
    }

    public void updateUUIDInCache(String oldUUID, String newUUID, String nickname) {
        DBUser user = this.userCache.remove(oldUUID);
        if (user != null) {
            this.userCache.put(newUUID, user);
        }
        this.nicknameUuidCache.inverse().remove((Object)oldUUID);
        this.nicknameUuidCache.put((Object)nickname.toLowerCase(), (Object)newUUID);
        Objects.requireNonNull(this.plugin);
    }

    public List<String> getPlayersHiddenFromLeaderBoard() {
        return new ArrayList<String>(this.playersHiddenFromLeaderBoard);
    }

    public void hidePlayerFromLeaderBoard(String nickname) {
        this.playersHiddenFromLeaderBoard.add(nickname);
        this.plugin.getConfiguration().set("placeholders.playtime-leaderboard-blacklist", this.playersHiddenFromLeaderBoard);
    }

    public void unhidePlayerFromLeaderBoard(String nickname) {
        this.playersHiddenFromLeaderBoard.remove(nickname);
        this.plugin.getConfiguration().set("placeholders.playtime-leaderboard-blacklist", this.playersHiddenFromLeaderBoard);
    }

    public void removeUserFromCache(String uuid) {
        DBUser user = this.userCache.remove(uuid);
        if (user != null) {
            this.nicknameUuidCache.remove((Object)user.getNickname().toLowerCase());
        }
    }

    public void clearCaches() {
        this.userCache.clear();
        this.nicknameUuidCache.clear();
        this.commandsConfiguration.clearCache();
        this.configuration.clearCache();
        this.guIsConfiguration.clearCache();
    }
}

