/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OnlineUsersManager {
    private static volatile OnlineUsersManager instance;
    private BukkitTask dbUpdateSchedule;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final Map<String, OnlineUser> onlineUsersByName = new ConcurrentHashMap<String, OnlineUser>();
    private final Map<String, OnlineUser> onlineUsersByUUID = new ConcurrentHashMap<String, OnlineUser>();
    private static final int DB_UPDATE_INTERVAL = 6000;

    private OnlineUsersManager() {
        this.loadOnlineUsers();
    }

    public void initialize() {
        this.startGoalCheckSchedule();
        this.startDBUpdateSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnlineUsersManager getInstance() {
        if (instance != null) return instance;
        Class<OnlineUsersManager> clazz = OnlineUsersManager.class;
        synchronized (OnlineUsersManager.class) {
            if (instance != null) return instance;
            instance = new OnlineUsersManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, OnlineUser> getOnlineUsersByUUID() {
        return this.onlineUsersByUUID;
    }

    public void addOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.put(onlineUser.getNickname().toLowerCase(), onlineUser);
        this.onlineUsersByUUID.put(onlineUser.getUuid(), onlineUser);
    }

    public void removeOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.remove(onlineUser.getNickname().toLowerCase());
        this.onlineUsersByUUID.remove(onlineUser.getUuid());
    }

    public void loadOnlineUsers() {
        Bukkit.getOnlinePlayers().forEach(player -> OnlineUser.createOnlineUserAsync(player, this::addOnlineUser));
    }

    public OnlineUser getOnlineUser(String nickname) {
        return this.onlineUsersByName.get(nickname.toLowerCase());
    }

    public OnlineUser getOnlineUserByUUID(String uuid) {
        return this.onlineUsersByUUID.get(uuid);
    }

    public void startGoalCheckSchedule() {
        Set<Goal> goals = this.goalsManager.getGoals();
        for (Goal g : goals) {
            if (!g.isActive()) continue;
            g.restartCompletionCheckTask();
        }
    }

    private void startDBUpdateSchedule() {
        if (this.dbUpdateSchedule != null) {
            this.dbUpdateSchedule.cancel();
        }
        this.dbUpdateSchedule = new BukkitRunnable(){

            public void run() {
                OnlineUsersManager.this.updateAllOnlineUsersPlaytime();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 6000L);
    }

    public CompletableFuture<Void> updateAllOnlineUsersPlaytime() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersByName.values().forEach(user -> {
                    try {
                        user.updatePlayTime();
                        user.updateAFKPlayTime();
                        user.updateLastSeen();
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe(String.format("Failed to update playtime for user %s: %s", user.getNickname(), e.getMessage()));
                    }
                });
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public void stopSchedules() {
        Optional.ofNullable(this.dbUpdateSchedule).ifPresent(BukkitTask::cancel);
    }
}

