/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayTimeReset {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final JoinStreaksManager joinStreaksManager = JoinStreaksManager.getInstance();
    private final DatabaseHandler db = DatabaseHandler.getInstance();
    private static final Map<UUID, PendingReset> pendingResets = new HashMap<UUID, PendingReset>();
    private static final long CONFIRMATION_TIMEOUT_SECONDS = 60L;
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public PlayTimeReset(CommandSender sender, String[] args) {
        String targetPlayer = args[0];
        String resetType = "everything";
        if (args.length > 2) {
            resetType = args[2];
        }
        if (targetPlayer.equals("*")) {
            this.handleResetAllConfirmation(sender, resetType);
            return;
        }
        this.executeResetForPlayer(sender, targetPlayer, resetType);
    }

    private void executeResetForPlayer(CommandSender sender, String playerName, String resetType) {
        switch (resetType) {
            case "server_playtime": {
                this.resetPlayerServerPlaytime(sender, playerName);
                this.dbUsersManager.updateTopPlayersFromDB();
                break;
            }
            case "playtime": {
                this.resetPlayerPlaytime(sender, playerName);
                this.dbUsersManager.updateTopPlayersFromDB();
                break;
            }
            case "last_seen": {
                this.resetPlayerLastSeen(sender, playerName);
                break;
            }
            case "first_join": {
                this.resetPlayerFirstJoin(sender, playerName);
                break;
            }
            case "joinstreak": {
                this.resetPlayerJoinstreak(sender, playerName);
                break;
            }
            case "joinstreak_rewards": {
                this.resetPlayerJoinstreakRewards(sender, playerName);
                break;
            }
            case "goals": {
                this.resetPlayerGoals(sender, playerName);
                break;
            }
            case "everything": {
                this.resetPlayerEverything(sender, playerName);
                this.dbUsersManager.updateTopPlayersFromDB();
                break;
            }
            default: {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Unknown reset type: &e" + resetType + "&7. Valid types: server_playtime, playtime, last_seen, first_join, joinstreak, joinstreak_rewards, goals, everything"));
            }
        }
    }

    public void resetPlayerServerPlaytime(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                long resetPlaytime = 0L;
                if (user instanceof OnlineUser) {
                    p = Bukkit.getPlayerExact((String)playerName);
                    if (p != null) {
                        resetPlaytime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
                        p.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                        ((OnlineUser)user).refreshFromServerOnJoinPlayTime();
                    }
                } else {
                    p = Bukkit.getOfflinePlayer((String)playerName);
                    if (p.hasPlayedBefore()) {
                        try {
                            resetPlaytime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
                            p.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Failed to reset server playtime for offline player: " + playerName);
                        }
                    }
                }
                long finalResetPlaytime = resetPlaytime;
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset server playtime for player &e" + playerName + "&7 (Removed &e" + Utils.ticksToFormattedPlaytime(finalResetPlaytime) + "&7 of playtime)"));
            });
        });
    }

    public void resetPlayerPlaytime(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            long playtimeBeforeReset = user.getPlaytime();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetPlaytime();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset playtime for player &e" + playerName + "&7 (Removed &e" + Utils.ticksToFormattedPlaytime(playtimeBeforeReset) + "&7 of playtime)")));
            });
        });
    }

    public void resetPlayerLastSeen(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetLastSeen();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset last seen data for player &e" + playerName + "&7")));
            });
        });
    }

    public void resetPlayerFirstJoin(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetFirstJoin();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset first join data for player &e" + playerName + "&7")));
            });
        });
    }

    public void resetPlayerJoinstreak(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            int joinStreakBeforeReset = user.getRelativeJoinStreak();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetJoinStreaks();
                this.joinStreaksManager.getStreakTracker().restartUserJoinStreakRewards((DBUser)user);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset join streak for player &e" + playerName + "&7 (Removed &e" + joinStreakBeforeReset + "&7 joins)")));
            });
        });
    }

    public void resetPlayerJoinstreakRewards(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetJoinStreakRewards();
                this.joinStreaksManager.getStreakTracker().restartUserJoinStreakRewards((DBUser)user);
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset join streak rewards for player &e" + playerName + "&7")));
            });
        });
    }

    public void resetPlayerGoals(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            int completedGoalsCount = user.getCompletedGoals().size();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.resetGoals();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset goals for player &e" + playerName + "&7 (Removed &e" + completedGoalsCount + "&7 completed goals)")));
            });
        });
    }

    public void resetPlayerEverything(CommandSender sender, String playerName) {
        this.getValidatedUser(sender, playerName, user -> {
            if (user == null) {
                return;
            }
            long playtimeBeforeReset = user.getPlaytime();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                user.reset();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset everything for player &e" + playerName + "&7 (Removed &e" + Utils.ticksToFormattedPlaytime(playtimeBeforeReset) + "&7 of playtime)")));
            });
        });
    }

    public void resetAllPlayerServerPlaytime(CommandSender sender) {
        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Starting reset of all players' server playtime, this will take some time..."));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            AtomicInteger totalPlayersReset = new AtomicInteger();
            AtomicLong totalPlaytimeReset = new AtomicLong();
            HashSet processedPlayerUUIDs = new HashSet();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    UUID playerUUID = player.getUniqueId();
                    long currentPlaytime = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
                    totalPlaytimeReset.addAndGet(currentPlaytime);
                    if (!processedPlayerUUIDs.contains(playerUUID)) {
                        totalPlayersReset.getAndIncrement();
                        processedPlayerUUIDs.add(playerUUID);
                    }
                    player.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                    OnlineUser onlineUser = this.onlineUsersManager.getOnlineUserByUUID(playerUUID.toString());
                    if (onlineUser == null) continue;
                    onlineUser.refreshFromServerOnJoinPlayTime();
                }
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.hasPlayedBefore()) continue;
                    UUID playerUUID = offlinePlayer.getUniqueId();
                    try {
                        if (!processedPlayerUUIDs.contains(playerUUID)) {
                            totalPlayersReset.getAndIncrement();
                            processedPlayerUUIDs.add(playerUUID);
                        }
                        long currentPlaytime = offlinePlayer.getStatistic(Statistic.PLAY_ONE_MINUTE);
                        totalPlaytimeReset.addAndGet(currentPlaytime);
                        offlinePlayer.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to reset server playtime for offline player: " + offlinePlayer.getName());
                    }
                }
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " All players' server playtime has been reset! Total: &e" + String.valueOf(totalPlayersReset) + "&7 players with &e" + Utils.ticksToFormattedPlaytime(totalPlaytimeReset.get()) + "&7 of playtime"));
            });
        });
    }

    private void resetAllPlayersGeneric(CommandSender sender, String resetType, String displayName) {
        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Starting reset of all players' " + displayName + ", this will take some time..."));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<String> allNicknames = this.db.getPlayerDAO().getAllNicknames();
            AtomicInteger totalPlayersReset = new AtomicInteger();
            AtomicLong totalDataReset = new AtomicLong();
            AtomicInteger processedPlayers = new AtomicInteger();
            for (String nickname : allNicknames) {
                this.dbUsersManager.getUserFromNicknameAsyncWithContext(nickname, "reset all players generic command", user -> {
                    if (user != null) {
                        switch (resetType) {
                            case "playtime": {
                                totalDataReset.addAndGet(user.getPlaytime());
                                user.resetPlaytime();
                                this.dbUsersManager.updateTopPlayersFromDB();
                                break;
                            }
                            case "last_seen": {
                                user.resetLastSeen();
                                this.dbUsersManager.updateTopPlayersFromDB();
                                break;
                            }
                            case "first_join": {
                                user.resetFirstJoin();
                                break;
                            }
                            case "joinstreak": {
                                totalDataReset.addAndGet(user.getRelativeJoinStreak());
                                user.resetJoinStreaks();
                                this.joinStreaksManager.getStreakTracker().restartUserJoinStreakRewards((DBUser)user);
                                break;
                            }
                            case "joinstreak_rewards": {
                                user.resetJoinStreakRewards();
                                this.joinStreaksManager.getStreakTracker().restartUserJoinStreakRewards((DBUser)user);
                                break;
                            }
                            case "goals": {
                                totalDataReset.addAndGet(user.getCompletedGoals().size());
                                user.resetGoals();
                                break;
                            }
                            case "everything": {
                                totalDataReset.addAndGet(user.getPlaytime());
                                user.reset();
                                this.dbUsersManager.updateTopPlayersFromDB();
                            }
                        }
                        totalPlayersReset.incrementAndGet();
                    }
                    if (processedPlayers.incrementAndGet() == allNicknames.size()) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                            String message = " All players' " + displayName + " has been reset! Total: &e" + String.valueOf(totalPlayersReset) + "&7 players";
                            if (resetType.equals("playtime") || resetType.equals("everything")) {
                                message = message + " with &e" + Utils.ticksToFormattedPlaytime(totalDataReset.get()) + "&7 of playtime";
                            } else if (resetType.equals("joinstreak")) {
                                message = message + " with &e" + String.valueOf(totalDataReset) + "&7 joins";
                            } else if (resetType.equals("goals")) {
                                message = message + " with &e" + String.valueOf(totalDataReset) + "&7 completed goals";
                            }
                            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + message));
                        });
                    }
                });
            }
        });
    }

    public void handleResetAllConfirmation(CommandSender sender, String resetType) {
        UUID senderUUID;
        UUID uUID = senderUUID = sender instanceof Player ? ((Player)sender).getUniqueId() : UUID.fromString("00000000-0000-0000-0000-000000000000");
        if (pendingResets.containsKey(senderUUID)) {
            PendingReset pendingReset = pendingResets.get(senderUUID);
            if (pendingReset.isExpired()) {
                pendingResets.remove(senderUUID);
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Your previous reset confirmation has expired. Please try again."));
                this.requestConfirmation(sender, senderUUID, resetType);
                return;
            }
            if (!pendingReset.resetType.equals(resetType)) {
                pendingResets.remove(senderUUID);
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Reset type has changed. Please confirm again."));
                this.requestConfirmation(sender, senderUUID, resetType);
                return;
            }
            pendingResets.remove(senderUUID);
            this.executeResetAllForType(sender, resetType);
        } else {
            this.requestConfirmation(sender, senderUUID, resetType);
        }
    }

    private void executeResetAllForType(CommandSender sender, String resetType) {
        switch (resetType) {
            case "server_playtime": {
                this.resetAllPlayerServerPlaytime(sender);
                break;
            }
            case "playtime": {
                this.resetAllPlayersGeneric(sender, "playtime", "playtime");
                break;
            }
            case "last_seen": {
                this.resetAllPlayersGeneric(sender, "last_seen", "last seen data");
                break;
            }
            case "first_join": {
                this.resetAllPlayersGeneric(sender, "first_join", "first join data");
                break;
            }
            case "joinstreak": {
                this.resetAllPlayersGeneric(sender, "joinstreak", "join streaks");
                break;
            }
            case "joinstreak_rewards": {
                this.resetAllPlayersGeneric(sender, "joinstreak_rewards", "join streak rewards");
                break;
            }
            case "goals": {
                this.resetAllPlayersGeneric(sender, "goals", "goals");
                break;
            }
            case "everything": {
                this.resetAllPlayersGeneric(sender, "everything", "data");
                break;
            }
            default: {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Unknown reset type: &e" + resetType + "&7. Valid types: server_playtime, playtime, last_seen, first_join, joinstreak, joinstreak_rewards, goals, everything"));
            }
        }
    }

    private void requestConfirmation(CommandSender sender, UUID senderUUID, String resetType) {
        pendingResets.put(senderUUID, new PendingReset(resetType));
        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " &c&lWARNING&r&7: You are about to reset " + this.getResetTypeDescription(resetType) + " for &e&lALL players&7!"));
        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " &7This action cannot be undone. Run the command again within 60 seconds to confirm."));
    }

    private String getResetTypeDescription(String resetType) {
        switch (resetType) {
            case "server_playtime": {
                return "server playtime statistics";
            }
            case "playtime": {
                return "playtime data";
            }
            case "last_seen": {
                return "last seen data";
            }
            case "first_join": {
                return "first join data";
            }
            case "joinstreak": {
                return "join streaks";
            }
            case "joinstreak_rewards": {
                return "join streak rewards";
            }
            case "goals": {
                return "goals data";
            }
            case "everything": {
                return "all data";
            }
        }
        return "unknown data";
    }

    private void getValidatedUser(CommandSender sender, String playerName, Consumer<DBUser> callback) {
        this.dbUsersManager.getUserFromNicknameAsyncWithContext(playerName, "playtime reset command", user -> {
            if (user == null) {
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + this.config.getString("player-never-joined").replace("%PLAYER%", playerName)));
            }
            callback.accept((DBUser)user);
        });
    }

    public static void cleanupExpiredConfirmations() {
        pendingResets.entrySet().removeIf(entry -> ((PendingReset)entry.getValue()).isExpired());
    }

    private static class PendingReset {
        final String resetType;
        final long timestamp;

        PendingReset(String resetType) {
            this.resetType = resetType;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > TimeUnit.SECONDS.toMillis(60L);
        }
    }
}

