/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.Objects;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Customizations.GUIsConfiguration;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormatsConfiguration;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaytimeReload
implements CommandExecutor {
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final JoinStreaksManager joinStreaksManager = JoinStreaksManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("playtime.reload")) {
            this.plugin.getConfiguration().reload();
            PlaytimeFormatsConfiguration.getInstance().reload();
            GUIsConfiguration.getInstance().reload();
            CommandsConfiguration.getInstance().reload();
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The configuration files have been reloaded"));
            this.goalsManager.clearGoals();
            this.goalsManager.loadGoals();
            for (Player p : Bukkit.getOnlinePlayers()) {
                OnlineUser user = this.onlineUsersManager.getOnlineUser(Objects.requireNonNull(p.getPlayer()).getName());
                if (user == null) continue;
                user.updatePlayTime();
                this.onlineUsersManager.removeOnlineUser(user);
            }
            this.onlineUsersManager.loadOnlineUsers();
            this.onlineUsersManager.startGoalCheckSchedule();
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Goal check schedule has been restarted"));
            this.dbUsersManager.updateTopPlayersFromDB();
            this.joinStreaksManager.getRewardRegistry().clearRewards();
            this.joinStreaksManager.getRewardRegistry().loadRewards();
            this.joinStreaksManager.getCycleScheduler().initialize();
            if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
                this.joinStreaksManager.getCycleScheduler().getNextSchedule();
                sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Join streak check schedule has been restarted"));
            }
            return true;
        }
        sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + this.config.getString("no-permission")));
        return false;
    }
}

