/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport.AntiAFKPlus;

import me.koyere.antiafkplus.api.AntiAFKPlusAPI;
import me.koyere.antiafkplus.api.events.EventRegistration;
import me.thegabro.playtimemanager.ExternalPluginSupport.AFKSyncManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.entity.Player;

public class AntiAFKPlusAFKHook {
    private static AntiAFKPlusAFKHook instance;
    private EventRegistration afkStateRegistration;
    private final AFKSyncManager afkSyncManager = AFKSyncManager.getInstance();

    private AntiAFKPlusAFKHook() {
    }

    public static AntiAFKPlusAFKHook getInstance() {
        if (instance == null) {
            instance = new AntiAFKPlusAFKHook();
        }
        return instance;
    }

    public void register() {
        AntiAFKPlusAPI api = AntiAFKPlusAPI.getInstance();
        this.afkStateRegistration = api.registerAFKStateListener(event -> {
            PlayTimeManager.getInstance().getLogger().info("AntiAFKPlus Event");
            Player player = event.getPlayer();
            if (player == null || !player.isOnline()) {
                return;
            }
            String playerUUID = player.getUniqueId().toString();
            OnlineUser onlineUser = OnlineUsersManager.getInstance().getOnlineUserByUUID(playerUUID);
            if (onlineUser == null) {
                return;
            }
            boolean isNowAFK = event.getToStatus().isAFK();
            if (isNowAFK) {
                this.afkSyncManager.handleAFKGo(onlineUser);
            } else {
                this.afkSyncManager.handleAFKReturn(onlineUser);
            }
        });
    }

    public void unregister() {
        if (this.afkStateRegistration != null) {
            AntiAFKPlusAPI api = AntiAFKPlusAPI.getInstance();
            api.unregisterListener(this.afkStateRegistration);
            this.afkStateRegistration = null;
        }
    }
}

