/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.JoinStreak;

import java.util.ArrayList;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.GUIs.JoinStreak.AllJoinStreakRewardsGui;
import me.thegabro.playtimemanager.GUIs.JoinStreak.JoinStreakRewardPrizesGui;
import me.thegabro.playtimemanager.GUIs.Misc.ConfirmationGui;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.JoinStreaks.Models.JoinStreakReward;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinStreakRewardSettingsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 54;
    private Inventory inventory;
    private JoinStreakReward reward;
    private AllJoinStreakRewardsGui parentGui;
    private PlayTimeManager plugin;
    private final ChatEventManager chatEventManager = ChatEventManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public JoinStreakRewardSettingsGui() {
    }

    public JoinStreakRewardSettingsGui(JoinStreakReward reward, AllJoinStreakRewardsGui parentGui) {
        this.reward = reward;
        this.parentGui = parentGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors("Reward: " + reward.getId()));
        this.plugin = PlayTimeManager.getInstance();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void initializeItems() {
        this.inventory.clear();
        this.initializeBackground();
        this.initializeButtons();
    }

    private void initializeBackground() {
        for (int i = 0; i < 54; ++i) {
            if (this.isButtonSlot(i)) continue;
            this.inventory.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors("&f[&6P.T.M.&f]&7"), new Component[0]));
        }
    }

    private boolean isButtonSlot(int slot) {
        return slot == 10 || slot == 13 || slot == 33 || slot == 16 || slot == 45 || slot == 53 || slot == 29 || slot == 31 || slot == 40;
    }

    private void initializeButtons() {
        this.inventory.setItem(10, this.createGuiItem(Material.EXPERIENCE_BOTTLE, Utils.parseColors("&e&lRequired Joins: &6" + (this.reward.getMinRequiredJoins() == -1 ? "-" : this.reward.getRequiredJoinsDisplay())), new Component[]{Component.text((String)""), Utils.parseColors("&7Click to edit the required joins")}));
        this.inventory.setItem(13, this.createGuiItem(Material.CHEST_MINECART, Utils.parseColors("&e&lPrizes"), new Component[]{Utils.parseColors("&7Currently &e" + this.reward.getPermissions().size() + "&7 " + (this.reward.getPermissions().size() != 1 ? "permissions loaded" : "permission loaded")), Utils.parseColors("&7Currently &e" + this.reward.getCommands().size() + "&7 " + (this.reward.getCommands().size() != 1 ? "commands loaded" : "command loaded")), Component.text((String)""), Utils.parseColors("&7Click to manage reward's prizes")}));
        this.inventory.setItem(33, this.createGuiItem(Material.OAK_SIGN, Utils.parseColors("&e&lReward Achieved Message"), new Component[]{Component.text((String)""), Utils.parseColors("&7Left-click to edit the message"), Utils.parseColors("&7Right-click to display the message")}));
        this.inventory.setItem(16, this.createGuiItem(Material.NOTE_BLOCK, Utils.parseColors("&e&lReward Sound"), Utils.parseColors("&7Current: &f" + this.reward.getRewardSound()), Utils.parseColors(""), Utils.parseColors("&7Left-click to edit the sound"), Utils.parseColors("&7Right click to play the sound.")));
        this.inventory.setItem(45, this.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete Reward"), new Component[]{Component.text((String)""), Utils.parseColors("&7Click to delete this reward")}));
        this.inventory.setItem(53, this.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Utils.parseColors("&e&lBack"), new Component[0]));
        ArrayList<Object> rewardsDescLore = new ArrayList<Object>();
        rewardsDescLore.add(Utils.parseColors("&7Click to edit rewards description"));
        if (!this.reward.getRewardDescription().isEmpty()) {
            String[] descriptionLines;
            rewardsDescLore.add(Component.text((String)""));
            rewardsDescLore.add(Utils.parseColors("&7Current description:"));
            for (String line : descriptionLines = this.reward.getRewardDescription().split("/n")) {
                rewardsDescLore.add(Utils.parseColors("&7" + line));
            }
        }
        this.inventory.setItem(31, this.createGuiItem(Material.PAPER, Utils.parseColors("&e&lRewards Description"), rewardsDescLore.toArray(new Component[0])));
        ArrayList<Object> DescLore = new ArrayList<Object>();
        DescLore.add(Utils.parseColors("&7Click to edit reward's description"));
        if (!this.reward.getRewardDescription().isEmpty()) {
            String[] descriptionLines;
            DescLore.add(Component.text((String)""));
            DescLore.add(Utils.parseColors("&7Current description:"));
            for (String line : descriptionLines = this.reward.getDescription().split("/n")) {
                DescLore.add(Utils.parseColors("&7" + line));
            }
        }
        this.inventory.setItem(29, this.createGuiItem(Material.WRITABLE_BOOK, Utils.parseColors("&e&lDescription"), DescLore.toArray(new Component[0])));
        ItemStack iconItem = this.createGuiItem(Material.valueOf((String)this.reward.getItemIcon()), Utils.parseColors("&e&lReward Icon"), new Component[]{Component.text((String)""), Utils.parseColors("&7Click to set an icon")});
        this.inventory.setItem(40, iconItem);
    }

    public ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    public void onGUIClick(Player player, int slot, ItemStack clickedItem, ClickType clickType) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        switch (slot) {
            case 10: {
                this.openRequiredJoinsEditor(player);
                break;
            }
            case 13: {
                player.closeInventory();
                new JoinStreakRewardPrizesGui(this.reward, this).openInventory(player);
                break;
            }
            case 33: {
                if (clickType == ClickType.LEFT) {
                    this.openMessageEditor(player);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                player.sendMessage(Utils.parseColors(this.reward.getRewardMessage()));
                break;
            }
            case 16: {
                if (clickType == ClickType.LEFT) {
                    this.openSoundEditor(player);
                    break;
                }
                if (clickType != ClickType.RIGHT) break;
                this.playRewardSound(player);
                break;
            }
            case 45: {
                this.handleDeleteReward(player);
                break;
            }
            case 53: {
                this.handleBackButton(player);
                break;
            }
            case 31: {
                if (clickType != ClickType.LEFT) break;
                this.openRewardsDescriptionEditor(player);
                break;
            }
            case 29: {
                if (clickType != ClickType.LEFT) break;
                this.openDescriptionEditor(player);
                break;
            }
            case 40: {
                this.openItemIconSelector(player);
            }
        }
    }

    private void openRequiredJoinsEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Required Joins Editor: &eReward " + this.reward.getId());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        String currentValue = this.reward.getRequiredJoinsDisplay();
        Component instructions = Utils.parseColors("&fEnter the required joins for this reward:\n&7\u2022 Current value: &e" + currentValue + "\n&7\u2022 Enter a single positive number (e.g. \"5\")\n&7\u2022 OR enter an interval with format \"x1-x2\"\n&7  This represents a range of joins from x1 to x2\n&7  Example: \"1-25\" triggers on ALL joins from 1st to 25th\n&7\u2022 Enter &c-1 &7to deactivate this reward\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, input) -> {
            if (!input.equalsIgnoreCase("cancel")) {
                boolean success = this.reward.setRequiredJoinsFromString((String)input);
                if (success) {
                    String newValue = this.reward.getRequiredJoinsDisplay();
                    if (input.equals("-1")) {
                        player.sendMessage(Utils.parseColors("&aReward has been deactivated!"));
                    } else {
                        player.sendMessage(Utils.parseColors("&aRequired joins updated to " + newValue + "!"));
                    }
                    JoinStreaksManager.getInstance().getRewardRegistry().updateJoinRewardsMap(this.reward);
                    JoinStreaksManager.getInstance().getRewardRegistry().updateEndLoopReward();
                } else {
                    player.sendMessage(Utils.parseColors("&cInvalid format. Please enter a positive number, -1 to deactivate, or a valid range (e.g., 1-25)."));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cRequired joins edit cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void openRewardsDescriptionEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Rewards Description Editor: &eReward " + this.reward.getId());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a description of what the player receives when achieving this reward.\n&7\u2022 Describe the specific rewards or benefits\n&7\u2022 This will be returned by the placeholder %REWARD_DETAILS%\n&e&o\u2022 Example: '500 coins, VIP rank for 7 days&r'\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7\u2022 Type &a&oconfirm&r&7 to submit\n&7\u2022 Type &e&onewline&r&7 to start a new line\n&7\u2022 Type &e&oremoveline&r&7 to remove the last line");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                this.reward.setRewardDescription((String)message);
                player.sendMessage(Utils.parseColors("&aRewards description updated successfully!"));
            } else {
                player.sendMessage(Utils.parseColors("&cRewards description edit cancelled"));
            }
            this.reopenMainGui(player);
        }, true, this.reward.getRewardDescription());
    }

    private void openDescriptionEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Reward Description Editor: &eReward " + this.reward.getId());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a brief, general description for this reward.\n&7\u2022 Keep it short and concise\n&e&o\u2022 Example: 'A 30 days achievement for dedicated players!&r'\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7\u2022 Type &a&oconfirm&r&7 to submit\n&7\u2022 Type &e&onewline&r&7 to start a new line\n&7\u2022 Type &e&oremoveline&r&7 to remove the last line");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                this.reward.setDescription((String)message);
                player.sendMessage(Utils.parseColors("&aReward description updated successfully!"));
            } else {
                player.sendMessage(Utils.parseColors("&cReward description edit cancelled"));
            }
            this.reopenMainGui(player);
        }, true, this.reward.getDescription());
    }

    private void openItemIconSelector(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&lItem Icon Selector");
        Component instructions = Utils.parseColors("&7Hold the item you want to use as the reward icon and type &a&lconfirm &r&7in chat.\n&7\u2022 Custom items with NBT are currently &a&cnot supported\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        player.sendMessage(header);
        player.sendMessage(instructions);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (message.equalsIgnoreCase("confirm")) {
                ItemStack heldItem = player.getInventory().getItemInMainHand();
                if (heldItem.getType() != Material.AIR) {
                    this.reward.setItemIcon(heldItem.clone().getType().toString());
                    player.sendMessage(Utils.parseColors("&aReward icon updated successfully!"));
                } else {
                    player.sendMessage(Utils.parseColors("&cYou must be holding an item to set as the icon!"));
                }
            } else if (!message.equalsIgnoreCase("cancel")) {
                player.sendMessage(Utils.parseColors("&eInvalid input. Use 'confirm' or 'cancel'."));
            } else {
                player.sendMessage(Utils.parseColors("&cItem icon selection cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void openMessageEditor(Player player) {
        player.closeInventory();
        Component header = Utils.parseColors("&6&l\u270e Message Editor: &eReward " + this.reward.getId());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the new message for this reward.\n&7\u2022 Supports legacy and hex color codes \n&7\u2022 Available placeholders: %PLAYER_NAME%, %REQUIRED_JOINS%\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                this.reward.setRewardMessage((String)message);
                player.sendMessage(Utils.parseColors("&aReward message updated successfully!"));
            } else {
                player.sendMessage(Utils.parseColors("&cReward message edit cancelled"));
            }
            this.reopenMainGui(player);
        });
        Component clickableSuggestion = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Utils.parseColors("\n"))).append(Utils.parseColors("&7You can "))).append(Utils.parseColors("&6&l[click here]").clickEvent(ClickEvent.suggestCommand((String)this.reward.getRewardMessage())).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors("&eClick to autocomplete the current message"))))).append(Utils.parseColors("&7 to autocomplete the current message"));
        player.sendMessage(clickableSuggestion);
    }

    private void openSoundEditor(Player player) {
        player.closeInventory();
        String actualUrl = "https://jd.papermc.io/paper/1.21.5/org/bukkit/Sound.html";
        Component header = Utils.parseColors("&6&l\u270e Sound Editor: &eReward " + this.reward.getId());
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter the new sound for this reward.\n&7\u2022 Input is not case-sensitive\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component linkText = Utils.parseColors("&e&l\u00bb SOUND LIST \u00ab").clickEvent(ClickEvent.openUrl((String)actualUrl)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors("&fClick to open sounds documentation for 1.21.5")));
        Component linkInfo = Utils.parseColors("&7&oDocumentation for server version 1.21.5");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append((Component)Component.newline())).append(linkText)).append((Component)Component.newline())).append(linkInfo)).append((Component)Component.newline())).append(divider);
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, input) -> {
            if (!input.equalsIgnoreCase("cancel")) {
                Sound sound = null;
                try {
                    sound = (Sound)Sound.class.getField(input.toUpperCase()).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                if (sound != null) {
                    this.reward.setRewardSound(input.toUpperCase());
                    player.sendMessage(Utils.parseColors("&aReward sound updated successfully!"));
                } else {
                    player.sendMessage(Utils.parseColors("&e" + input.toUpperCase() + " is not a valid sound"));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cReward sound edit cancelled"));
            }
            this.reopenMainGui(player);
        });
    }

    private void playRewardSound(Player player) {
        try {
            String soundName = this.reward.getRewardSound();
            Sound sound = null;
            try {
                sound = (Sound)Sound.class.getField(soundName).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for reward '%s'", soundName, this.reward.getId()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for reward '%s': %s", this.reward.getRewardSound(), this.reward.getId(), e.getMessage()));
        }
    }

    private void handleDeleteReward(Player player) {
        ItemStack rewardItem = this.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete Reward: " + this.reward.getId()), new Component[0]);
        ConfirmationGui confirmationGui = new ConfirmationGui(rewardItem, confirmed -> {
            if (confirmed.booleanValue()) {
                player.sendMessage(Utils.parseColors(this.config.getString("prefix") + " &7Deleting reward &e" + this.reward.getId() + "&7..."));
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayTimeManager.getInstance(), () -> {
                    this.reward.kill();
                    Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getInstance(), () -> {
                        player.sendMessage(Utils.parseColors(this.config.getString("prefix") + " &aSuccessfully &7deleted reward &e" + this.reward.getId()));
                        if (this.parentGui != null) {
                            this.parentGui.openInventory(player);
                        }
                    });
                });
            } else {
                this.openInventory(player);
            }
        });
        player.closeInventory();
        confirmationGui.openInventory(player);
    }

    private void handleBackButton(Player player) {
        if (this.parentGui != null) {
            player.closeInventory();
            this.parentGui.openInventory(player);
        }
    }

    private void reopenMainGui(Player player) {
        Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(player));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof JoinStreakRewardSettingsGui && e.getRawSlot() < e.getInventory().getSize()) {
            e.setCancelled(true);
            JoinStreakRewardSettingsGui gui = (JoinStreakRewardSettingsGui)e.getInventory().getHolder();
            gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getClick());
        }
    }

    private static final class Slots {
        static final int REQUIRED_JOINS = 10;
        static final int REWARD_PRIZES = 13;
        static final int REWARD_SOUND = 16;
        static final int DESCRIPTION = 29;
        static final int REWARDS_DESCRIPTION = 31;
        static final int REWARD_MESSAGE = 33;
        static final int REWARD_ICON = 40;
        static final int DELETE_REWARD = 45;
        static final int BACK_BUTTON = 53;

        private Slots() {
        }
    }
}

