/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class GoalsManager {
    private static GoalsManager instance;
    private final Set<Goal> goals = new HashSet<Goal>();
    private PlayTimeManager plugin;

    private GoalsManager() {
    }

    public static synchronized GoalsManager getInstance() {
        if (instance == null) {
            instance = new GoalsManager();
        }
        return instance;
    }

    public void initialize(PlayTimeManager playTimeManager) {
        this.plugin = playTimeManager;
        this.clearGoals();
        this.loadGoals();
    }

    public void processPlayerLogin(OnlineUser user) {
        ArrayList<String> notReceivedGoals = new ArrayList<String>(user.getNotReceivedGoals());
        for (String notReceivedGoal : notReceivedGoals) {
            user.markGoalAsReceivedAsync(notReceivedGoal, () -> {
                Player player = user.getPlayerInstance();
                if (player != null && player.isOnline()) {
                    this.getGoal(notReceivedGoal).processCompletedGoal(user, player);
                }
            });
        }
    }

    public void addGoal(Goal goal) {
        this.goals.add(goal);
    }

    public void removeGoal(Goal goal) {
        this.goals.remove(goal);
    }

    public Goal getGoal(String name) {
        return this.goals.stream().filter(g -> g.getName().equals(name)).findFirst().orElse(null);
    }

    public Set<Goal> getGoals() {
        return new HashSet<Goal>(this.goals);
    }

    public List<String> getGoalsNames() {
        return this.goals.stream().map(Goal::getName).collect(Collectors.toList());
    }

    public void clearGoals() {
        for (Goal g : this.goals) {
            g.cancelCheckTask();
        }
        this.goals.clear();
    }

    public void loadGoals() {
        File[] goalFiles;
        File goalsFolder = new File(this.plugin.getDataFolder(), "Goals");
        if (goalsFolder.exists() && goalsFolder.isDirectory() && (goalFiles = goalsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : goalFiles) {
                String goalName = file.getName().replace(".yml", "");
                this.addGoal(new Goal(this.plugin, goalName));
            }
        }
    }

    public boolean areAllInactive() {
        for (Goal g : this.goals) {
            if (!g.isActive()) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> createConfigBackup(FileConfiguration config) {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        Set keys = config.getKeys(true);
        for (String key : keys) {
            Object value = config.get(key);
            if (value == null) continue;
            backup.put(key, value);
        }
        return backup;
    }

    public void restoreFromBackup(Map<String, Object> backup, FileConfiguration config) {
        if (backup == null || backup.isEmpty()) {
            this.plugin.getLogger().warning("Backup is null or empty, nothing to restore");
            return;
        }
        for (Map.Entry<String, Object> entry : backup.entrySet()) {
            String key = entry.getKey();
            Object backupValue = entry.getValue();
            if (!config.contains(key) || backupValue instanceof MemorySection) continue;
            Object currentValue = config.get(key);
            if (backupValue == null || backupValue.equals(currentValue) || backupValue instanceof String && ((String)backupValue).trim().isEmpty()) continue;
            config.set(key, backupValue);
        }
    }

    public void goalsUpdater() {
        HashSet<Goal> goalsClone = new HashSet<Goal>(this.goals);
        for (Goal g : goalsClone) {
            File oldConfig = g.getGoalFile();
            String goalName = g.getName();
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)oldConfig);
            Map<String, Object> backup = this.createConfigBackup((FileConfiguration)config);
            g.kill(true);
            Goal newGoalInstance = new Goal(this.plugin, goalName);
            this.goals.add(newGoalInstance);
            this.restoreFromBackup(backup, (FileConfiguration)config);
            g.saveToFile();
        }
    }
}

