/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Utils;
import me.thegabro.playtimemanager.libs.cronutils.descriptor.CronDescriptor;
import me.thegabro.playtimemanager.libs.cronutils.model.Cron;
import me.thegabro.playtimemanager.libs.cronutils.model.CronType;
import me.thegabro.playtimemanager.libs.cronutils.model.definition.CronDefinitionBuilder;
import me.thegabro.playtimemanager.libs.cronutils.parser.CronParser;
import me.thegabro.playtimemanager.libs.quartz.CronExpression;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CycleScheduler {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private CronExpression cronExpression;
    private TimeZone timezone;
    private Date nextIntervalReset;
    private long exactIntervalSeconds;
    private final DatabaseHandler db = DatabaseHandler.getInstance();
    private BukkitTask intervalTask;
    private final Set<String> playersJoinedDuringCurrentCycle = new HashSet<String>();
    private String checkTimeToText;

    public void initialize() {
        this.validateConfiguration();
        Date now = new Date();
        Date firstTrigger = this.cronExpression.getNextValidTimeAfter(now);
        Date secondTrigger = this.cronExpression.getNextValidTimeAfter(firstTrigger);
        long intervalMillis = secondTrigger.getTime() - firstTrigger.getTime();
        this.exactIntervalSeconds = intervalMillis / 1000L;
        this.translateCheckTimeToText();
        this.nextIntervalReset = null;
        this.scheduleNextReset();
    }

    private void validateConfiguration() {
        try {
            String cronString = this.plugin.getConfiguration().getString("streak-reset-schedule");
            this.cronExpression = new CronExpression(cronString);
            String timezoneConfig = this.plugin.getConfiguration().getString("reset-schedule-timezone");
            this.timezone = "utc".equalsIgnoreCase(timezoneConfig) ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
            this.cronExpression.setTimeZone(this.timezone);
            if (this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
                this.plugin.getLogger().info("Join streak configuration validated successfully");
                this.plugin.getLogger().info("Using cron schedule: " + cronString);
                this.plugin.getLogger().info("Using timezone: " + this.timezone.getID());
            }
        }
        catch (ParseException e) {
            this.plugin.getLogger().severe("Invalid cron expression in config! Using default: 0 0 0 * * ?");
            try {
                this.cronExpression = new CronExpression("0 0 0 * * ?");
                this.timezone = TimeZone.getDefault();
                this.cronExpression.setTimeZone(this.timezone);
            }
            catch (ParseException ex) {
                this.plugin.getLogger().severe("Critical error initializing cron scheduler: " + ex.getMessage());
            }
        }
    }

    public void translateCheckTimeToText() {
        try {
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ));
            Cron cron = parser.parse(this.cronExpression.toString());
            cron.validate();
            CronDescriptor descriptor = CronDescriptor.instance(Locale.ENGLISH);
            this.checkTimeToText = descriptor.describe(cron);
        }
        catch (Exception e) {
            this.checkTimeToText = "Invalid Quartz cron expression";
        }
    }

    private void scheduleNextReset() {
        this.cancelIntervalTask();
        Date oldSchedule = Objects.requireNonNullElseGet(this.nextIntervalReset, Date::new);
        this.nextIntervalReset = this.cronExpression.getNextValidTimeAfter(oldSchedule);
        long delayInMillis = this.nextIntervalReset.getTime() - oldSchedule.getTime();
        long delayInTicks = Math.max(20L, delayInMillis / 50L);
        if (JoinStreaksManager.getInstance().getRewardRegistry().isEmpty() && this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
            this.plugin.getLogger().info("No active rewards found, but scheduler will continue running to track absolute join streaks.");
        }
        if (this.plugin.getConfiguration().getBoolean("streak-check-verbose").booleanValue()) {
            this.plugin.getLogger().info("Next join streak interval reset scheduled for: " + String.valueOf(this.nextIntervalReset) + " (in " + Utils.ticksToFormattedPlaytime(delayInTicks) + ")");
        }
        this.intervalTask = new BukkitRunnable(){

            public void run() {
                CycleScheduler.this.playersJoinedDuringCurrentCycle.clear();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)CycleScheduler.this.plugin, () -> JoinStreaksManager.getInstance().resetMissingPlayerStreaksAsync());
                CycleScheduler.this.scheduleNextReset();
            }
        }.runTaskLater((Plugin)this.plugin, delayInTicks);
    }

    public void cancelIntervalTask() {
        if (this.intervalTask != null) {
            this.intervalTask.cancel();
            this.intervalTask = null;
        }
    }

    public boolean isEligibleForStreak(OnlineUser user) {
        if (!this.isCurrentCycle()) {
            this.playersJoinedDuringCurrentCycle.clear();
        }
        if (this.playersJoinedDuringCurrentCycle.contains(user.getUuid())) {
            return false;
        }
        long secondsBetween = Duration.between(user.getLastSeen(), Instant.now()).getSeconds();
        return secondsBetween <= this.exactIntervalSeconds * (long)this.plugin.getConfiguration().getInt("reset-joinstreak.missed-joins").intValue();
    }

    public boolean isCurrentCycle() {
        Date now = new Date();
        Date previousReset = this.cronExpression.getTimeAfter(new Date(now.getTime() - this.exactIntervalSeconds * 1000L));
        return now.after(previousReset) && now.before(this.nextIntervalReset);
    }

    public Map<String, Object> getNextSchedule() {
        HashMap<String, Object> scheduleInfo = new HashMap<String, Object>();
        if (this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            scheduleInfo.put("nextReset", this.nextIntervalReset);
            Date now = new Date();
            long delayInMillis = this.nextIntervalReset.getTime() - now.getTime();
            long delayInTicks = Math.max(20L, delayInMillis / 50L);
            scheduleInfo.put("timeRemaining", Utils.ticksToFormattedPlaytime(delayInTicks));
        } else {
            scheduleInfo.put("nextReset", null);
            scheduleInfo.put("timeRemaining", "-");
        }
        scheduleInfo.put("timeCheckToText", this.checkTimeToText);
        return scheduleInfo;
    }

    public void updateOnReload() {
        Date now = new Date();
        this.nextIntervalReset = this.cronExpression.getNextValidTimeAfter(now);
        if (!this.isCurrentCycle()) {
            this.playersJoinedDuringCurrentCycle.clear();
        }
        if (!this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
            return;
        }
        try {
            Set<String> playersWithStreaks = this.db.getStreakDAO().getPlayersWithActiveStreaks();
            Date cycleStartDate = new Date(this.nextIntervalReset.getTime() - this.exactIntervalSeconds * 1000L);
            for (String playerUUID : playersWithStreaks) {
                DBUsersManager.getInstance().getUserFromUUIDAsyncWithContext(playerUUID, "add players to current active cycle time window", dbUser -> {
                    if (dbUser == null || dbUser.getLastSeen() == null) {
                        return;
                    }
                    Date lastSeenDate = Date.from(dbUser.getLastSeen().atZone(ZoneId.systemDefault()).toInstant());
                    if (lastSeenDate.after(cycleStartDate) && lastSeenDate.before(this.nextIntervalReset)) {
                        Set<String> set = this.playersJoinedDuringCurrentCycle;
                        synchronized (set) {
                            this.playersJoinedDuringCurrentCycle.add(playerUUID);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error processing players during reload: " + e.getMessage());
        }
    }

    public void markPlayerJoinedInCurrentCycle(String uuid) {
        this.playersJoinedDuringCurrentCycle.add(uuid);
    }

    public long getIntervalSeconds() {
        return this.exactIntervalSeconds;
    }

    public void cleanUp() {
        this.cancelIntervalTask();
        this.playersJoinedDuringCurrentCycle.clear();
    }
}

