/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.JoinStreaks.ManagingClasses;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import me.thegabro.playtimemanager.Customizations.CommandsConfiguration;
import me.thegabro.playtimemanager.JoinStreaks.Models.RewardSubInstance;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class RewardMessageService {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final CommandsConfiguration config = CommandsConfiguration.getInstance();

    public void sendRewardRelatedMessage(OnlineUser user, RewardSubInstance subInstance, String message, int delaySeconds) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("%PLAYER_NAME%", user.getNickname());
        replacements.put("%REQUIRED_JOINS%", String.valueOf(subInstance.requiredJoins()));
        replacements.put("%JOIN_STREAK%", String.valueOf(subInstance.requiredJoins()));
        Component finalMessage = Utils.parseColors(this.replacePlaceholders(message, replacements));
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> user.getPlayerInstance().sendMessage(finalMessage), (long)delaySeconds * 20L);
    }

    public void sendScheduleActivationMessage(CommandSender sender, boolean activated) {
        if (activated) {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The join streak check schedule has been activated"));
        } else {
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " The join streak check schedule has been deactivated"));
        }
    }

    public void sendNextResetMessage(CommandSender sender, Map<String, Object> scheduleInfo) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        if (scheduleInfo.get("nextReset") != null) {
            Date nextReset = (Date)scheduleInfo.get("nextReset");
            String timeRemaining = (String)scheduleInfo.get("timeRemaining");
            sender.sendMessage(Utils.parseColors(this.config.getString("prefix") + " Next join streak interval reset scheduled for: &e" + formatter.format(nextReset.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()) + "&7 (in &e" + timeRemaining + "&7)"));
        }
    }

    private String replacePlaceholders(String input, Map<String, String> replacements) {
        String result = input;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

