/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import me.thegabro.playtimemanager.PlayTimeManager;

public class DatabaseBackupUtility {
    private static DatabaseBackupUtility instance;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private static final int BUFFER_SIZE = 1024;

    private DatabaseBackupUtility() {
    }

    public static DatabaseBackupUtility getInstance() {
        if (instance == null) {
            instance = new DatabaseBackupUtility();
        }
        return instance;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File createBackup(String readme) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        String backupFileName = "backup_" + timestamp + ".zip";
        File dataFolder = this.plugin.getDataFolder();
        File backupFolder = new File(dataFolder, "backups");
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        File backupFile = new File(backupFolder, backupFileName);
        try (FileOutputStream fos = new FileOutputStream(backupFile);){
            File file;
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                this.addTextToZip(readme, zos);
                for (File file2 : dataFolder.listFiles()) {
                    if (file2.getName().equalsIgnoreCase("backups")) continue;
                    this.addToZipRecursively(file2, dataFolder, "PlayTimeManager/", zos);
                }
                file = backupFile;
            }
            return file;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Backup creation failed: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void addToZipRecursively(File file, File baseFolder, String prefix, ZipOutputStream zos) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.addToZipRecursively(child, baseFolder, prefix, zos);
            }
        } else {
            String name = file.getName();
            if (name.endsWith(".db-shm") || name.endsWith(".db-wal")) {
                return;
            }
            String relativePath = baseFolder.toPath().relativize(file.toPath()).toString().replace("\\", "/");
            String entryName = prefix + relativePath;
            try (FileInputStream fis = new FileInputStream(file);){
                int len;
                ZipEntry ze = new ZipEntry(entryName);
                zos.putNextEntry(ze);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    private void addTextToZip(String content, ZipOutputStream zos) throws IOException {
        ZipEntry ze = new ZipEntry("README.txt");
        zos.putNextEntry(ze);
        zos.write(content.getBytes());
        zos.closeEntry();
    }
}

