/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final Plugin plugin;
    private final String modrinthProjectId;
    private final String githubOwner;
    private final String githubRepo;
    private final String currentVersion;
    private String latestVersion = null;
    private long lastCheckTime = 0L;
    private final Set<String> notifiedPlayers = new HashSet<String>();
    private static final long CHECK_INTERVAL = TimeUnit.DAYS.toMillis(1L);

    public UpdateChecker(Plugin plugin, String modrinthProjectId, String githubOwner, String githubRepo, String currentVersion) {
        this.plugin = plugin;
        this.modrinthProjectId = modrinthProjectId;
        this.githubOwner = githubOwner;
        this.githubRepo = githubRepo;
        this.currentVersion = currentVersion;
    }

    public void start() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.checkForUpdates();
        Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, this::checkForUpdates, 72000L, 1728000L);
    }

    public void checkForUpdates() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCheckTime < CHECK_INTERVAL && this.latestVersion != null) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            this.checkModrinth();
            this.lastCheckTime = currentTime;
            if (this.isNewerVersion(this.latestVersion, this.currentVersion)) {
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    this.logUpdateAvailable();
                    this.notifiedPlayers.clear();
                });
            }
        });
    }

    private void checkModrinth() {
        try {
            String apiUrl = "https://api.modrinth.com/v2/project/" + this.modrinthProjectId + "/version";
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", this.plugin.getName() + "/" + this.currentVersion);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonArray versions = JsonParser.parseString((String)response.toString()).getAsJsonArray();
                if (!versions.isEmpty()) {
                    JsonObject latestVersionObj = versions.get(0).getAsJsonObject();
                    this.latestVersion = latestVersionObj.get("version_number").getAsString();
                    connection.disconnect();
                }
            }
            connection.disconnect();
        }
        catch (Exception e) {
            this.checkGitHub();
        }
    }

    private void checkGitHub() {
        try {
            String apiUrl = "https://api.github.com/repos/" + this.githubOwner + "/" + this.githubRepo + "/releases/latest";
            URL url = new URL(apiUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", this.plugin.getName() + "/" + this.currentVersion);
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonObject release = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                String tagName = release.get("tag_name").getAsString();
                this.latestVersion = tagName.replaceFirst("^v", "");
                connection.disconnect();
                return;
            }
            connection.disconnect();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to check for updates");
        }
    }

    private boolean isNewerVersion(String newVersion, String oldVersion) {
        if (newVersion == null || oldVersion == null) {
            return false;
        }
        String[] newParts = newVersion.replaceAll("[^0-9.]", "").split("\\.");
        String[] oldParts = oldVersion.replaceAll("[^0-9.]", "").split("\\.");
        int maxLength = Math.max(newParts.length, oldParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int oldPart;
            int newPart = i < newParts.length ? this.parseVersionPart(newParts[i]) : 0;
            int n = oldPart = i < oldParts.length ? this.parseVersionPart(oldParts[i]) : 0;
            if (newPart > oldPart) {
                return true;
            }
            if (newPart >= oldPart) continue;
            return false;
        }
        return false;
    }

    private int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void logUpdateAvailable() {
        this.plugin.getLogger().warning("========================================");
        this.plugin.getLogger().warning("A new PlayTimeManager update is available!");
        this.plugin.getLogger().warning("Current version: " + this.currentVersion);
        this.plugin.getLogger().warning("Latest version: " + this.latestVersion);
        this.plugin.getLogger().warning("Download: https://modrinth.com/plugin/" + this.modrinthProjectId + "/version/" + this.latestVersion);
        this.plugin.getLogger().warning("========================================");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if (this.notifiedPlayers.contains(player.getName())) {
            return;
        }
        if (this.isNewerVersion(this.latestVersion, this.currentVersion)) {
            this.notifiedPlayers.add(player.getName());
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                player.sendMessage(Utils.parseColors(""));
                player.sendMessage(Utils.parseColors("&#FFD700\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
                player.sendMessage(Utils.parseColors("&#FF9100&l[&#FF9E0AP&#FFAC15l&#FFBA1Fa&#FFC82Ay&#FFD535T&#FFE33Fi&#FFF14Am&#FFFF55e&#FFF14AM&#FFE33Fa&#FFD535n&#FFC82Aa&#FFBA1Fg&#FFAC15e&#FF9E0Ar&#FF9100]"));
                player.sendMessage(Utils.parseColors(""));
                player.sendMessage(Utils.parseColors("&#00FF00\u2726 &#55FF55&lA NEW UPDATE IS AVAILABLE! &#00FF00\u2726"));
                player.sendMessage(Utils.parseColors(""));
                player.sendMessage(Utils.parseColors("&#AAAAAACurrent: &#FF5555&l" + this.currentVersion + " &r&#FFAA00\u27a4 &#AAAAAALatest: &#00FF00&l" + this.latestVersion));
                player.sendMessage(Utils.parseColors(""));
                player.sendMessage(Utils.parseColors("&#FFD700\u25b6 &#55FFFFClick here to download &#FFD700\u25c0").clickEvent(ClickEvent.openUrl((String)("https://modrinth.com/plugin/" + this.modrinthProjectId + "/version/" + this.latestVersion))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"\u00a76\u00a7lClick to open Modrinth!"))));
                player.sendMessage(Utils.parseColors("&#FFD700\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac"));
                player.sendMessage(Utils.parseColors(""));
            }, 40L);
        }
    }
}

