/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version321to33Updater {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DatabaseHandler database = DatabaseHandler.getInstance();

    public void performUpgrade() {
        this.addFirstJoinColumn();
        this.recreateConfigFile();
    }

    public void addFirstJoinColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN first_join DATETIME DEFAULT NULL");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    private void recreateConfigFile() {
        Configuration.getInstance().updateConfig(true);
    }
}

