/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version332to34Updater {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DatabaseHandler database = DatabaseHandler.getInstance();

    public void performUpgrade() {
        this.addRelativeJoinStreakColumn();
        this.addAbsoluteJoinStreakColumn();
        this.addReceivedRewardsColumn();
        this.addRewardsToBeClaimedColumn();
        this.recreateConfigFile();
    }

    public void addRelativeJoinStreakColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN relative_join_streak INT DEFAULT 0;");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    public void addAbsoluteJoinStreakColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN absolute_join_streak INT DEFAULT 0;");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    public void addReceivedRewardsColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN received_rewards TEXT DEFAULT '';");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                this.plugin.getLogger().severe("Failed to add received_rewards column: " + e.getMessage());
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Database error during received_rewards column addition: " + e.getMessage());
        }
    }

    public void addRewardsToBeClaimedColumn() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN rewards_to_be_claimed TEXT DEFAULT '';");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                this.plugin.getLogger().severe("Failed to add rewards_to_be_claimed column: " + e.getMessage());
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Database error during rewards_to_be_claimed column addition: " + e.getMessage());
        }
    }

    private void recreateConfigFile() {
        Configuration.getInstance().updateConfig(true);
    }
}

