/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Database.DatabaseHandler;
import me.thegabro.playtimemanager.PlayTimeManager;

public class Version36to361Updater {
    public void performUpgrade() {
        this.fix_tables();
        this.recreateConfigFile();
    }

    public void recreateConfigFile() {
        Configuration.getInstance().updateConfig(false);
    }

    private void fix_tables() {
        DatabaseHandler db = DatabaseHandler.getInstance();
        try (Connection conn = db.getConnection();){
            this.fixCompletedGoals(conn);
            this.fixReceivedRewards(conn);
            this.fixRewardsToBeClaimed(conn);
            PlayTimeManager.getInstance().getLogger().info("Successfully fixed inconsistent nicknames in database tables");
        }
        catch (SQLException e) {
            PlayTimeManager.getInstance().getLogger().log(Level.SEVERE, "Failed to fix database tables", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixCompletedGoals(Connection conn) throws SQLException {
        String findDuplicatesQuery = "SELECT user_uuid, nickname, MAX(completed_at) as latest_completion FROM completed_goals GROUP BY user_uuid HAVING COUNT(DISTINCT nickname) > 1";
        String updateQuery = "UPDATE completed_goals SET nickname = ? WHERE user_uuid = ? AND nickname != ?";
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(findDuplicatesQuery);
             PreparedStatement updateStmt = conn.prepareStatement(updateQuery);){
            while (rs.next()) {
                String uuid = rs.getString("user_uuid");
                String getLatestNicknameQuery = "SELECT nickname FROM completed_goals WHERE user_uuid = ? ORDER BY completed_at DESC LIMIT 1";
                PreparedStatement latestStmt = conn.prepareStatement(getLatestNicknameQuery);
                try {
                    latestStmt.setString(1, uuid);
                    ResultSet latestRs = latestStmt.executeQuery();
                    try {
                        if (!latestRs.next()) continue;
                        String correctNickname = latestRs.getString("nickname");
                        updateStmt.setString(1, correctNickname);
                        updateStmt.setString(2, uuid);
                        updateStmt.setString(3, correctNickname);
                        updateStmt.executeUpdate();
                    }
                    finally {
                        if (latestRs == null) continue;
                        latestRs.close();
                    }
                }
                finally {
                    if (latestStmt == null) continue;
                    latestStmt.close();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixReceivedRewards(Connection conn) throws SQLException {
        String findDuplicatesQuery = "SELECT user_uuid, nickname, MAX(received_at) as latest_receipt FROM received_rewards GROUP BY user_uuid HAVING COUNT(DISTINCT nickname) > 1";
        String updateQuery = "UPDATE received_rewards SET nickname = ? WHERE user_uuid = ? AND nickname != ?";
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(findDuplicatesQuery);
             PreparedStatement updateStmt = conn.prepareStatement(updateQuery);){
            while (rs.next()) {
                String uuid = rs.getString("user_uuid");
                String getLatestNicknameQuery = "SELECT nickname FROM received_rewards WHERE user_uuid = ? ORDER BY received_at DESC LIMIT 1";
                PreparedStatement latestStmt = conn.prepareStatement(getLatestNicknameQuery);
                try {
                    latestStmt.setString(1, uuid);
                    ResultSet latestRs = latestStmt.executeQuery();
                    try {
                        if (!latestRs.next()) continue;
                        String correctNickname = latestRs.getString("nickname");
                        updateStmt.setString(1, correctNickname);
                        updateStmt.setString(2, uuid);
                        updateStmt.setString(3, correctNickname);
                        updateStmt.executeUpdate();
                    }
                    finally {
                        if (latestRs == null) continue;
                        latestRs.close();
                    }
                }
                finally {
                    if (latestStmt == null) continue;
                    latestStmt.close();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixRewardsToBeClaimed(Connection conn) throws SQLException {
        String findDuplicatesQuery = "SELECT user_uuid, nickname, MAX(created_at) as latest_creation FROM rewards_to_be_claimed GROUP BY user_uuid HAVING COUNT(DISTINCT nickname) > 1";
        String updateQuery = "UPDATE rewards_to_be_claimed SET nickname = ? WHERE user_uuid = ? AND nickname != ?";
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(findDuplicatesQuery);
             PreparedStatement updateStmt = conn.prepareStatement(updateQuery);){
            while (rs.next()) {
                String uuid = rs.getString("user_uuid");
                String getLatestNicknameQuery = "SELECT nickname FROM rewards_to_be_claimed WHERE user_uuid = ? ORDER BY created_at DESC LIMIT 1";
                PreparedStatement latestStmt = conn.prepareStatement(getLatestNicknameQuery);
                try {
                    latestStmt.setString(1, uuid);
                    ResultSet latestRs = latestStmt.executeQuery();
                    try {
                        if (!latestRs.next()) continue;
                        String correctNickname = latestRs.getString("nickname");
                        updateStmt.setString(1, correctNickname);
                        updateStmt.setString(2, uuid);
                        updateStmt.setString(3, correctNickname);
                        updateStmt.executeUpdate();
                    }
                    finally {
                        if (latestRs == null) continue;
                        latestRs.close();
                    }
                }
                finally {
                    if (latestStmt == null) continue;
                    latestStmt.close();
                }
            }
            return;
        }
    }
}

