/*
 * Decompiled with CFR 0.152.
 */
package Users;

import SQLiteDB.PlayTimeDatabase;
import java.util.ArrayList;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class DBUser {
    protected String uuid;
    protected String nickname;
    protected long DBplaytime;
    protected long artificialPlaytime;
    protected static final PlayTimeManager plugin = PlayTimeManager.getInstance();
    protected long fromServerOnJoinPlayTime;
    protected ArrayList<String> completedGoals;
    protected static PlayTimeDatabase db = plugin.getDatabase();

    private DBUser(String uuid, String nickname, long playtime, long artificialPlaytime, ArrayList<String> completedGoals) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.DBplaytime = playtime;
        this.artificialPlaytime = artificialPlaytime;
        this.completedGoals = completedGoals;
    }

    public DBUser(Player p) {
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.uuid = p.getUniqueId().toString();
        this.nickname = p.getName();
        this.userMapping();
        this.DBplaytime = db.getPlaytime(this.uuid);
        this.artificialPlaytime = db.getArtificialPlaytime(this.uuid);
        this.completedGoals = db.getCompletedGoals(this.uuid);
    }

    protected static DBUser fromUUID(String uuid) {
        String nickname = db.getNickname(uuid);
        if (uuid == null) {
            return null;
        }
        long playtime = db.getPlaytime(uuid);
        long artificialPlaytime = db.getArtificialPlaytime(uuid);
        ArrayList completedGoals = db.getCompletedGoals(uuid);
        return new DBUser(uuid, nickname, playtime, artificialPlaytime, completedGoals);
    }

    public void reset() {
        this.DBplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        this.completedGoals.clear();
        db.updatePlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public long getPlaytime() {
        return this.DBplaytime + this.artificialPlaytime;
    }

    public long getArtificialPlaytime() {
        return this.artificialPlaytime;
    }

    public void setArtificialPlaytime(long artificialPlaytime) {
        this.artificialPlaytime = artificialPlaytime;
        db.updateArtificialPlaytime(this.uuid, artificialPlaytime);
    }

    public boolean hasCompletedGoal(String goalName) {
        return this.completedGoals.contains(goalName);
    }

    public void markGoalAsCompleted(String goalName) {
        this.completedGoals.add(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    public void unmarkGoalAsCompleted(String goalName) {
        this.completedGoals.remove(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    private void userMapping() {
        if (db.playerExists(this.uuid)) {
            if (!db.getNickname(this.uuid).equals(this.nickname)) {
                db.updateNickname(this.uuid, this.nickname);
            }
        } else {
            db.addNewPlayer(this.uuid, this.nickname, this.fromServerOnJoinPlayTime);
        }
    }
}

