/*
 * Decompiled with CFR 0.152.
 */
package Users;

import ExternalPluginSupport.LuckPermsManager;
import Goals.Goal;
import Goals.GoalsManager;
import Users.OnlineUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class OnlineUsersManager {
    private static volatile OnlineUsersManager instance;
    private BukkitTask goalSchedule;
    private BukkitTask dbUpdateSchedule;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final Map<String, OnlineUser> onlineUsersByName = new ConcurrentHashMap<String, OnlineUser>();
    private final Map<String, OnlineUser> onlineUsersByUUID = new ConcurrentHashMap<String, OnlineUser>();
    private final Map<String, String> goalMessageReplacements = new HashMap<String, String>();
    private static final int DB_UPDATE_INTERVAL = 6000;
    private static final String TIME_FORMAT_DAYS = "%dd, %dh, %dm, %ds";
    private static final String TIME_FORMAT_HOURS = "%dh, %dm, %ds";
    private static final String TIME_FORMAT_MINUTES = "%dm, %ds";
    private static final String TIME_FORMAT_SECONDS = "%ds";

    private OnlineUsersManager() {
        this.loadOnlineUsers();
        this.startGoalCheckSchedule();
        this.startDBUpdateSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OnlineUsersManager getInstance() {
        if (instance != null) return instance;
        Class<OnlineUsersManager> clazz = OnlineUsersManager.class;
        synchronized (OnlineUsersManager.class) {
            if (instance != null) return instance;
            instance = new OnlineUsersManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.put(onlineUser.getNickname().toLowerCase(), onlineUser);
        this.onlineUsersByUUID.put(onlineUser.getUuid(), onlineUser);
    }

    public void removeOnlineUser(OnlineUser onlineUser) {
        this.onlineUsersByName.remove(onlineUser.getNickname().toLowerCase());
        this.onlineUsersByUUID.remove(onlineUser.getUuid());
    }

    private void loadOnlineUsers() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            OnlineUser onlineUser = new OnlineUser((Player)player);
            this.addOnlineUser(onlineUser);
        });
    }

    public OnlineUser getOnlineUser(String nickname) {
        return this.onlineUsersByName.get(nickname.toLowerCase());
    }

    public OnlineUser getOnlineUserByUUID(String uuid) {
        return this.onlineUsersByUUID.get(uuid);
    }

    public void startGoalCheckSchedule() {
        Set goals;
        if (this.goalSchedule != null) {
            this.goalSchedule.cancel();
        }
        if ((goals = GoalsManager.getGoals()).isEmpty() || GoalsManager.areAllInactive()) {
            this.plugin.getLogger().info("No active goals found. Goal check schedule not started.");
            return;
        }
        this.goalSchedule = new /* Unavailable Anonymous Inner Class!! */.runTaskTimer((Plugin)this.plugin, 0L, this.plugin.getConfiguration().getGoalsCheckRate() * 20L);
    }

    private void checkGoalsForAllUsers(Set<Goal> goals) {
        if (this.plugin.getConfiguration().getGoalsCheckVerbose()) {
            this.logVerboseInfo();
        }
        this.onlineUsersByName.values().forEach(onlineUser -> {
            Player player = Bukkit.getPlayerExact((String)onlineUser.getNickname());
            if (player != null) {
                this.checkGoalsForUser((OnlineUser)onlineUser, player, goals);
            }
        });
    }

    private void checkGoalsForUser(OnlineUser onlineUser, Player player, Set<Goal> goals) {
        goals.stream().filter(Goal::isActive).filter(goal -> !onlineUser.hasCompletedGoal(goal.getName())).filter(goal -> onlineUser.getPlaytime() >= goal.getTime()).forEach(goal -> this.processCompletedGoal(onlineUser, player, (Goal)goal));
    }

    private void processCompletedGoal(OnlineUser onlineUser, Player player, Goal goal) {
        onlineUser.markGoalAsCompleted(goal.getName());
        if (this.plugin.isPermissionsManagerConfigured()) {
            this.assignPermissionsForGoal(onlineUser, goal);
        }
        this.executeCommands(goal, player);
        this.playGoalSound(player, goal);
        this.sendGoalMessage(player, goal);
        this.plugin.getLogger().info(String.format("User %s has reached %s!", onlineUser.getNickname(), this.convertTime(goal.getTime() / 20L)));
    }

    private void startDBUpdateSchedule() {
        if (this.dbUpdateSchedule != null) {
            this.dbUpdateSchedule.cancel();
        }
        this.dbUpdateSchedule = new /* Unavailable Anonymous Inner Class!! */.runTaskTimer((Plugin)this.plugin, 0L, 6000L);
    }

    public void updateAllOnlineUsersPlaytime() {
        this.onlineUsersByName.values().forEach(user -> {
            try {
                user.updateDB();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to update playtime for user %s: %s", user.getNickname(), e.getMessage()));
            }
        });
    }

    private void assignPermissionsForGoal(OnlineUser onlineUser, Goal goal) {
        ArrayList permissions = goal.getPermissions();
        if (permissions != null && !permissions.isEmpty()) {
            try {
                LuckPermsManager.getInstance((PlayTimeManager)this.plugin).assignGoalPermissions(onlineUser.getUuid(), goal);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe(String.format("Failed to assign permissions for goal %s to player %s: %s", goal.getName(), onlineUser.getNickname(), e.getMessage()));
            }
        }
    }

    private void executeCommands(Goal goal, Player player) {
        ArrayList commands = goal.getCommands();
        if (commands != null && !commands.isEmpty()) {
            commands.forEach(command -> {
                try {
                    String formattedCommand = this.formatCommand((String)command, player);
                    if (this.plugin.getConfiguration().getGoalsCheckVerbose()) {
                        this.plugin.getLogger().info("Executing command: " + formattedCommand);
                    }
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), formattedCommand);
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to execute command for goal %s: %s", goal.getName(), e.getMessage()));
                }
            });
        }
    }

    private String formatCommand(String command, Player player) {
        this.goalMessageReplacements.put("PLAYER_NAME", player.getName());
        return this.replacePlaceholders(command).replaceFirst("/", "");
    }

    private void playGoalSound(Player player, Goal goal) {
        try {
            Sound sound = Sound.valueOf((String)goal.getGoalSound());
            player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().severe(String.format("%s is not a valid sound in %s.yml", goal.getGoalSound(), goal.getName()));
        }
    }

    private void sendGoalMessage(Player player, Goal goal) {
        this.goalMessageReplacements.put("%PLAYER_NAME%", player.getName());
        this.goalMessageReplacements.put("%TIME_REQUIRED%", this.convertTime(goal.getTime() / 20L));
        player.sendMessage(this.replacePlaceholders(goal.getGoalMessage()));
    }

    private String convertTime(long seconds) {
        int days = (int)TimeUnit.SECONDS.toDays(seconds);
        int hours = (int)(TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days));
        int minutes = (int)(TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.HOURS.toMinutes(hours) - TimeUnit.DAYS.toMinutes(days));
        int secs = (int)(TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.MINUTES.toSeconds(minutes) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.DAYS.toSeconds(days));
        if (days > 0) {
            return String.format(TIME_FORMAT_DAYS, days, hours, minutes, secs);
        }
        if (hours > 0) {
            return String.format(TIME_FORMAT_HOURS, hours, minutes, secs);
        }
        if (minutes > 0) {
            return String.format(TIME_FORMAT_MINUTES, minutes, secs);
        }
        return String.format(TIME_FORMAT_SECONDS, secs);
    }

    private String replacePlaceholders(String input) {
        String result = input;
        for (Map.Entry<String, String> entry : this.goalMessageReplacements.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        this.goalMessageReplacements.clear();
        return result;
    }

    private void logVerboseInfo() {
        this.plugin.getLogger().info(String.format("Goal check schedule started, refresh rate is %s", this.convertTime(this.plugin.getConfiguration().getGoalsCheckRate())));
    }

    public void stopSchedules() {
        Optional.ofNullable(this.goalSchedule).ifPresent(BukkitTask::cancel);
        Optional.ofNullable(this.dbUpdateSchedule).ifPresent(BukkitTask::cancel);
    }
}

